<?php
/**
 * The main template file
 */

	get_header();


	if( is_tax('portfolio_category') || is_tax('portfolio_tag') && class_exists('gdlr_core_pb_element_portfolio') ){
		$post_type = 'portfolio';

		$sidebar_type = corzo_get_option('general', 'archive-portfolio-sidebar', 'none');
		$sidebar_left = corzo_get_option('general', 'archive-portfolio-sidebar-left');
		$sidebar_right = corzo_get_option('general', 'archive-portfolio-sidebar-right');		
	}else{
		$post_type = 'post';

		$sidebar_type = corzo_get_option('general', 'archive-blog-sidebar', 'none');
		$sidebar_left = corzo_get_option('general', 'archive-blog-sidebar-left');
		$sidebar_right = corzo_get_option('general', 'archive-blog-sidebar-right');
	}

	if( $sidebar_type == 'left' && !is_active_sidebar($sidebar_left) ){
		$sidebar_type = 'none';
	}
	if( $sidebar_type == 'right' && !is_active_sidebar($sidebar_right) ){
		$sidebar_type = 'none';
	}
	
	echo '<div class="corzo-content-container corzo-container">';
	echo '<div class="' . esc_attr(corzo_get_sidebar_wrap_class($sidebar_type)) . '" >';

	// sidebar content
	echo '<div class="' . esc_attr(corzo_get_sidebar_class(array('sidebar-type'=>$sidebar_type, 'section'=>'center'))) . '" >';
	
	if( $post_type == 'portfolio' && class_exists('gdlr_core_pb_element_portfolio') ){

		get_template_part('content/archive', 'portfolio');

	}else if( class_exists('gdlr_core_pb_element_blog') ){

		get_template_part('content/archive', 'blog');
		
	}else{

		get_template_part('content/archive', 'default');
		
	}

	echo '</div>'; // corzo-get-sidebar-class

	// sidebar left
	if( $sidebar_type == 'left' || $sidebar_type == 'both' ){
		echo corzo_get_sidebar($sidebar_type, 'left', $sidebar_left);
	}

	// sidebar right
	if( $sidebar_type == 'right' || $sidebar_type == 'both' ){
		echo corzo_get_sidebar($sidebar_type, 'right', $sidebar_right);
	}

	echo '</div>'; // corzo-get-sidebar-wrap-class
 	echo '</div>'; // corzo-content-container


	get_footer(); 
?>