<?php
/**
 * The template part for displaying single post title
 */

	$blog_date = corzo_get_option('general', 'blog-date-feature', '');
	$blog_style = corzo_get_option('general', 'blog-style', 'style-1');
	$blog_title_style = corzo_get_option('general', 'blog-title-style', '');
	if( empty($blog_title_style) ){
		if( in_array($blog_style, array('style-3', 'magazine')) ){
			$blog_title_style = 'style-1';
		}else{
			$blog_title_style = $blog_style;
		}
	}

	$blog_info_atts = array( 'wrapper' => true );
	$blog_info_atts['display'] = corzo_get_option('general', 'meta-option', '');
	if( empty($blog_date) && empty($blog_info_atts['display']) ){
		$blog_info_atts['display'] = array('author', 'category', 'tag', 'comment-number');
	}

	echo '<header class="corzo-single-article-head corzo-single-blog-title-' . esc_attr($blog_title_style) . ' clearfix" >';
	if( $blog_title_style == 'style-1' && (empty($blog_date) || $blog_date == 'enable') ){
		echo '<div class="corzo-single-article-date-wrapper  post-date updated">';
		echo '<div class="corzo-single-article-date-day">' .  get_the_time('d') . '</div>';
		echo '<div class="corzo-single-article-date-month">' . get_the_time('M') . '</div>';

		$blog_date_year = corzo_get_option('general', 'blog-date-feature-year', '');
		if( !empty($blog_date_year) && $blog_date_year == 'enable' ){
			echo '<div class="corzo-single-article-date-year">' . get_the_time('Y') . '</div>';
		} 
		echo '</div>';
	}else if( $blog_title_style == 'style-2'){
		$blog_info_atts['separator'] = '•';
		echo corzo_get_blog_info($blog_info_atts);
	}

	echo '<div class="corzo-single-article-head-right">';
	if( is_single() ){
		echo '<h1 class="corzo-single-article-title">' . get_the_title() . '</h1>';
	}else{
		echo '<h3 class="corzo-single-article-title"><a href="' . get_permalink() . '" >' . get_the_title() . '</a></h3>';
	}

	if( $blog_title_style == 'style-1' ){
		echo corzo_get_blog_info($blog_info_atts);
	}else if( $blog_title_style == 'style-4' ){
		$blog_info_atts['separator'] = '•';
		echo corzo_get_blog_info($blog_info_atts);
	}

	$post_option = corzo_get_post_option(get_the_ID());
	if( !empty($post_option['blog-title-divider']) ){
		$enable_divider = $post_option['blog-title-divider'];
	}else{
		$enable_divider = corzo_get_option('general', 'blog-title-divider', 'enable');
	}
	if( $enable_divider == 'enable' ){
		echo '<div class="corzo-single-article-head-divider" ></div>';
	}
	echo '</div>';
	echo '</header>';