<?php
	/*	
	*	Goodlayers Function File
	*	---------------------------------------------------------------------
	*	This file include all of important function and features of the theme
	*	---------------------------------------------------------------------
	*/
	
	// goodlayers core plugin function
	include_once(get_template_directory() . '/admin/core/sidebar-generator.php');
	include_once(get_template_directory() . '/admin/core/utility.php');
	include_once(get_template_directory() . '/admin/core/media.php' );
	
	// create admin page
	if( is_admin() ){
		include_once(get_template_directory() . '/admin/tgmpa/class-tgm-plugin-activation.php');

		if( !class_exists('gdlr_core_admin_menu') ){
			include_once(get_template_directory() . '/admin/installer/admin-menu.php');	
			gdlr_core_admin_menu::init();
		}
		include_once(get_template_directory() . '/admin/installer/verification.php');
		include_once(get_template_directory() . '/admin/installer/theme-landing.php');
		include_once(get_template_directory() . '/admin/installer/getting-start.php');	
		include_once(get_template_directory() . '/admin/installer/plugin-activation.php');
	}
	
	// plugins
	include_once(get_template_directory() . '/plugins/wpml.php');
	include_once(get_template_directory() . '/plugins/revslider.php');
	
	/////////////////////
	// front end script
	/////////////////////
	
	include_once(get_template_directory() . '/include/header-settings.php' );
	include_once(get_template_directory() . '/include/utility.php' );
	include_once(get_template_directory() . '/include/function-regist.php' );
	include_once(get_template_directory() . '/include/navigation-menu.php' );
	include_once(get_template_directory() . '/include/include-script.php' );
	include_once(get_template_directory() . '/include/goodlayers-core-filter.php' );
	include_once(get_template_directory() . '/include/maintenance.php' );
	include_once(get_template_directory() . '/woocommerce/woocommerce-settings.php' );

	include_once(get_template_directory() . '/include/pb/blog-style.php' );
	
	/////////////////////
	// execute module 
	/////////////////////
	
	// initiate sidebar structure
	$sidebar_heading_tag = corzo_get_option('general', 'sidebar-heading-tag', 'h3');
	$sidebar_atts = array(
		'before_widget' => '<div id="%1$s" class="widget %2$s corzo-widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<' . $sidebar_heading_tag . ' class="corzo-widget-title">',
		'after_title'   => '</' . $sidebar_heading_tag . '><span class="clear"></span>' );

	if( corzo_get_option('general', 'sidebar-title-divider', 'enable') == 'enable' ){
		$sidebar_atts['before_title'] = '<' . $sidebar_heading_tag . ' class="corzo-widget-title corzo-with-divider">';
		$sidebar_atts['after_title'] = '</' . $sidebar_heading_tag . '><span class="clear"></span>';
	}
	new gdlr_core_sidebar_generator($sidebar_atts);

	// clear data for wpml translation
	add_action('init', 'corzo_clear_general_option');
	if( !function_exists('corzo_clear_general_option') ){
		function corzo_clear_general_option(){
			unset($GLOBALS['corzo_general']);
		}	
	}	

	// remove the core default action to enqueue the theme script
	remove_action('after_setup_theme', 'gdlr_init_goodlayers_core_elements');
	add_action('after_setup_theme', 'corzo_init_goodlayers_core_elements');
	if( !function_exists('corzo_init_goodlayers_core_elements') ){
		function corzo_init_goodlayers_core_elements(){

			global $corzo_admin_option;
			
			// create an admin option and customizer
			if( (is_admin() || is_customize_preview()) && class_exists('gdlr_core_admin_option') && class_exists('gdlr_core_theme_customizer') ){
				
				$corzo_admin_option = new gdlr_core_admin_option(array(
					'filewrite' => corzo_get_style_custom(true)
				));	
				
				include_once( get_template_directory() . '/include/options/general.php');
				include_once( get_template_directory() . '/include/options/typography.php');
				include_once( get_template_directory() . '/include/options/color.php');
				include_once( get_template_directory() . '/include/options/plugin-settings.php');

				if( is_customize_preview() ){
					new gdlr_core_theme_customizer($corzo_admin_option);
				}

				// clear an option for customize page
				add_action('wp', 'corzo_clear_option');
				
			}
			
			// add the script for page builder / page options / post option
			if( is_admin() ){

				if( class_exists('gdlr_core_revision') ){
					$revision_num = 5;
					new gdlr_core_revision($revision_num);
				}
				
				// create page option
				if( class_exists('gdlr_core_page_option') ){

					// for page post type
					new gdlr_core_page_option(array(
						'post_type' => array('page'),
						'options' => array(
							'layout' => array(
								'title' => esc_html__('Layout', 'corzo'),
								'options' => array(
									'custom-header' => array(
										'title' => esc_html__('Select Custom Header', 'corzo'),
										'type' => 'combobox',
										'single' => 'gdlr_core_custom_header_id',
										'options' => array('' => esc_html__('Default', 'corzo')) + gdlr_core_get_post_list('gdlr_core_header')
									),
									'enable-header-area' => array(
										'title' => esc_html__('Enable Header Area', 'corzo'),
										'type' => 'checkbox',
										'default' => 'enable'
									),
									'enable-logo' => array(
										'title' => esc_html__('Enable Logo', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo')
										),
										'single' => 'gdlr-enable-logo',
										'condition' => array( 'enable-header-area' => 'enable' )
									),
									'sticky-navigation' => array(
										'title' => esc_html__('Sticky Navigation', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										),
										'condition' => array( 'enable-header-area' => 'enable' )
									),
									'enable-page-title' => array(
										'title' => esc_html__('Enable Page Title', 'corzo'),
										'type' => 'checkbox',
										'default' => 'enable',
										'condition' => array( 'enable-header-area' => 'enable' )
									),
									'page-caption' => array(
										'title' => esc_html__('Caption', 'corzo'),
										'type' => 'textarea',
										'condition' => array( 'enable-header-area' => 'enable', 'enable-page-title' => 'enable' )
									),					
									'title-background' => array(
										'title' => esc_html__('Page Title Background', 'corzo'),
										'type' => 'upload',
										'condition' => array( 'enable-header-area' => 'enable', 'enable-page-title' => 'enable' )
									),
									'enable-breadcrumbs' => array(
										'title' => esc_html__('Enable Breadcrumbs', 'corzo'),
										'type' => 'checkbox',
										'default' => 'disable',
										'condition' => array( 'enable-header-area' => 'enable', 'enable-page-title' => 'enable' )
									),
									'body-background-type' => array(
										'title' => esc_html__('Body Background Type', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'image' => esc_html__('Image ( Only For Boxed Layout )', 'corzo'),
										)
									),
									'body-background-image' => array(
										'title' => esc_html__('Body Background Image', 'corzo'),
										'type' => 'upload',
										'data-type' => 'file', 
										'condition' => array( 'body-background-type' => 'image' )
									),
									'body-background-image-opacity' => array(
										'title' => esc_html__('Body Background Image Opacity', 'corzo'),
										'type' => 'fontslider',
										'data-type' => 'opacity',
										'default' => '100',
										'condition' => array( 'body-background-type' => 'image' )
									),
									'show-content' => array(
										'title' => esc_html__('Show WordPress Editor Content', 'corzo'),
										'type' => 'checkbox',
										'default' => 'enable',
										'description' => esc_html__('Disable this to hide the content in editor to show only page builder content.', 'corzo'),
									),
									'sidebar' => array(
										'title' => esc_html__('Sidebar', 'corzo'),
										'type' => 'radioimage',
										'options' => 'sidebar',
										'default' => 'none',
										'wrapper-class' => 'gdlr-core-fullsize'
									),
									'sidebar-left' => array(
										'title' => esc_html__('Sidebar Left', 'corzo'),
										'type' => 'combobox',
										'options' => 'sidebar',
										'condition' => array( 'sidebar' => array('left', 'both') )
									),
									'sidebar-right' => array(
										'title' => esc_html__('Sidebar Right', 'corzo'),
										'type' => 'combobox',
										'options' => 'sidebar',
										'condition' => array( 'sidebar' => array('right', 'both') )
									),
									'enable-footer' => array(
										'title' => esc_html__('Enable Footer', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										)
									),
									'enable-copyright' => array(
										'title' => esc_html__('Enable Copyright', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										)
									),

								)
							), // layout
							'title' => array(
								'title' => esc_html__('Title Style', 'corzo'),
								'options' => array(

									'title-style' => array(
										'title' => esc_html__('Page Title Style', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'small' => esc_html__('Small', 'corzo'),
											'medium' => esc_html__('Medium', 'corzo'),
											'large' => esc_html__('Large', 'corzo'),
											'custom' => esc_html__('Custom', 'corzo'),
										),
										'default' => 'default'
									),
									'title-divider' => array(
										'title' => esc_html__('Title Divider', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										)
									),
									'title-align' => array(
										'title' => esc_html__('Page Title Alignment', 'corzo'),
										'type' => 'radioimage',
										'options' => 'text-align',
										'with-default' => true,
										'default' => 'default'
									),
									'title-spacing' => array(
										'title' => esc_html__('Page Title Padding', 'corzo'),
										'type' => 'custom',
										'item-type' => 'padding',
										'data-input-type' => 'pixel',
										'options' => array('padding-top', 'padding-bottom', 'caption-top-margin'),
										'wrapper-class' => 'gdlr-core-fullsize gdlr-core-no-link gdlr-core-large',
										'condition' => array( 'title-style' => 'custom' )
									),
									'title-font-size' => array(
										'title' => esc_html__('Page Title Font Size', 'corzo'),
										'type' => 'custom',
										'item-type' => 'padding',
										'data-input-type' => 'pixel',
										'options' => array('title-size', 'title-letter-spacing', 'caption-size', 'caption-letter-spacing'),
										'wrapper-class' => 'gdlr-core-fullsize gdlr-core-no-link gdlr-core-large',
										'condition' => array( 'title-style' => 'custom' )
									),
									'title-font-weight' => array(
										'title' => esc_html__('Page Title Font Weight', 'corzo'),
										'type' => 'custom',
										'item-type' => 'padding',
										'options' => array('title-weight', 'caption-weight'),
										'wrapper-class' => 'gdlr-core-fullsize gdlr-core-no-link gdlr-core-large',
										'condition' => array( 'title-style' => 'custom' )
									),
									'title-font-transform' => array(
										'title' => esc_html__('Page Title Font Transform', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'none' => esc_html__('None', 'corzo'),
											'uppercase' => esc_html__('Uppercase', 'corzo'),
											'lowercase' => esc_html__('Lowercase', 'corzo'),
											'capitalize' => esc_html__('Capitalize', 'corzo'),
										),
										'default' => 'uppercase',
										'condition' => array( 'title-style' => 'custom' )
									),
									'top-bottom-gradient' => array(
										'title' => esc_html__('Title Top/Bottom Gradient', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'both' => esc_html__('Both', 'corzo'),
											'top' => esc_html__('Top', 'corzo'),
											'bottom' => esc_html__('Bottom', 'corzo'),
											'disable' => esc_html__('None', 'corzo'),
										)
									),
									'title-background-overlay-opacity' => array(
										'title' => esc_html__('Page Title Background Overlay Opacity', 'corzo'),
										'type' => 'text',
										'description' => esc_html__('Fill the number between 0.01 - 1 ( Leave Blank For Default Value )', 'corzo'),
										'condition' => array( 'title-style' => 'custom' )
									),
									'title-color' => array(
										'title' => esc_html__('Page Title Color', 'corzo'),
										'type' => 'colorpicker',
									),
									'caption-color' => array(
										'title' => esc_html__('Page Caption Color', 'corzo'),
										'type' => 'colorpicker',
									),
									'title-background-overlay-color' => array(
										'title' => esc_html__('Page Background Overlay Color', 'corzo'),
										'type' => 'colorpicker',
									),

								)
							), // title
							'header' => array(
								'title' => esc_html__('Header', 'corzo'),
								'options' => array(

									'main_menu' => array(
										'title' => esc_html__('Primary Menu', 'corzo'),
										'type' => 'combobox',
										'options' => function_exists('gdlr_core_get_menu_list')? gdlr_core_get_menu_list(): array(),
										'single' => 'gdlr-core-location-main_menu'
									),
									'right_menu' => array(
										'title' => esc_html__('Secondary Menu', 'corzo'),
										'type' => 'combobox',
										'options' => function_exists('gdlr_core_get_menu_list')? gdlr_core_get_menu_list(): array(),
										'single' => 'gdlr-core-location-right_menu'
									),
									'top_bar_menu' => array(
										'title' => esc_html__('Top Bar Menu', 'corzo'),
										'type' => 'combobox',
										'options' => function_exists('gdlr_core_get_menu_list')? gdlr_core_get_menu_list(): array(),
										'single' => 'gdlr-core-location-top_bar_menu'
									),
									'mobile_menu' => array(
										'title' => esc_html__('Mobile Menu', 'corzo'),
										'type' => 'combobox',
										'options' => function_exists('gdlr_core_get_menu_list')? gdlr_core_get_menu_list(): array(),
										'single' => 'gdlr-core-location-mobile_menu'
									),
									
									'header-slider' => array(
										'title' => esc_html__('Header Slider ( Above Navigation )', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'none' => esc_html__('None', 'corzo'),
											'layer-slider' => esc_html__('Layer Slider', 'corzo'),
											'master-slider' => esc_html__('Master Slider', 'corzo'),
											'revolution-slider' => esc_html__('Revolution Slider', 'corzo'),
										),
										'description' => esc_html__('For header style plain / bar / boxed', 'corzo'),
									),
									'layer-slider-id' => array(
										'title' => esc_html__('Choose Layer Slider', 'corzo'),
										'type' => 'combobox',
										'options' => gdlr_core_get_layerslider_list(),
										'condition' => array( 'header-slider' => 'layer-slider' )
									),
									'master-slider-id' => array(
										'title' => esc_html__('Choose Master Slider', 'corzo'),
										'type' => 'combobox',
										'options' => gdlr_core_get_masterslider_list(),
										'condition' => array( 'header-slider' => 'master-slider' )
									),
									'revolution-slider-id' => array(
										'title' => esc_html__('Choose Revolution Slider', 'corzo'),
										'type' => 'combobox',
										'options' => gdlr_core_get_revolution_slider_list(),
										'condition' => array( 'header-slider' => 'revolution-slider' )
									),

								) // header options
							), // header

							'bullet-anchor' => array(
								'title' => esc_html__('Bullet Anchor', 'corzo'),
								'options' => array(
									'bullet-anchor-description' => array(
										'type' => 'description',
										'description' => esc_html__('This feature is used for one page navigation. It will appear on the right side of page. You can put the id of element in \'Anchor Link\' field to let the bullet scroll the page to.', 'corzo')
									),
									'bullet-anchor' => array(
										'title' => esc_html__('Add Anchor', 'corzo'),
										'type' => 'custom',
										'item-type' => 'tabs',
										'options' => array(
											'title' => array(
												'title' => esc_html__('Anchor Link', 'corzo'),
												'type' => 'text',
											),
											'anchor-color' => array(
												'title' => esc_html__('Anchor Color', 'corzo'),
												'type' => 'colorpicker',
											),
											'anchor-hover-color' => array(
												'title' => esc_html__('Anchor Hover Color', 'corzo'),
												'type' => 'colorpicker',
											)
										),
										'wrapper-class' => 'gdlr-core-fullsize'
									),
								)
							),

							'float-social' => array(
								'title' => esc_html__('Float Social', 'corzo'),
								'options' => array(
									'enable-float-social' => array(
										'title' => esc_html__('Enable Float Social', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										)
									),
									'display-float-social-after-page-title' => array(
										'title' => esc_html__('Display Float Social After Page Title', 'corzo'),
										'type' => 'checkbox',
										'options' => array(
											'' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										)
									),
									'float-social' => array(
										'title' => esc_html__('Add Color Section(Use Float Social ID in Wrapper Setting > General Tab)', 'corzo'),
										'type' => 'custom',
										'item-type' => 'tabs',
										'extra' => array(
											'item-title' => esc_html__('Item\'s ID', 'corzo')
										),
										'options' => array(
											'title' => array(
												'title' => esc_html__('Section ID', 'corzo'),
												'type' => 'text',
											),
											'section-color' => array(
												'title' => esc_html__('Social Color', 'corzo'),
												'type' => 'colorpicker',
											),
											'section-hover-color' => array(
												'title' => esc_html__('Social Hover Color', 'corzo'),
												'type' => 'colorpicker',
											)
										),
										'wrapper-class' => 'gdlr-core-fullsize'
									),
								)
							)
						)
					));

					// for post post type
					new gdlr_core_page_option(array(
						'post_type' => array('post'),
						'options' => array(
							'layout' => array(
								'title' => esc_html__('Layout', 'corzo'),
								'options' => array(

									'show-content' => array(
										'title' => esc_html__('Show WordPress Editor Content', 'corzo'),
										'type' => 'checkbox',
										'default' => 'enable',
										'description' => esc_html__('Disable this to hide the content in editor to show only page builder content.', 'corzo'),
									),
									'sidebar' => array(
										'title' => esc_html__('Sidebar', 'corzo'),
										'type' => 'radioimage',
										'options' => 'sidebar',
										'with-default' => true,
										'default' => 'default',
										'wrapper-class' => 'gdlr-core-fullsize'
									),
									'sidebar-left' => array(
										'title' => esc_html__('Sidebar Left', 'corzo'),
										'type' => 'combobox',
										'options' => 'sidebar',
										'condition' => array( 'sidebar' => array('left', 'both') )
									),
									'sidebar-right' => array(
										'title' => esc_html__('Sidebar Right', 'corzo'),
										'type' => 'combobox',
										'options' => 'sidebar',
										'condition' => array( 'sidebar' => array('right', 'both') )
									),
								)
							),
							'metro-layout' => array(
								'title' => esc_html__('Metro Layout', 'corzo'),
								'options' => array(
									'metro-column-size' => array(
										'title' => esc_html__('Column Size', 'corzo'),
										'type' => 'combobox',
										'options' => array( 'default'=> esc_html__('Default', 'corzo'), 
											60 => '1/1', 30 => '1/2', 20 => '1/3', 40 => '2/3', 
											15 => '1/4', 45 => '3/4', 12 => '1/5', 24 => '2/5', 36 => '3/5', 48 => '4/5',
											10 => '1/6', 50 => '5/6'),
										'default' => 'default',
										'description' => esc_html__('Choosing default will display the value selected by the page builder item.', 'corzo')
									),
									'metro-thumbnail-size' => array(
										'title' => esc_html__('Thumbnail Size', 'corzo'),
										'type' => 'combobox',
										'options' => 'thumbnail-size',
										'with-default' => true,
										'default' => 'default',
										'description' => esc_html__('Choosing default will display the value selected by the page builder item.', 'corzo')
									)
								)
							),						
							'title' => array(
								'title' => esc_html__('Title', 'corzo'),
								'options' => array(

									'blog-title-style' => array(
										'title' => esc_html__('Blog Title Style', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'small' => esc_html__('Small', 'corzo'),
											'large' => esc_html__('Large', 'corzo'),
											'custom' => esc_html__('Custom', 'corzo'),
											'inside-content' => esc_html__('Inside Content', 'corzo'),
											'none' => esc_html__('None', 'corzo'),
										),
										'default' => 'default'
									),
									'blog-title-divider' => array(
										'title' => esc_html__('Blog Title Divider', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Enable', 'corzo'),
											'disable' => esc_html__('Disable', 'corzo'),
										),
										'default' => 'default'
									),
									'blog-title-padding' => array(
										'title' => esc_html__('Blog Title Padding', 'corzo'),
										'type' => 'custom',
										'item-type' => 'padding',
										'data-input-type' => 'pixel',
										'options' => array('padding-top', 'padding-bottom'),
										'wrapper-class' => 'gdlr-core-fullsize gdlr-core-no-link gdlr-core-large',
										'condition' => array( 'blog-title-style' => 'custom' )
									),
									'blog-feature-image' => array(
										'title' => esc_html__('Blog Feature Image Location', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'content' => esc_html__('Inside Content', 'corzo'),
											'title-background' => esc_html__('Title Background', 'corzo'),
											'none' => esc_html__('None', 'corzo'),
										)
									),
									'blog-title-background-image' => array(
										'title' => esc_html__('Blog Title Background Image', 'corzo'),
										'type' => 'upload',
										'data-type' => 'file',
										'condition' => array( 
											'blog-title-style' => array('default', 'small', 'large', 'custom'),
											'blog-feature-image' => array('default', 'content', 'none')
										),
										'description' => esc_html__('Will be overridden by feature image if selected.', 'corzo'),
									),
									'blog-top-bottom-gradient' => array(
										'title' => esc_html__('Blog ( Feature Image ) Title Top/Bottom Gradient', 'corzo'),
										'type' => 'combobox',
										'options' => array(
											'default' => esc_html__('Default', 'corzo'),
											'enable' => esc_html__('Both', 'corzo'),
											'top' => esc_html__('Top', 'corzo'),
											'bottom' => esc_html__('Bottom', 'corzo'),
											'disable' => esc_html__('None', 'corzo'),
										)
									),
									'blog-title-background-overlay-opacity' => array(
										'title' => esc_html__('Blog Title Background Overlay Opacity', 'corzo'),
										'type' => 'text',
										'description' => esc_html__('Fill the number between 0.01 - 1 ( Leave Blank For Default Value )', 'corzo'),
									),

								) // options
							) // title
						)
					));
				}

			}
			
			// create page builder
			if( class_exists('gdlr_core_page_builder') ){
				new gdlr_core_page_builder(array(
					'style' => array(
						'style-custom' => corzo_get_style_custom()
					)
				));
			}
			
		} // corzo_init_goodlayers_core_elements
	} // function_exists


	add_filter('gdlr_core_portfolio_options', 'corzo_gdlr_core_portfolio_options');
	if( !function_exists('corzo_gdlr_core_portfolio_options') ){
		function corzo_gdlr_core_portfolio_options($options){
			if( function_exists('gdlr_core_array_insert') ){
				$options['general']['options'] = gdlr_core_array_insert($options['general']['options'], 'title-background', array(
					'enable-breadcrumbs' => array(
						'title' => esc_html__('Enable Breadcrumbs', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable',
						'condition' => array( 'enable-page-title' => 'enable' )
					),
				));
			}
			

			return $options;
		}
	}