<?php
	/* a template for displaying the header area */

	// header container
	$body_layout = corzo_get_option('general', 'layout', 'full');
	$body_margin = corzo_get_option('general', 'body-margin', '0px');
	$header_width = corzo_get_option('general', 'header-width', 'boxed');
	$header_style = corzo_get_option('general', 'header-bar-navigation-align', 'center');
	$header_background_style = corzo_get_option('general', 'header-background-style', 'solid');

	$header_wrap_class = '';
	if( $header_style == 'center-logo' ){
		$header_wrap_class .= ' corzo-style-center';
	}else{
		$header_wrap_class .= ' corzo-style-left';
	}

	$header_container_class = '';
	if( $header_width == 'boxed' ){
		$header_container_class .= ' corzo-container';
	}else if( $header_width == 'custom' ){
		$header_container_class .= ' corzo-header-custom-container';
	}else{
		$header_container_class .= ' corzo-header-full';
	}

	$navigation_wrap_class  = ' corzo-style-' . $header_background_style;
	$navigation_wrap_class .= ' corzo-sticky-navigation corzo-sticky-navigation-height';
	if( $header_style == 'center' || $header_style == 'center-logo' ){
		$navigation_wrap_class .= ' corzo-style-center';
	}else{
		$navigation_wrap_class .= ' corzo-style-left';
	}
	if( $body_layout == 'boxed' || $body_margin != '0px' ){
		$navigation_wrap_class .= ' corzo-style-slide';
	}else{
		$navigation_wrap_class .= '  corzo-style-fixed';
	}
	if( $header_background_style == 'transparent' ){
		$navigation_wrap_class .= ' corzo-without-placeholder';
	}

?>	
<header class="corzo-header-wrap corzo-header-style-bar corzo-header-background <?php echo esc_attr($header_wrap_class); ?>" >
	<div class="corzo-header-container clearfix <?php echo esc_attr($header_container_class); ?>">
		<div class="corzo-header-container-inner">
		<?php
			echo corzo_get_logo();

			$logo_right_image = corzo_get_option('general', 'logo-right-image');
			$logo_right_caption = corzo_get_option('general', 'logo-right-caption');
			$logo_right_text = corzo_get_option('general', 'logo-right-text');
			if( !empty($logo_right_image) || !empty($logo_right_caption) || !empty($logo_right_text) ){
				echo '<div class="corzo-logo-right-text corzo-item-pdlr corzo-clearfix" >';
				if( !empty($logo_right_image) ){
					echo '<div class="corzo-logo-right-text-image corzo-media-image" >' . gdlr_core_get_image($logo_right_image) . '</div>';
				}
				if( !empty($logo_right_caption) || !empty($logo_right_text) ){
					echo '<div class="corzo-logo-right-text-inner" >';
					if( !empty($logo_right_caption) ){
						echo '<div class="corzo-logo-right-text-caption" >' . gdlr_core_text_filter($logo_right_caption) . '</div>';
					}
					if( !empty($logo_right_text) ){
						echo '<div class="corzo-logo-right-text-content" >' . gdlr_core_text_filter($logo_right_text) . '</div>';
					}
					echo '</div>';
				}
				echo '</div>';
			}
		?>
		</div>
	</div>
</header><!-- header -->
<div class="corzo-navigation-bar-wrap <?php echo esc_attr($navigation_wrap_class); ?>" >
	<div class="corzo-navigation-background" ></div>
	<div class="corzo-navigation-container clearfix <?php echo esc_attr($header_container_class); ?>">
		<?php
			$navigation_class = '';
			if( corzo_get_option('general', 'enable-main-navigation-submenu-indicator', 'disable') == 'enable' ){
				$navigation_class .= 'corzo-navigation-submenu-indicator ';
			}
		?>
		<div class="corzo-navigation corzo-item-pdlr clearfix <?php echo esc_attr($navigation_class); ?>" >
		<?php
			// print main menu
			if( has_nav_menu('main_menu') ){
				echo '<div class="corzo-main-menu" id="corzo-main-menu" >';
				wp_nav_menu(array(
					'theme_location'=>'main_menu', 
					'container'=> '', 
					'menu_class'=> 'sf-menu',
					'walker' => new corzo_menu_walker()
				));
				
				corzo_get_navigation_slide_bar();
				
				echo '</div>';
			}

			// menu right side
			$menu_right_class = '';
			if( $header_style == 'center' || $header_style == 'center-logo' ){
				$menu_right_class = ' corzo-item-mglr corzo-navigation-top';
			}

			// menu right side
			$enable_search = (corzo_get_option('general', 'enable-main-navigation-search', 'enable') == 'enable')? true: false;
			$enable_cart = (corzo_get_option('general', 'enable-main-navigation-cart', 'enable') == 'enable' && class_exists('WooCommerce'))? true: false;
			$enable_right_button = (corzo_get_option('general', 'enable-main-navigation-right-button', 'disable') == 'enable')? true: false;
			$custom_main_menu_right = apply_filters('corzo_custom_main_menu_right', '');
			$top_bar_social = corzo_get_option('general', 'enable-top-bar-social', 'enable');
			$top_bar_social_position = corzo_get_option('general', 'top-bar-social-position', 'right');

			if( has_nav_menu('right_menu') || $enable_search || $enable_cart || $enable_right_button || !empty($custom_main_menu_right) ||
				($top_bar_social == 'enable' && $top_bar_social_position == 'menu-right') ){
				echo '<div class="corzo-main-menu-right-wrap clearfix ' . esc_attr($menu_right_class) . '" >';

				if( $top_bar_social == 'enable' && $top_bar_social_position == 'menu-right' ){
					echo '<div class="corzo-top-bar-right-social" >';
					get_template_part('header/header', 'social');
					echo '</div>';	
				}

				// search icon
				if( $enable_search ){
					$search_icon = corzo_get_option('general', 'main-navigation-search-icon', 'fa fa-search');
					echo '<div class="corzo-main-menu-search" id="corzo-top-search" >';
					echo '<i class="' . esc_attr($search_icon) . '" ></i>';
					echo '</div>';
					corzo_get_top_search();
				}

				// cart icon
				if( $enable_cart ){
					$cart_icon = corzo_get_option('general', 'main-navigation-cart-icon', 'fa fa-shopping-cart');
					echo '<div class="corzo-main-menu-cart" id="corzo-main-menu-cart" >';
					echo '<i class="' . esc_attr($cart_icon) . '" data-corzo-lb="top-bar" ></i>';
					corzo_get_woocommerce_bar();
					echo '</div>';
				}

				// menu right button
				if( $enable_right_button ){
					$button_class = 'corzo-style-' . corzo_get_option('general', 'main-navigation-right-button-style', 'default');
					$button_link = corzo_get_option('general', 'main-navigation-right-button-link', '');
					$button_link_target = corzo_get_option('general', 'main-navigation-right-button-link-target', '_self');
					if( !empty($button_link) ){
						echo '<a class="corzo-main-menu-right-button corzo-button-1 ' . esc_attr($button_class) . '" href="' . esc_url($button_link) . '" target="' . esc_attr($button_link_target) . '" >';
						echo corzo_get_option('general', 'main-navigation-right-button-text', '');
						echo '</a>';
					}
				
					$button_class = 'corzo-style-' . corzo_get_option('general', 'main-navigation-right-button-style-2', 'default');
					$button_link = corzo_get_option('general', 'main-navigation-right-button-link-2', '');
					$button_link_target = corzo_get_option('general', 'main-navigation-right-button-link-target-2', '_self');
					if( !empty($button_link) ){
						echo '<a class="corzo-main-menu-right-button corzo-button-2 ' . esc_attr($button_class) . '" href="' . esc_url($button_link) . '" target="' . esc_attr($button_link_target) . '" >';
						echo corzo_get_option('general', 'main-navigation-right-button-text-2', '');
						echo '</a>';
					}
				}
				
				// custom menu right
				if( !empty($custom_main_menu_right) ){
					echo gdlr_core_text_filter($custom_main_menu_right);
				}

				// print right menu
				if( has_nav_menu('right_menu') ){
					corzo_get_custom_menu(array(
						'container-class' => 'corzo-main-menu-right',
						'button-class' => 'corzo-right-menu-button corzo-top-menu-button',
						'icon-class' => 'fa fa-bars',
						'id' => 'corzo-right-menu',
						'theme-location' => 'right_menu',
						'type' => corzo_get_option('general', 'right-menu-type', 'right')
					));
				}

				echo '</div>'; // corzo-main-menu-right-wrap
			}
		?>
		</div><!-- corzo-navigation -->

	</div><!-- corzo-header-container -->
</div><!-- corzo-navigation-bar-wrap -->