<?php
	/* a template for displaying the header area */
?>	
<header class="corzo-header-wrap corzo-header-style-side-toggle" >
	<?php
		$display_logo = corzo_get_option('general', 'header-side-toggle-display-logo', 'enable');
		if( $display_logo == 'enable' ){
			echo corzo_get_logo(array('padding' => false));
		}

		$navigation_class = '';
		if( corzo_get_option('general', 'enable-main-navigation-submenu-indicator', 'disable') == 'enable' ){
			$navigation_class = 'corzo-navigation-submenu-indicator ';
		}
	?>
	<div class="corzo-navigation clearfix <?php echo esc_attr($navigation_class); ?>" >
	<?php
		// print main menu
		if( has_nav_menu('main_menu') ){
			corzo_get_custom_menu(array(
				'container-class' => 'corzo-main-menu',
				'button-class' => 'corzo-side-menu-icon',
				'icon-class' => 'fa fa-bars',
				'id' => 'corzo-main-menu',
				'theme-location' => 'main_menu',
				'type' => corzo_get_option('general', 'header-side-toggle-menu-type', 'overlay')
			));
		}
	?>
	</div><!-- corzo-navigation -->
	<?php

		// menu right side
		$enable_search = (corzo_get_option('general', 'enable-main-navigation-search', 'enable') == 'enable')? true: false;
		$enable_cart = (corzo_get_option('general', 'enable-main-navigation-cart', 'enable') == 'enable' && class_exists('WooCommerce'))? true: false;
		if( $enable_search || $enable_cart ){ 
			echo '<div class="corzo-header-icon corzo-pos-bottom" >';

			// search icon
			if( $enable_search ){
				$search_icon = corzo_get_option('general', 'main-navigation-search-icon', 'fa fa-search');
				echo '<div class="corzo-main-menu-search" id="corzo-top-search" >';
				echo '<i class="' . esc_attr($search_icon) . '" ></i>';
				echo '</div>';
				corzo_get_top_search();
			}

			// cart icon
			if( $enable_cart ){
				$cart_icon = corzo_get_option('general', 'main-navigation-cart-icon', 'fa fa-shopping-cart');
				echo '<div class="corzo-main-menu-cart" id="corzo-main-menu-cart" >';
				echo '<i class="' . esc_attr($cart_icon) . '" data-corzo-lb="top-bar" ></i>';
				corzo_get_woocommerce_bar();
				echo '</div>';
			}

			echo '</div>'; // corzo-main-menu-right-wrap
		}

	?>
</header><!-- header -->