<?php
	/*	
	*	Goodlayers Option
	*	---------------------------------------------------------------------
	*	This file store an array of theme options
	*	---------------------------------------------------------------------
	*/	

	// add custom css for theme option
	add_filter('gdlr_core_theme_option_top_file_write', 'corzo_gdlr_core_theme_option_top_file_write', 10, 2);
	if( !function_exists('corzo_gdlr_core_theme_option_top_file_write') ){
		function corzo_gdlr_core_theme_option_top_file_write( $css, $option_slug ){
			if( $option_slug != 'goodlayers_main_menu' ) return;

			ob_start();
?>
.corzo-body h1, .corzo-body h2, .corzo-body h3, .corzo-body h4, .corzo-body h5, .corzo-body h6{ margin-top: 0px; margin-bottom: 20px; line-height: 1.2; font-weight: 700; }
#poststuff .gdlr-core-page-builder-body h2{ padding: 0px; margin-bottom: 20px; line-height: 1.2; font-weight: 700; }
#poststuff .gdlr-core-page-builder-body h1{ padding: 0px; font-weight: 700; }

.gdlr-core-flexslider.gdlr-core-bullet-style-cylinder .flex-control-nav li a{ width: 27px; height: 7px; }
.gdlr-core-newsletter-item.gdlr-core-style-rectangle .gdlr-core-newsletter-email input[type="email"]{ line-height: 17px; padding: 30px 20px; height: 65px; }
.gdlr-core-newsletter-item.gdlr-core-style-rectangle .gdlr-core-newsletter-submit input[type="submit"]{ height: 65px; font-size: 13px; }

.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-grid-top-info .gdlr-core-blog-info-date{ float: right; font-size: 13px; letter-spacing: 1px; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-grid-top-info .gdlr-core-blog-info-category { float: left; font-size: 13px; font-weight: 600; text-transform: uppercase; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-grid-top-info .gdlr-core-blog-info-category .gdlr-core-head{ display: inline-block; background: #d32525; width: 6px; height: 6px; margin-bottom: 2px; margin-right: 7px; border-radius: 50%; -moz-border-radius: 50%; -webkit-border-radius: 50%; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-grid-top-info .gdlr-core-blog-info-category .gdlr-core-head i{ display: none }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-info.gdlr-core-blog-info-author{ font-size: 13px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-info.gdlr-core-blog-info-author .gdlr-core-head{ margin-right: 5px; }

.gdlr-core-testimonial-style-center .gdlr-core-testimonial-content p:after{ content: " "; width: 70px; border-bottom-width: 2px; border-bottom-style: solid; display: block; margin: 0px auto; padding-top: 30px; }

ul.gdlr-core-custom-menu-widget.gdlr-core-menu-style-half li a{ text-decoration: underline; }
ul.gdlr-core-custom-menu-widget.gdlr-core-menu-style-plain li a:before{ content: "\f105"; font-family: FontAwesome; font-size: 20px;  display: inline-block; margin-right: 10px; margin-bottom: -2px; }

/* custom */
.gdlr-core-title-item .gdlr-core-title-item-caption-prefix{ border-right-width: 4px; }
.gdlr-core-blog-grid .gdlr-core-blog-title{ font-size: 20px; font-weight: 600; }
.gdlr-core-blog-grid .gdlr-core-blog-grid-date .gdlr-core-blog-info-date{ font-size: 13px; }

p.comment-form-cookies-consent { font-size: 17px; }
.comment-respond p.logged-in-as { font-size: 17px; }

.gdlr-core-blog-full .gdlr-core-excerpt-read-more.gdlr-core-plain-text{ margin-top: 25px; }
.gdlr-core-blog-full .gdlr-core-excerpt-read-more{ margin-bottom: 10px; }
.gdlr-core-recent-post-widget-wrap.gdlr-core-style-1 .gdlr-core-recent-post-widget-title{ font-size: 18px; font-weight: 500; }
.gdlr-core-blog-info-author .gdlr-core-head{ margin-right: 7px; }
.gdlr-core-recent-post-widget-wrap.gdlr-core-style-1 .gdlr-core-recent-post-widget{ margin-bottom: 25px; }
.gdlr-core-blog-full.gdlr-core-style-2-date .gdlr-core-blog-info{ font-size: 11px; font-weight: 700; letter-spacing: 2px; text-transform: uppercase; }
.gdlr-core-blog-info-wrapper .gdlr-core-blog-info{ font-size: 12px; }
.gdlr-core-blog-info-wrapper .gdlr-core-head{ margin-right: 11px; }
.gdlr-core-blog-grid.gdlr-core-style-2 .gdlr-core-blog-info-wrapper .gdlr-core-blog-info{ font-size: 11px; letter-spacing: 1.5px; text-transform: uppercase; }
.gdlr-core-blog-link-format.gdlr-core-small.gdlr-core-style-2 .gdlr-core-blog-content{ font-size: 17px; }
.gdlr-core-blog-grid.gdlr-core-style-2 .gdlr-core-blog-info-wrapper{ margin-bottom: 9px; }
.gdlr-core-blockquote-item.gdlr-core-large-size .gdlr-core-blockquote-item-content{ font-size: 25px; line-height: 1.6; }
.gdlr-core-blockquote-item.gdlr-core-medium-size .gdlr-core-blockquote-item-content{ font-size: 22px; line-height: 1.6; }
.gdlr-core-blockquote-item.gdlr-core-small-size .gdlr-core-blockquote-item-content{ font-size: 18px; line-height: 1.6; }
.gdlr-core-blockquote-item.gdlr-core-small-size .gdlr-core-blockquote-item-author{ font-size: 15px; }
.gdlr-core-blockquote-item.gdlr-core-medium-size .gdlr-core-blockquote-item-author { font-size: 17px; }
.gdlr-core-blockquote-item.gdlr-core-large-size .gdlr-core-blockquote-item-author { font-size: 18px; }
.gdlr-core-icon-list-item .gdlr-core-icon-list-content { font-size: 17px; }
input.wpcf7-form-control.wpcf7-submit.gdlr-core-curve-button{ margin-top: 15px; }
.gdlr-core-newsletter-item.gdlr-core-style-rectangle .gdlr-core-newsletter-email input[type="email"]{ font-size: 17px; }
.gdlr-core-newsletter-item.gdlr-core-style-round2 .gdlr-core-newsletter-submit input[type="submit"]{ height: 55px; }
ul.gdlr-core-custom-menu-widget.gdlr-core-menu-style-half li{ margin-bottom: 12px; }
.gdlr-core-recent-post-widget-wrap.gdlr-core-style-4 .gdlr-core-recent-post-widget-title{ font-weight: 500; }
.gdlr-core-testimonial-style-center .gdlr-core-testimonial-quote{ padding: 15px 0px 0px; }
.gdlr-core-testimonial-style-center .gdlr-core-testimonial-content p:after{ border-bottom-width: 3px; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-grid-top-info .gdlr-core-blog-info{ font-weight: 500; }
.gdlr-core-blog-grid.gdlr-core-style-4 .gdlr-core-blog-info.gdlr-core-blog-info-author{ font-weight: 500; }
.gdlr-core-feature-content-item .gdlr-core-feature-content-title{ margin-bottom: 22px; }
.gdlr-core-feature-content-content.gdlr-core-skin-content p{ margin-bottom: 5px; }
.gdlr-core-feature-content-item li.gdlr-core-item-mglr.flex-with-active-class.flex-active-slide{ margin-right: -1px !important; }

.gdlr-core-portfolio-modern2 .gdlr-core-portfolio-caption{ display: block; }
.gdlr-core-portfolio-thumbnail{ margin-right: -1px; }
.gdlr-core-portfolio-modern2 .gdlr-core-image-overlay-content{ bottom: 40px; left: 40px; }
.gdlr-core-recent-post-widget-wrap.gdlr-core-style-4 .gdlr-core-recent-post-widget-thumbnail{ margin-top: 7px; }
.gdlr-core-recent-post-widget-wrap.gdlr-core-style-4 .gdlr-core-recent-post-widget{ margin-bottom: 26px; }
.gdlr-core-portfolio-single-nav-wrap{ padding: 30px 0px 60px; }
<?php
			$css .= ob_get_contents();
			ob_end_clean(); 

			return $css;
		}
	}
	add_filter('gdlr_core_theme_option_bottom_file_write', 'corzo_gdlr_core_theme_option_bottom_file_write', 10, 2);
	if( !function_exists('corzo_gdlr_core_theme_option_bottom_file_write') ){
		function corzo_gdlr_core_theme_option_bottom_file_write( $css, $option_slug ){
			if( $option_slug != 'goodlayers_main_menu' ) return;

			$general = get_option('corzo_general');

			if( !empty($general['enable-fixed-navigation-slide-bar']) && $general['enable-fixed-navigation-slide-bar'] == 'disable' ){
				$css .= '.corzo-fixed-navigation .corzo-navigation .corzo-navigation-slide-bar{ display: none !important; }';
			}

			if( !empty($general['item-padding']) ){
				$margin = 2 * intval(str_replace('px', '', $general['item-padding']));
				if( !empty($margin) && is_numeric($margin) ){
					$css .= '.corzo-item-mgb, .gdlr-core-item-mgb{ margin-bottom: ' . $margin . 'px; }';

					$margin -= 1;
					$css .= '.corzo-body .gdlr-core-testimonial-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-feature-content-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-personnel-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-hover-box-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport,'; 
					$css .= '.corzo-body .gdlr-core-portfolio-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-product-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-product-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .gdlr-core-blog-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport, '; 
					$css .= '.corzo-body .corzo-lp-course-list-item .gdlr-core-flexslider.gdlr-core-with-outer-frame-element .flex-viewport{ '; 
					$css .= 'padding-top: ' . $margin . 'px; margin-top: -' . $margin . 'px; padding-right: ' . $margin . 'px; margin-right: -' . $margin . 'px; ';
					$css .= 'padding-left: ' . $margin . 'px; margin-left: -' . $margin . 'px; padding-bottom: ' . $margin . 'px; margin-bottom: -' . $margin . 'px; ';
					$css .= '}';
				}
			}

			if( !empty($general['mobile-logo-position']) && $general['mobile-logo-position'] == 'logo-right' ){
				$css .= '.corzo-mobile-header .corzo-logo-inner{ margin-right: 0px; margin-left: 80px; float: right; }';	
				$css .= '.corzo-mobile-header .corzo-mobile-menu-right{ left: 30px; right: auto; }';	
				$css .= '.corzo-mobile-header .corzo-main-menu-search{ float: right; margin-left: 0px; margin-right: 25px; }';	
				$css .= '.corzo-mobile-header .corzo-mobile-menu{ float: right; margin-left: 0px; margin-right: 30px; }';	
				$css .= '.corzo-mobile-header .corzo-main-menu-cart{ float: right; margin-left: 0px; margin-right: 20px; padding-left: 0px; padding-right: 5px; }';	
				$css .= '.corzo-mobile-header .corzo-top-cart-content-wrap{ left: 0px; }';
			}

			return $css;
		}
	}

	$corzo_admin_option->add_element(array(
	
		// general head section
		'title' => esc_html__('General', 'corzo'),
		'slug' => 'corzo_general',
		'icon' => get_template_directory_uri() . '/include/options/images/general.png',
		'options' => array(
		
			'layout' => array(
				'title' => esc_html__('Layout', 'corzo'),
				'options' => array(
					'custom-header' => array(
						'title' => esc_html__('Select Custom Header As Default Header', 'corzo'),
						'type' => 'combobox',
						'single' => 'gdlr_core_custom_header_id',
						'options' => array('' => esc_html__('None', 'corzo')) + gdlr_core_get_post_list('gdlr_core_header'),
						'description' => esc_html__('Any settings you set at the theme option will be ignored', 'corzo')
					),
					'layout' => array(
						'title' => esc_html__('Layout', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'full' => esc_html__('Full', 'corzo'),
							'boxed' => esc_html__('Boxed', 'corzo'),
						)
					),
					'boxed-layout-top-margin' => array(
						'title' => esc_html__('Box Layout Top/Bottom Margin', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '150',
						'data-type' => 'pixel',
						'default' => '0px',
						'selector' => 'body.corzo-boxed .corzo-body-wrapper{ margin-top: #gdlr#; margin-bottom: #gdlr#; }',
						'condition' => array( 'layout' => 'boxed' ) 
					),
					'body-margin' => array(
						'title' => esc_html__('Body Margin ( Frame Spaces )', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '100',
						'data-type' => 'pixel',
						'default' => '0px',
						'selector' => '.corzo-body-wrapper.corzo-with-frame, body.corzo-full .corzo-fixed-footer{ margin: #gdlr#; }',
						'condition' => array( 'layout' => 'full' ),
						'description' => esc_html__('This value will be automatically omitted for side header style.', 'corzo'),
					),
					'background-type' => array(
						'title' => esc_html__('Background Type', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'color' => esc_html__('Color', 'corzo'),
							'image' => esc_html__('Image', 'corzo'),
							'pattern' => esc_html__('Pattern', 'corzo'),
						),
						'condition' => array( 'layout' => 'boxed' )
					),
					'background-image' => array(
						'title' => esc_html__('Background Image', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file', 
						'selector' => '.corzo-body-background{ background-image: url(#gdlr#); }',
						'condition' => array( 'layout' => 'boxed', 'background-type' => 'image' )
					),
					'background-image-opacity' => array(
						'title' => esc_html__('Background Image Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '100',
						'condition' => array( 'layout' => 'boxed', 'background-type' => 'image' ),
						'selector' => '.corzo-body-background{ opacity: #gdlr#; }'
					),
					'background-pattern' => array(
						'title' => esc_html__('Background Type', 'corzo'),
						'type' => 'radioimage',
						'data-type' => 'text',
						'options' => 'pattern', 
						'selector' => '.corzo-background-pattern .corzo-body-outer-wrapper{ background-image: url(' . GDLR_CORE_URL . '/include/images/pattern/#gdlr#.png); }',
						'condition' => array( 'layout' => 'boxed', 'background-type' => 'pattern' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'enable-boxed-border' => array(
						'title' => esc_html__('Enable Boxed Border', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable',
						'condition' => array( 'layout' => 'boxed', 'background-type' => 'pattern' ),
					),
					'item-padding' => array(
						'title' => esc_html__('Item Left/Right Spaces', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '40',
						'data-type' => 'pixel',
						'default' => '15px',
						'description' => 'Space between each page items',
						'selector' => '.corzo-item-pdlr, .gdlr-core-item-pdlr{ padding-left: #gdlr#; padding-right: #gdlr#; }' . 
							'.corzo-item-rvpdlr, .gdlr-core-item-rvpdlr{ margin-left: -#gdlr#; margin-right: -#gdlr#; }' .
							'.gdlr-core-metro-rvpdlr{ margin-top: -#gdlr#; margin-right: -#gdlr#; margin-bottom: -#gdlr#; margin-left: -#gdlr#; }' .
							'.corzo-item-mglr, .gdlr-core-item-mglr, .corzo-navigation .sf-menu > .corzo-mega-menu .sf-mega,' . 
							'.sf-menu.corzo-top-bar-menu > .corzo-mega-menu .sf-mega{ margin-left: #gdlr#; margin-right: #gdlr#; }' .
							'.gdlr-core-pbf-wrapper-container-inner{ width: calc(100% - #gdlr# - #gdlr#); }'
					
					),
					'container-width' => array(
						'title' => esc_html__('Container Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '1180px',
						'selector' => '.corzo-container, .gdlr-core-container, body.corzo-boxed .corzo-body-wrapper, ' . 
							'body.corzo-boxed .corzo-fixed-footer .corzo-footer-wrapper, body.corzo-boxed .corzo-fixed-footer .corzo-copyright-wrapper{ max-width: #gdlr#; }' 
					),
					'container-padding' => array(
						'title' => esc_html__('Container Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '100',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-body-front .gdlr-core-container, .corzo-body-front .corzo-container{ padding-left: #gdlr#; padding-right: #gdlr#; }'  . 
							'.corzo-body-front .corzo-container .corzo-container, .corzo-body-front .corzo-container .gdlr-core-container, '.
							'.corzo-body-front .gdlr-core-container .gdlr-core-container{ padding-left: 0px; padding-right: 0px; }' .
							'.corzo-navigation-header-style-bar.corzo-style-2 .corzo-navigation-background{ left: #gdlr#; right: #gdlr#; }'
					),
					'sidebar-title-divider' => array(
						'title' => esc_html__('Sidebar Title Divider', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
					),
					'sidebar-heading-tag' => array(
						'title' => esc_html__('Sidebar Heading Tag', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'h1' => esc_html__('H1', 'corzo'),
							'h2' => esc_html__('H2', 'corzo'),
							'h3' => esc_html__('H3', 'corzo'),
							'h4' => esc_html__('H4', 'corzo'),
							'h5' => esc_html__('H5', 'corzo'),
							'h6' => esc_html__('H6', 'corzo'),
						),
						'default' => 'h3'
					),
					'sidebar-width' => array(
						'title' => esc_html__('Sidebar Width', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'30' => '50%', '20' => '33.33%', '15' => '25%', '12' => '20%', '10' => '16.67%'
						),
						'default' => 20,
					),
					'both-sidebar-width' => array(
						'title' => esc_html__('Both Sidebar Width', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'30' => '50%', '20' => '33.33%', '15' => '25%', '12' => '20%', '10' => '16.67%'
						),
						'default' => 15,
					),
					
				) // header-options
			), // header-nav	
			
			'top-bar' => corzo_top_bar_options(),

			'top-bar-social' => corzo_top_bar_social_options(),			

			'header' => corzo_header_options(),
			
			'logo' => corzo_logo_options(),

			'navigation' => corzo_navigation_options(), 
			
			'fixed-navigation' => corzo_fixed_navigation_options(),

			'float-social' => array(
				'title' => esc_html__('Float Social', 'corzo'),
				'options' => array(
					'enable-float-social' => array(
						'title' => esc_html__('Enable Float Social', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
					'display-float-social-after-page-title' => array(
						'title' => esc_html__('Display Float Social After Page Title', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
					'float-social-delicious' => array(
						'title' => esc_html__('Float Social Delicious Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-email' => array(
						'title' => esc_html__('Float Social Email Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-deviantart' => array(
						'title' => esc_html__('Float Social Deviantart Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-digg' => array(
						'title' => esc_html__('Float Social Digg Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-facebook' => array(
						'title' => esc_html__('Float Social Facebook Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-flickr' => array(
						'title' => esc_html__('Float Social Flickr Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-google-plus' => array(
						'title' => esc_html__('Float Social Google Plus Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-lastfm' => array(
						'title' => esc_html__('Float Social Lastfm Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-linkedin' => array(
						'title' => esc_html__('Float Social Linkedin Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-pinterest' => array(
						'title' => esc_html__('Float Social Pinterest Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-rss' => array(
						'title' => esc_html__('Float Social RSS Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-skype' => array(
						'title' => esc_html__('Float Social Skype Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-stumbleupon' => array(
						'title' => esc_html__('Float Social Stumbleupon Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-tumblr' => array(
						'title' => esc_html__('Float Social Tumblr Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-twitter' => array(
						'title' => esc_html__('Float Social Twitter Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-vimeo' => array(
						'title' => esc_html__('Float Social Vimeo Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-youtube' => array(
						'title' => esc_html__('Float Social Youtube Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-instagram' => array(
						'title' => esc_html__('Float Social Instagram Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
					'float-social-snapchat' => array(
						'title' => esc_html__('Float Social Snapchat Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-float-social' => 'enable' )
					),
				)
			),

			'title-style' => array(
				'title' => esc_html__('Page Title Style', 'corzo'),
				'options' => array(

					'default-title-style' => array(
						'title' => esc_html__('Default Page Title Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'small' => esc_html__('Small', 'corzo'),
							'medium' => esc_html__('Medium', 'corzo'),
							'large' => esc_html__('Large', 'corzo'),
							'custom' => esc_html__('Custom', 'corzo'),
						),
						'default' => 'small'
					),
					'default-title-divider' => array(
						'title' => esc_html__('Default Page Title Divider', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'default-title-align' => array(
						'title' => esc_html__('Default Page Title Alignment', 'corzo'),
						'type' => 'radioimage',
						'options' => 'text-align',
						'default' => 'left'
					),
					'default-title-top-padding' => array(
						'title' => esc_html__('Default Page Title Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '350',
						'default' => '93px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-title-content{ padding-top: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-title-bottom-padding' => array(
						'title' => esc_html__('Default Page Title Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '350',
						'default' => '87px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-title-content{ padding-bottom: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-page-caption-top-margin' => array(
						'title' => esc_html__('Default Page Caption Bottom Margin', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '13px',						
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-caption{ margin-bottom: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-title-font-transform' => array(
						'title' => esc_html__('Default Page Title Font Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'' => esc_html__('Default', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
						),
						'default' => 'default',
						'selector' => '.corzo-page-title-wrap .corzo-page-title{ text-transform: #gdlr#; }'
					),
					'default-title-font-size' => array(
						'title' => esc_html__('Default Page Title Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '37px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-title{ font-size: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-title-font-weight' => array(
						'title' => esc_html__('Default Page Title Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-page-title-wrap .corzo-page-title{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800. Leave this field blank for default value (700).', 'corzo')					
					),
					'default-title-letter-spacing' => array(
						'title' => esc_html__('Default Page Title Letter Spacing', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '20',
						'default' => '0px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-title{ letter-spacing: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-caption-font-transform' => array(
						'title' => esc_html__('Default Page Caption Font Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'' => esc_html__('Default', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
						),
						'default' => 'default',
						'selector' => '.corzo-page-title-wrap .corzo-page-caption{ text-transform: #gdlr#; }'
					),
					'default-caption-font-size' => array(
						'title' => esc_html__('Default Page Caption Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '16px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-caption{ font-size: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'default-caption-font-weight' => array(
						'title' => esc_html__('Default Page Caption Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-page-title-wrap .corzo-page-caption{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800. Leave this field blank for default value (400).', 'corzo')					
					),
					'default-caption-letter-spacing' => array(
						'title' => esc_html__('Default Page Caption Letter Spacing', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '20',
						'default' => '0px',
						'selector' => '.corzo-page-title-wrap.corzo-style-custom .corzo-page-caption{ letter-spacing: #gdlr#; }',
						'condition' => array( 'default-title-style' => 'custom' )
					),
					'page-title-top-bottom-gradient' => array(
						'title' => esc_html__('Default Page Title Top/Bottom Gradient', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'both' => esc_html__('Both', 'corzo'),
							'top' => esc_html__('Top', 'corzo'),
							'bottom' => esc_html__('Bottom', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'none',
					),
					'page-title-top-gradient-size' => array(
						'title' => esc_html__('Default Page Title Top Gradient Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '1000',
 						'default' => '413px',
						'selector' => '.corzo-page-title-wrap .corzo-page-title-top-gradient{ height: #gdlr#; }',
					),
					'page-title-bottom-gradient-size' => array(
						'title' => esc_html__('Default Page Title Bottom Gradient Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '1000',
 						'default' => '413px',
						'selector' => '.corzo-page-title-wrap .corzo-page-title-bottom-gradient{ height: #gdlr#; }',
					),
					'default-title-background-overlay-opacity' => array(
						'title' => esc_html__('Default Page Title Background Overlay Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '80',
						'selector' => '.corzo-page-title-wrap .corzo-page-title-overlay{ opacity: #gdlr#; }'
					),
				) 
			), // title style

			'title-background' => array(
				'title' => esc_html__('Page Title Background', 'corzo'),
				'options' => array(

					'default-title-background' => array(
						'title' => esc_html__('Default Page Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => '.corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-portfolio-title-background' => array(
						'title' => esc_html__('Default Portfolio Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.single-portfolio .corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-personnel-title-background' => array(
						'title' => esc_html__('Default Personnel Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.single-personnel .corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-woocommerce-title-background' => array(
						'title' => esc_html__('Default Woocommerce Title Background (Header Transparent Style)', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.single-product .corzo-header-background-transparent{ background-image: url(#gdlr#); background-position: center; background-size: cover; }'
					),
					'default-search-title-background' => array(
						'title' => esc_html__('Default Search Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.search .corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-archive-title-background' => array(
						'title' => esc_html__('Default Archive Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.archive .corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-404-background' => array(
						'title' => esc_html__('Default 404 Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => '.corzo-not-found-wrap .corzo-not-found-background{ background-image: url(#gdlr#); }'
					),
					'default-404-background-opacity' => array(
						'title' => esc_html__('Default 404 Background Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '27',
						'selector' => '.corzo-not-found-wrap .corzo-not-found-background{ opacity: #gdlr#; }'
					),

				) 
			), // title background

			'blog-title-style' => array(
				'title' => esc_html__('Blog Title Style', 'corzo'),
				'options' => array(

					'default-blog-title-style' => array(
						'title' => esc_html__('Default Blog Title Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'small' => esc_html__('Small', 'corzo'),
							'large' => esc_html__('Large', 'corzo'),
							'custom' => esc_html__('Custom', 'corzo'),
							'inside-content' => esc_html__('Inside Content', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'small'
					),
					'default-blog-title-top-padding' => array(
						'title' => esc_html__('Default Blog Title Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '400',
						'default' => '93px',
						'selector' => '.corzo-blog-title-wrap.corzo-style-custom .corzo-blog-title-content{ padding-top: #gdlr#; }',
						'condition' => array( 'default-blog-title-style' => 'custom' )
					),
					'default-blog-title-bottom-padding' => array(
						'title' => esc_html__('Default Blog Title Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '400',
						'default' => '87px',
						'selector' => '.corzo-blog-title-wrap.corzo-style-custom .corzo-blog-title-content{ padding-bottom: #gdlr#; }',
						'condition' => array( 'default-blog-title-style' => 'custom' )
					),
					'default-blog-feature-image' => array(
						'title' => esc_html__('Default Blog Feature Image Location', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'content' => esc_html__('Inside Content', 'corzo'),
							'title-background' => esc_html__('Title Background', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'content',
						'condition' => array( 'default-blog-title-style' => array('small', 'large', 'custom') )
					),
					'default-blog-title-background-image' => array(
						'title' => esc_html__('Default Blog Title Background Image', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => '.corzo-blog-title-wrap{ background-image: url(#gdlr#); }',
						'condition' => array( 'default-blog-title-style' => array('small', 'large', 'custom') )
					),
					'default-blog-top-bottom-gradient' => array(
						'title' => esc_html__('Default Blog ( Feature Image ) Title Top/Bottom Gradient', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'enable' => esc_html__('Both', 'corzo'),
							'top' => esc_html__('Top', 'corzo'),
							'bottom' => esc_html__('Bottom', 'corzo'),
							'disable' => esc_html__('None', 'corzo'),
						),
						'default' => 'enable',
					),
					'single-blog-title-top-gradient-size' => array(
						'title' => esc_html__('Single Blog Title Top Gradient Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '1000',
 						'default' => '413px',
						'selector' => '.corzo-blog-title-wrap.corzo-feature-image .corzo-blog-title-top-overlay{ height: #gdlr#; }',
					),
					'single-blog-title-bottom-gradient-size' => array(
						'title' => esc_html__('Single Blog Title Bottom Gradient Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '1000',
 						'default' => '413px',
						'selector' => '.corzo-blog-title-wrap.corzo-feature-image .corzo-blog-title-bottom-overlay{ height: #gdlr#; }',
					),
					'default-blog-title-background-overlay-opacity' => array(
						'title' => esc_html__('Default Blog Title Background Overlay Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '80',
						'selector' => '.corzo-blog-title-wrap .corzo-blog-title-overlay{ opacity: #gdlr#; }',
						'condition' => array( 'default-blog-title-style' => array('small', 'large', 'custom') )
					),

				) 
			), // post title style			

			'blog-style' => array(
				'title' => esc_html__('Blog Style', 'corzo'),
				'options' => array(
					'blog-style' => array(
						'title' => esc_html__('Single Blog Head ( Title ) Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
							'style-3' => esc_html__('Style 3', 'corzo'),
							'style-4' => esc_html__('Style 4', 'corzo'),
							'magazine' => esc_html__('Magazine', 'corzo')
						),
						'default' => 'style-1'
					),
					'blog-title-style' => array(
						'title' => esc_html__('Single Blog Title Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'' => esc_html__('Default', 'corzo'),
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
							'style-4' => esc_html__('Style 4', 'corzo')
						)
					),
					'blog-title-divider' => array(
						'title' => esc_html__('Single Blog Title Divider', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'blog-date-feature' => array(
						'title' => esc_html__('Enable Blog Date Feature', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'blog-title-style' => 'style-1' )
					),
					'blog-date-feature-year' => array(
						'title' => esc_html__('Enable Year on Blog Date Feature', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable',
						'condition' => array( 'blog-title-style' => 'style-1', 'blog-date-feature' => 'enable' )
					),
					'blockquote-style' => array(
						'title' => esc_html__('Blockquote Style ( <blockquote> tag )', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
							'style-3' => esc_html__('Style 3', 'corzo')
						),
						'default' => 'style-1'
					),
					'blog-sidebar' => array(
						'title' => esc_html__('Single Blog Sidebar ( Default )', 'corzo'),
						'type' => 'radioimage',
						'options' => 'sidebar',
						'default' => 'none',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'blog-sidebar-left' => array(
						'title' => esc_html__('Single Blog Sidebar Left ( Default )', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'blog-sidebar'=>array('left', 'both') )
					),
					'blog-sidebar-right' => array(
						'title' => esc_html__('Single Blog Sidebar Right ( Default )', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'blog-sidebar'=>array('right', 'both') )
					),
					'blog-max-content-width' => array(
						'title' => esc_html__('Single Blog Max Content Width ( No sidebar layout )', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'data-input-type' => 'pixel',
						'default' => '900px',
						'selector' => 'body.single-post .corzo-sidebar-style-none, body.blog .corzo-sidebar-style-none, ' . 
							'.corzo-blog-style-2 .corzo-comment-content{ max-width: #gdlr#; }'
					),
					'blog-thumbnail-size' => array(
						'title' => esc_html__('Single Blog Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size',
						'default' => 'full'
					),
					'meta-option' => array(
						'title' => esc_html__('Meta Option', 'corzo'),
						'type' => 'multi-combobox',
						'options' => array( 
							'date' => esc_html__('Date', 'corzo'),
							'author' => esc_html__('Author', 'corzo'),
							'category' => esc_html__('Category', 'corzo'),
							'tag' => esc_html__('Tag', 'corzo'),
							'comment' => esc_html__('Comment', 'corzo'),
							'comment-number' => esc_html__('Comment Number', 'corzo'),
						),
						'default' => array('author', 'category', 'tag', 'comment-number')
					),
					'blog-author' => array(
						'title' => esc_html__('Enable Single Blog Author', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'blog-navigation' => array(
						'title' => esc_html__('Enable Single Blog Navigation', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'pagination-style' => array(
						'title' => esc_html__('Pagination Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'plain' => esc_html__('Plain', 'corzo'),
							'rectangle' => esc_html__('Rectangle', 'corzo'),
							'rectangle-border' => esc_html__('Rectangle Border', 'corzo'),
							'round' => esc_html__('Round', 'corzo'),
							'round-border' => esc_html__('Round Border', 'corzo'),
							'circle' => esc_html__('Circle', 'corzo'),
							'circle-border' => esc_html__('Circle Border', 'corzo'),
						),
						'default' => 'round'
					),
					'pagination-align' => array(
						'title' => esc_html__('Pagination Alignment', 'corzo'),
						'type' => 'radioimage',
						'options' => 'text-align',
						'default' => 'right'
					),
					'enable-related-post' => array(
						'title' => esc_html__('Enable Related Post', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
					),
					'related-post-blog-style' => array(
						'title' => esc_html__('Related Post Blog Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'blog-column' => esc_html__('Blog Column', 'corzo'), 
							'blog-column-with-frame' => esc_html__('Blog Column With Frame', 'corzo'), 
						),
						'default' => 'blog-column-with-frame',
					),
					'related-post-blog-column-style' => array(
						'title' => esc_html__('Related Post Blog Column Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'), 
							'style-2' => esc_html__('Style 2', 'corzo'), 
							'style-3' => esc_html__('Style 3', 'corzo'), 
						),
						'default' => 'blog-column-with-frame',
					),
					'related-post-column-size' => array(
						'title' => esc_html__('Related Post Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60 => 1, 30 => 2, 20 => 3, 15 => 4, 12 => 5 ),
						'default' => '20',
					),
					'related-post-meta-option' => array(
						'title' => esc_html__('Related Post Meta Option', 'corzo'),
						'type' => 'multi-combobox',
						'options' => array(
							'date' => esc_html__('Date', 'corzo'),
							'author' => esc_html__('Author', 'corzo'),
							'category' => esc_html__('Category', 'corzo'),
							'tag' => esc_html__('Tag', 'corzo'),
							'comment' => esc_html__('Comment', 'corzo'),
							'comment-number' => esc_html__('Comment Number', 'corzo'),
						),
						'default' => array('date', 'author', 'category', 'comment-number'),
					),
					'related-post-thumbnail-size' => array(
						'title' => esc_html__('Related Post Blog Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size',
						'default' => 'full',
					),
					'related-post-num-fetch' => array(
						'title' => esc_html__('Related Post Num Fetch', 'corzo'),
						'type' => 'text',
						'default' => '3',
					),
					'related-post-excerpt-number' => array(
						'title' => esc_html__('Related Post Excerpt Number', 'corzo'),
						'type' => 'text',
						'default' => '0',
					),
				) // blog-style-options
			), // blog-style-nav

			'blog-social-share' => array(
				'title' => esc_html__('Blog Social Share', 'corzo'),
				'options' => array(
					'blog-social-share' => array(
						'title' => esc_html__('Enable Single Blog Share', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'blog-social-share-count' => array(
						'title' => esc_html__('Enable Single Blog Share Count', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'blog-social-facebook' => array(
						'title' => esc_html__('Facebook', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'blog-facebook-access-token' => array(
						'title' => esc_html__('Facebook Access Token', 'corzo'),
						'type' => 'text',
					),	
					'blog-social-linkedin' => array(
						'title' => esc_html__('Linkedin', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),			
					'blog-social-google-plus' => array(
						'title' => esc_html__('Google Plus', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),			
					'blog-social-pinterest' => array(
						'title' => esc_html__('Pinterest', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),			
					'blog-social-stumbleupon' => array(
						'title' => esc_html__('Stumbleupon', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),			
					'blog-social-twitter' => array(
						'title' => esc_html__('Twitter', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),			
					'blog-social-email' => array(
						'title' => esc_html__('Email', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
				) // blog-style-options
			), // blog-style-nav
			
			'event' => array(
				'title' => esc_html__('Event', 'corzo'),
				'options' => array(
					'default-event-title-background' => array(
						'title' => esc_html__('Default Event Title Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => 'body.single-event .corzo-page-title-wrap{ background-image: url(#gdlr#); }'
					),
					'default-event-sidebar' => array(
						'title' => esc_html__('Default Event Sidebar', 'corzo'),
						'type' => 'radioimage',
						'options' => 'sidebar',
						'default' => 'none',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'default-event-sidebar-left' => array(
						'title' => esc_html__('Default Event Sidebar Left', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'default-event-sidebar'=>array('left', 'both') )
					),
					'default-event-sidebar-right' => array(
						'title' => esc_html__('Default Event Sidebar Right', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'default-event-sidebar'=>array('right', 'both') )
					),
				)
			),
			
			'search-archive' => array(
				'title' => esc_html__('Search/Archive', 'corzo'),
				'options' => array(
					'archive-blog-sidebar' => array(
						'title' => esc_html__('Archive Blog Sidebar', 'corzo'),
						'type' => 'radioimage',
						'options' => 'sidebar',
						'default' => 'right',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'archive-blog-sidebar-left' => array(
						'title' => esc_html__('Archive Blog Sidebar Left', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'archive-blog-sidebar'=>array('left', 'both') )
					),
					'archive-blog-sidebar-right' => array(
						'title' => esc_html__('Archive Blog Sidebar Right', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'archive-blog-sidebar'=>array('right', 'both') )
					),
					'archive-blog-style' => array(
						'title' => esc_html__('Archive Blog Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'blog-full' => GDLR_CORE_URL . '/include/images/blog-style/blog-full.png',
							'blog-full-with-frame' => GDLR_CORE_URL . '/include/images/blog-style/blog-full-with-frame.png',
							'blog-column' => GDLR_CORE_URL . '/include/images/blog-style/blog-column.png',
							'blog-column-with-frame' => GDLR_CORE_URL . '/include/images/blog-style/blog-column-with-frame.png',
							'blog-column-no-space' => GDLR_CORE_URL . '/include/images/blog-style/blog-column-no-space.png',
							'blog-image' => GDLR_CORE_URL . '/include/images/blog-style/blog-image.png',
							'blog-image-no-space' => GDLR_CORE_URL . '/include/images/blog-style/blog-image-no-space.png',
							'blog-left-thumbnail' => GDLR_CORE_URL . '/include/images/blog-style/blog-left-thumbnail.png',
							'blog-right-thumbnail' => GDLR_CORE_URL . '/include/images/blog-style/blog-right-thumbnail.png',
						),
						'default' => 'blog-full',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'archive-blog-full-style' => array(
						'title' => esc_html__('Blog Full Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
						),
						'condition' => array( 'archive-blog-style'=>array('blog-full', 'blog-full-with-frame') )
					),
					'archive-blog-side-thumbnail-style' => array(
						'title' => esc_html__('Blog Side Thumbnail Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-1-large' => esc_html__('Style 1 Large Thumbnail', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
							'style-2-large' => esc_html__('Style 2 Large Thumbnail', 'corzo'),
						),
						'condition' => array( 'archive-blog-style'=>array('blog-left-thumbnail', 'blog-right-thumbnail') )
					),
					'archive-blog-column-style' => array(
						'title' => esc_html__('Blog Column Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
						),
						'condition' => array( 'archive-blog-style'=>array('blog-column', 'blog-column-with-frame', 'blog-column-no-space') )
					),
					'archive-blog-image-style' => array(
						'title' => esc_html__('Blog Image Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'style-1' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
						),
						'condition' => array( 'archive-blog-style'=>array('blog-image', 'blog-image-no-space') )
					),
					'archive-blog-full-alignment' => array(
						'title' => esc_html__('Archive Blog Full Alignment', 'corzo'),
						'type' => 'combobox',
						'default' => 'enable',
						'options' => array(
							'left' => esc_html__('Left', 'corzo'),
							'center' => esc_html__('Center', 'corzo'),
						),
						'condition' => array( 'archive-blog-style' => array('blog-full', 'blog-full-with-frame') )
					),
					'archive-thumbnail-size' => array(
						'title' => esc_html__('Archive Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size'
					),
					'archive-show-thumbnail' => array(
						'title' => esc_html__('Archive Show Thumbnail', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'archive-blog-style' => array('blog-full', 'blog-full-with-frame', 'blog-column', 'blog-column-with-frame', 'blog-column-no-space', 'blog-left-thumbnail', 'blog-right-thumbnail') )
					),
					'archive-column-size' => array(
						'title' => esc_html__('Archive Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60 => 1, 30 => 2, 20 => 3, 15 => 4, 12 => 5 ),
						'default' => 20,
						'condition' => array( 'archive-blog-style' => array('blog-column', 'blog-column-with-frame', 'blog-column-no-space', 'blog-image', 'blog-image-no-space') )
					),
					'archive-excerpt' => array(
						'title' => esc_html__('Archive Excerpt Type', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'specify-number' => esc_html__('Specify Number', 'corzo'),
							'show-all' => esc_html__('Show All ( use <!--more--> tag to cut the content )', 'corzo'),
						),
						'default' => 'specify-number',
						'condition' => array('archive-blog-style' => array('blog-full', 'blog-full-with-frame', 'blog-column', 'blog-column-with-frame', 'blog-column-no-space', 'blog-left-thumbnail', 'blog-right-thumbnail'))
					),
					'archive-excerpt-number' => array(
						'title' => esc_html__('Archive Excerpt Number', 'corzo'),
						'type' => 'text',
						'default' => 55,
						'data-input-type' => 'number',
						'condition' => array('archive-blog-style' => array('blog-full', 'blog-full-with-frame', 'blog-column', 'blog-column-with-frame', 'blog-column-no-space', 'blog-left-thumbnail', 'blog-right-thumbnail'), 'archive-excerpt' => 'specify-number')
					),
					'archive-date-feature' => array(
						'title' => esc_html__('Enable Blog Date Feature', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'archive-blog-style' => array('blog-full', 'blog-full-with-frame', 'blog-left-thumbnail', 'blog-right-thumbnail') )
					),
					'archive-meta-option' => array(
						'title' => esc_html__('Archive Meta Option', 'corzo'),
						'type' => 'multi-combobox',
						'options' => array( 
							'date' => esc_html__('Date', 'corzo'),
							'author' => esc_html__('Author', 'corzo'),
							'category' => esc_html__('Category', 'corzo'),
							'tag' => esc_html__('Tag', 'corzo'),
							'comment' => esc_html__('Comment', 'corzo'),
							'comment-number' => esc_html__('Comment Number', 'corzo'),
						),
						'default' => array('date', 'author', 'category')
					),
					'archive-show-read-more' => array(
						'title' => esc_html__('Archive Show Read More Button', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array('archive-blog-style' => array('blog-full', 'blog-full-with-frame', 'blog-left-thumbnail', 'blog-right-thumbnail'),)
					),
					'archive-blog-title-font-size' => array(
						'title' => esc_html__('Blog Title Font Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
					),
					'archive-blog-title-font-weight' => array(
						'title' => esc_html__('Blog Title Font Weight', 'corzo'),
						'type' => 'text',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),
					'archive-blog-title-letter-spacing' => array(
						'title' => esc_html__('Blog Title Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
					),
					'archive-blog-title-text-transform' => array(
						'title' => esc_html__('Blog Title Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'none' => esc_html__('None', 'corzo'),
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
						),
						'default' => 'none'
					),
				)
			),

			'woocommerce-style' => array(
				'title' => esc_html__('Woocommerce Style', 'corzo'),
				'options' => array(

					'woocommerce-archive-sidebar' => array(
						'title' => esc_html__('Woocommerce Archive Sidebar', 'corzo'),
						'type' => 'radioimage',
						'options' => 'sidebar',
						'default' => 'right',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'woocommerce-archive-sidebar-left' => array(
						'title' => esc_html__('Woocommerce Archive Sidebar Left', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'woocommerce-archive-sidebar'=>array('left', 'both') )
					),
					'woocommerce-archive-sidebar-right' => array(
						'title' => esc_html__('Woocommerce Archive Sidebar Right', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'woocommerce-archive-sidebar'=>array('right', 'both') )
					),
					'woocommerce-archive-product-style' => array(
						'title' => esc_html__('Woocommerce Archive Product Style', 'corzo'),
						'type' => 'combobox',
						'options' => array( 
							'grid' => esc_html__('Grid', 'corzo'),
							'grid-2' => esc_html__('Grid 2', 'corzo'),
							'grid-3' => esc_html__('Grid 3', 'corzo'),
							'grid-4' => esc_html__('Grid 4', 'corzo'),
						),
						'default' => 'grid'
					),
					'woocommerce-archive-product-amount' => array(
						'title' => esc_html__('Woocommerce Archive Product Amount', 'corzo'),
						'type' => 'text',
					),
					'woocommerce-archive-column-size' => array(
						'title' => esc_html__('Woocommerce Archive Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60 => 1, 30 => 2, 20 => 3, 15 => 4, 12 => 5, 10 => 6, ),
						'default' => 15
					),
					'woocommerce-archive-thumbnail' => array(
						'title' => esc_html__('Woocommerce Archive Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size',
						'default' => 'full'
					),
					'woocommerce-related-product-column-size' => array(
						'title' => esc_html__('Woocommerce Related Product Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60 => 1, 30 => 2, 20 => 3, 15 => 4, 12 => 5, 10 => 6, ),
						'default' => 15
					),
					'woocommerce-related-product-num-fetch' => array(
						'title' => esc_html__('Woocommerce Related Product Num Fetch', 'corzo'),
						'type' => 'text',
						'default' => 4,
						'data-input-type' => 'number'
					),
					'woocommerce-related-product-thumbnail' => array(
						'title' => esc_html__('Woocommerce Related Product Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size',
						'default' => 'full'
					),
				)
			),

			'portfolio-style' => array(
				'title' => esc_html__('Portfolio Style', 'corzo'),
				'options' => array(
					'portfolio-slug' => array(
						'title' => esc_html__('Portfolio Slug (Permalink)', 'corzo'),
						'type' => 'text',
						'default' => 'portfolio',
						'description' => esc_html__('Please save the "Settings > Permalink" area once after made a changes to this field.', 'corzo')
					),
					'portfolio-category-slug' => array(
						'title' => esc_html__('Portfolio Category Slug (Permalink)', 'corzo'),
						'type' => 'text',
						'default' => 'portfolio_category',
						'description' => esc_html__('Please save the "Settings > Permalink" area once after made a changes to this field.', 'corzo')
					),
					'portfolio-tag-slug' => array(
						'title' => esc_html__('Portfolio Tag Slug (Permalink)', 'corzo'),
						'type' => 'text',
						'default' => 'portfolio_tag',
						'description' => esc_html__('Please save the "Settings > Permalink" area once after made a changes to this field.', 'corzo')
					),
					'enable-single-portfolio-navigation' => array(
						'title' => esc_html__('Enable Single Portfolio Navigation', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'disable' => esc_html__('Disable', 'corzo'),
							'enable' => esc_html__('Style 1', 'corzo'),
							'style-2' => esc_html__('Style 2', 'corzo'),
						),
						'default' => 'enable'
					),
					'enable-single-portfolio-navigation-in-same-tag' => array(
						'title' => esc_html__('Enable Single Portfolio Navigation Within Same Tag', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'enable-single-portfolio-navigation' => array('enable', 'style-2') )
					),
					'single-portfolio-navigation-middle-link' => array(
						'title' => esc_html__('Single Portfolio Navigation Middle Link', 'corzo'),
						'type' => 'text',
						'default' => '#',
						'condition' => array( 'enable-single-portfolio-navigation' => 'style-2' )
					),
					'portfolio-icon-hover-link' => array(
						'title' => esc_html__('Portfolio Hover Icon (Link)', 'corzo'),
						'type' => 'radioimage',
						'options' => 'hover-icon-link',
						'default' => 'icon_link_alt'
					),
					'portfolio-icon-hover-video' => array(
						'title' => esc_html__('Portfolio Hover Icon (Video)', 'corzo'),
						'type' => 'radioimage',
						'options' => 'hover-icon-video',
						'default' => 'icon_film'
					),
					'portfolio-icon-hover-image' => array(
						'title' => esc_html__('Portfolio Hover Icon (Image)', 'corzo'),
						'type' => 'radioimage',
						'options' => 'hover-icon-image',
						'default' => 'icon_zoom-in_alt'
					),
					'portfolio-icon-hover-size' => array(
						'title' => esc_html__('Portfolio Hover Icon Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '22px',
						'selector' => '.gdlr-core-portfolio-thumbnail .gdlr-core-portfolio-icon{ font-size: #gdlr#; }' 
					),
					'enable-related-portfolio' => array(
						'title' => esc_html__('Enable Related Portfolio', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'related-portfolio-style' => array(
						'title' => esc_html__('Related Portfolio Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'grid' => esc_html__('Grid', 'corzo'),
							'modern' => esc_html__('Modern', 'corzo'),
						),
						'condition' => array('enable-related-portfolio'=>'enable')
					),
					'related-portfolio-column-size' => array(
						'title' => esc_html__('Related Portfolio Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60 => 1, 30 => 2, 20 => 3, 15 => 4, 12 => 5, 10 => 6, ),
						'default' => 15,
						'condition' => array('enable-related-portfolio'=>'enable')
					),
					'related-portfolio-num-fetch' => array(
						'title' => esc_html__('Related Portfolio Num Fetch', 'corzo'),
						'type' => 'text',
						'default' => 4,
						'data-input-type' => 'number',
						'condition' => array('enable-related-portfolio'=>'enable')
					),
					'related-portfolio-thumbnail-size' => array(
						'title' => esc_html__('Related Portfolio Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size',
						'condition' => array('enable-related-portfolio'=>'enable'),
						'default' => 'medium'
					),
					'related-portfolio-num-excerpt' => array(
						'title' => esc_html__('Related Portfolio Num Excerpt', 'corzo'),
						'type' => 'text',
						'default' => 20,
						'data-input-type' => 'number',
						'condition' => array('enable-related-portfolio'=>'enable', 'related-portfolio-style'=>'grid')
					),
				)
			),

			'portfolio-archive' => array(
				'title' => esc_html__('Portfolio Archive', 'corzo'),
				'options' => array(
					'archive-portfolio-sidebar' => array(
						'title' => esc_html__('Archive Portfolio Sidebar', 'corzo'),
						'type' => 'radioimage',
						'options' => 'sidebar',
						'default' => 'none',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'archive-portfolio-sidebar-left' => array(
						'title' => esc_html__('Archive Portfolio Sidebar Left', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'archive-portfolio-sidebar'=>array('left', 'both') )
					),
					'archive-portfolio-sidebar-right' => array(
						'title' => esc_html__('Archive Portfolio Sidebar Right', 'corzo'),
						'type' => 'combobox',
						'options' => 'sidebar',
						'default' => 'none',
						'condition' => array( 'archive-portfolio-sidebar'=>array('right', 'both') )
					),
					'archive-portfolio-style' => array(
						'title' => esc_html__('Archive Portfolio Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'modern' => get_template_directory_uri() . '/include/options/images/portfolio/modern.png',
							'modern-no-space' => get_template_directory_uri() . '/include/options/images/portfolio/modern-no-space.png',
							'grid' => get_template_directory_uri() . '/include/options/images/portfolio/grid.png',
							'grid-no-space' => get_template_directory_uri() . '/include/options/images/portfolio/grid-no-space.png',
							'modern-desc' => get_template_directory_uri() . '/include/options/images/portfolio/modern-desc.png',
							'modern-desc-no-space' => get_template_directory_uri() . '/include/options/images/portfolio/modern-desc-no-space.png',
							'medium' => get_template_directory_uri() . '/include/options/images/portfolio/medium.png',
						),
						'default' => 'medium',
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'archive-portfolio-thumbnail-size' => array(
						'title' => esc_html__('Archive Portfolio Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => 'thumbnail-size'
					),
					'archive-portfolio-grid-text-align' => array(
						'title' => esc_html__('Archive Portfolio Grid Text Align', 'corzo'),
						'type' => 'radioimage',
						'options' => 'text-align',
						'default' => 'left',
						'condition' => array( 'archive-portfolio-style' => array( 'grid', 'grid-no-space' ) )
					),
					'archive-portfolio-grid-style' => array(
						'title' => esc_html__('Archive Portfolio Grid Content Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'normal' => esc_html__('Normal', 'corzo'),
							'with-frame' => esc_html__('With Frame', 'corzo'),
							'with-bottom-border' => esc_html__('With Bottom Border', 'corzo'),
						),
						'default' => 'normal',
						'condition' => array( 'archive-portfolio-style' => array( 'grid', 'grid-no-space' ) )
					),
					'archive-enable-portfolio-tag' => array(
						'title' => esc_html__('Archive Enable Portfolio Tag', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'archive-portfolio-style' => array( 'grid', 'grid-no-space', 'modern-desc', 'modern-desc-no-space', 'medium' ) )
					),
					'archive-portfolio-medium-size' => array(
						'title' => esc_html__('Archive Portfolio Medium Thumbnail Size', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'small' => esc_html__('Small', 'corzo'),
							'large' => esc_html__('Large', 'corzo'),
						),
						'condition' => array( 'archive-portfolio-style' => 'medium' )
					),
					'archive-portfolio-medium-style' => array(
						'title' => esc_html__('Archive Portfolio Medium Thumbnail Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'left' => esc_html__('Left', 'corzo'),
							'right' => esc_html__('Right', 'corzo'),
							'switch' => esc_html__('Switch ( Between Left and Right )', 'corzo'),
						),
						'default' => 'switch',
						'condition' => array( 'archive-portfolio-style' => 'medium' )
					),
					'archive-portfolio-hover' => array(
						'title' => esc_html__('Archive Portfolio Hover Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'title' => get_template_directory_uri() . '/include/options/images/portfolio/hover/title.png',
							'title-icon' => get_template_directory_uri() . '/include/options/images/portfolio/hover/title-icon.png',
							'title-tag' => get_template_directory_uri() . '/include/options/images/portfolio/hover/title-tag.png',
							'icon-title-tag' => get_template_directory_uri() . '/include/options/images/portfolio/hover/icon-title-tag.png',
							'icon' => get_template_directory_uri() . '/include/options/images/portfolio/hover/icon.png',
							'margin-title' => get_template_directory_uri() . '/include/options/images/portfolio/hover/margin-title.png',
							'margin-title-icon' => get_template_directory_uri() . '/include/options/images/portfolio/hover/margin-title-icon.png',
							'margin-title-tag' => get_template_directory_uri() . '/include/options/images/portfolio/hover/margin-title-tag.png',
							'margin-icon-title-tag' => get_template_directory_uri() . '/include/options/images/portfolio/hover/margin-icon-title-tag.png',
							'margin-icon' => get_template_directory_uri() . '/include/options/images/portfolio/hover/margin-icon.png',
							'none' => get_template_directory_uri() . '/include/options/images/portfolio/hover/none.png',
						),
						'default' => 'icon',
						'max-width' => '100px',
						'condition' => array( 'archive-portfolio-style' => array('modern', 'modern-no-space', 'grid', 'grid-no-space', 'medium') ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'archive-portfolio-column-size' => array(
						'title' => esc_html__('Archive Portfolio Column Size', 'corzo'),
						'type' => 'combobox',
						'options' => array( 60=>1, 30=>2, 20=>3, 15=>4, 12=>5 ),
						'default' => 20,
						'condition' => array( 'archive-portfolio-style' => array('modern', 'modern-no-space', 'grid', 'grid-no-space', 'modern-desc', 'modern-desc-no-space') )
					),
					'archive-portfolio-excerpt' => array(
						'title' => esc_html__('Archive Portfolio Excerpt Type', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'specify-number' => esc_html__('Specify Number', 'corzo'),
							'show-all' => esc_html__('Show All ( use <!--more--> tag to cut the content )', 'corzo'),
							'none' => esc_html__('Disable Exceprt', 'corzo'),
						),
						'default' => 'specify-number',
						'condition' => array( 'archive-portfolio-style' => array( 'grid', 'grid-no-space', 'modern-desc', 'modern-desc-no-space', 'medium' ) )
					),
					'archive-portfolio-excerpt-number' => array(
						'title' => esc_html__('Archive Portfolio Excerpt Number', 'corzo'),
						'type' => 'text',
						'default' => 55,
						'data-input-type' => 'number',
						'condition' => array( 'archive-portfolio-style' => array( 'grid', 'grid-no-space', 'modern-desc', 'modern-desc-no-space', 'medium' ), 'archive-portfolio-excerpt' => 'specify-number' )
					),

				)
			),

			'personnel-style' => array(
				'title' => esc_html__('Personnel Style', 'corzo'),
				'options' => array(
					'personnel-slug' => array(
						'title' => esc_html__('Personnel Slug (Permalink)', 'corzo'),
						'type' => 'text',
						'default' => 'personnel',
						'description' => esc_html__('Please save the "Settings > Permalink" area once after made a changes to this field.', 'corzo')
					),
					'personnel-category-slug' => array(
						'title' => esc_html__('Personnel Category Slug (Permalink)', 'corzo'),
						'type' => 'text',
						'default' => 'personnel_category',
						'description' => esc_html__('Please save the "Settings > Permalink" area once after made a changes to this field.', 'corzo')
					),
				)
			),

			'footer' => array(
				'title' => esc_html__('Footer/Copyright', 'corzo'),
				'options' => array(

					'fixed-footer' => array(
						'title' => esc_html__('Fixed Footer', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
					'enable-footer' => array(
						'title' => esc_html__('Enable Footer', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'footer-background' => array(
						'title' => esc_html__('Footer Background', 'corzo'),
						'type' => 'upload',
						'data-type' => 'file',
						'selector' => '.corzo-footer-wrapper{ background-image: url(#gdlr#); background-size: cover; }',
						'condition' => array( 'enable-footer' => 'enable' )
					),
					'enable-footer-column-divider' => array(
						'title' => esc_html__('Enable Footer Column Divider', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'enable-footer' => 'enable' )
					),
					'footer-top-padding' => array(
						'title' => esc_html__('Footer Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '300',
						'data-type' => 'pixel',
						'default' => '70px',
						'selector' => '.corzo-footer-wrapper{ padding-top: #gdlr#; }',
						'condition' => array( 'enable-footer' => 'enable' )
					),
					'footer-bottom-padding' => array(
						'title' => esc_html__('Footer Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '300',
						'data-type' => 'pixel',
						'default' => '50px',
						'selector' => '.corzo-footer-wrapper{ padding-bottom: #gdlr#; }',
						'condition' => array( 'enable-footer' => 'enable' )
					),
					'footer-style' => array(
						'title' => esc_html__('Footer Style', 'corzo'),
						'type' => 'radioimage',
						'wrapper-class' => 'gdlr-core-fullsize',
						'options' => array(
							'footer-1' => get_template_directory_uri() . '/include/options/images/footer-style1.png',
							'footer-2' => get_template_directory_uri() . '/include/options/images/footer-style2.png',
							'footer-3' => get_template_directory_uri() . '/include/options/images/footer-style3.png',
							'footer-4' => get_template_directory_uri() . '/include/options/images/footer-style4.png',
							'footer-5' => get_template_directory_uri() . '/include/options/images/footer-style5.png',
							'footer-6' => get_template_directory_uri() . '/include/options/images/footer-style6.png',
						),
						'default' => 'footer-2',
						'condition' => array( 'enable-footer' => 'enable' )
					),
					'enable-copyright' => array(
						'title' => esc_html__('Enable Copyright', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'copyright-style' => array(
						'title' => esc_html__('Copyright Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'center' => esc_html__('Center', 'corzo'),
							'left-right' => esc_html__('Left & Right', 'corzo'),
						),
						'condition' => array( 'enable-copyright' => 'enable' )
					),
					'copyright-top-padding' => array(
						'title' => esc_html__('Copyright Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '300',
						'data-type' => 'pixel',
						'default' => '38px',
						'selector' => '.corzo-copyright-container{ padding-top: #gdlr#; }',
						'condition' => array( 'enable-copyright' => 'enable' )
					),
					'copyright-bottom-padding' => array(
						'title' => esc_html__('Copyright Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '300',
						'data-type' => 'pixel',
						'default' => '38px',
						'selector' => '.corzo-copyright-container{ padding-bottom: #gdlr#; }',
						'condition' => array( 'enable-copyright' => 'enable' )
					),	
					'copyright-text' => array(
						'title' => esc_html__('Copyright Text', 'corzo'),
						'type' => 'textarea',
						'wrapper-class' => 'gdlr-core-fullsize',
						'condition' => array( 'enable-copyright' => 'enable', 'copyright-style' => 'center' )
					),
					'copyright-left' => array(
						'title' => esc_html__('Copyright Left', 'corzo'),
						'type' => 'textarea',
						'wrapper-class' => 'gdlr-core-fullsize',
						'condition' => array( 'enable-copyright' => 'enable', 'copyright-style' => 'left-right' )
					),
					'copyright-right' => array(
						'title' => esc_html__('Copyright Right', 'corzo'),
						'type' => 'textarea',
						'wrapper-class' => 'gdlr-core-fullsize',
						'condition' => array( 'enable-copyright' => 'enable', 'copyright-style' => 'left-right' )
					),
					'enable-back-to-top' => array(
						'title' => esc_html__('Enable Back To Top Button', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
				) // footer-options
			), // footer-nav	
		
		) // general-options
		
	), 2);