<?php

	add_filter('gdlr_core_blog_info_prefix', 'corzo_gdlr_core_blog_info_prefix');
	if( !function_exists('corzo_gdlr_core_blog_info_prefix') ){
		function corzo_gdlr_core_blog_info_prefix($ret){
			return array(
				'date' => '<i class="icon_clock_alt" ></i>',
				'tag' => '<i class="icon_tags_alt" ></i>',
				'category' => '<i class="icon_folder-alt" ></i>',
				'comment' => '<i class="icon_comment_alt" ></i>',
				'like' => '<i class="icon_heart_alt" ></i>',
				'author' => esc_html__('By', 'corzo'),
				'comment-number' => '<i class="icon_comment_alt" ></i>',
			);
		}
	}
	
	add_filter('gdlr_core_blog_style_content', 'corzo_gdlr_core_blog_style_content', 10, 3);
	if( !function_exists('corzo_gdlr_core_blog_style_content') ){
		function corzo_gdlr_core_blog_style_content($ret, $args, $blog_style){

			if( in_array($args['blog-style'], array('blog-column', 'blog-column-no-space', 'blog-column-with-frame')) ){
				if( $args['blog-column-style'] == 'style-4' ){
					return corzo_blog_grid_style_4($args, $blog_style);
				}else if( $args['blog-column-style'] == 'style-4-left-button' ){
					$args['blog-column-style'] = 'style-4';
					$args['additional-class'] = 'gdlr-core-left-button '; 
					return corzo_blog_grid_style_4($args, $blog_style);
				}
			}

			return '';
		}
	}

	if( !function_exists('corzo_blog_grid_style_4') ){
		function corzo_blog_grid_style_4($args, $blog_style){

			$post_format = get_post_format();
			if( in_array($post_format, array('aside', 'quote', 'link')) ){
				$args['extra-class'] = ' gdlr-core-blog-grid gdlr-core-style-3 gdlr-core-small';
				if($args['blog-style'] == 'blog-column-with-frame' && $args['layout'] != 'masonry' ){
					$args['sync-height'] = true;
				}
				return $blog_style->blog_format( $args, $post_format );
			}

			$additional_class = empty($args['additional-class'])? '': $args['additional-class'];

			// shadow
			$blog_atts = array(
				'margin-bottom' => empty($args['margin-bottom'])? '': $args['margin-bottom']
			);
			$thumbnail_shadow = array();
			if($args['blog-style'] == 'blog-column-with-frame' ){
				$additional_class .= ' gdlr-core-blog-grid-with-frame gdlr-core-item-mgb gdlr-core-skin-e-background ';
				
				$blog_atts['border-width'] = empty($args['blog-frame-border-size'])? '': $args['blog-frame-border-size'];
				$blog_atts['border-color'] = empty($args['blog-frame-border-color'])? '': $args['blog-frame-border-color'];

				if( !empty($args['frame-shadow-size']['size']) && !empty($args['frame-shadow-color']) && !empty($args['frame-shadow-opacity']) ){
					$blog_atts['background-shadow-size'] = $args['frame-shadow-size'];
					$blog_atts['background-shadow-color'] = $args['frame-shadow-color'];
					$blog_atts['background-shadow-opacity'] = $args['frame-shadow-opacity'];
					$additional_class .= ' gdlr-core-outer-frame-element';
				}
				$blog_atts['border-radius'] = empty($args['blog-border-radius'])? '': $args['blog-border-radius'];
			}else{
				if( !empty($args['frame-shadow-size']['size']) && !empty($args['frame-shadow-color']) && !empty($args['frame-shadow-opacity']) ){
					$thumbnail_shadow['background-shadow-size'] = $args['frame-shadow-size'];
					$thumbnail_shadow['background-shadow-color'] = $args['frame-shadow-color'];
					$thumbnail_shadow['background-shadow-opacity'] = $args['frame-shadow-opacity'];
				}
				$thumbnail_shadow['border-radius'] = empty($args['blog-border-radius'])? '': $args['blog-border-radius'];
			}

			if( empty($args['show-thumbnail']) || $args['show-thumbnail'] == 'enable' ){
				$thumbnail_atts = array(
					'thumbnail-size' => $args['thumbnail-size'],
					'post-format' => $post_format,
					'post-format-gallery' => 'slider',
					'opacity-on-hover' => empty($args['enable-thumbnail-opacity-on-hover'])? 'enable': $args['enable-thumbnail-opacity-on-hover'],
					'zoom-on-hover' => empty($args['enable-thumbnail-zoom-on-hover'])? 'enable': $args['enable-thumbnail-zoom-on-hover'],
					'grayscale-effect' => empty($args['enable-thumbnail-grayscale-effect'])? 'disable': $args['enable-thumbnail-grayscale-effect']
				);
				$blog_thumbnail = $blog_style->blog_thumbnail($thumbnail_atts, $thumbnail_shadow);

				if( !empty($blog_thumbnail) ){
					$additional_class .= ' gdlr-core-with-thumbnail';
				} 
			}

			// move up with shadow effect
			if( $args['blog-style'] == 'blog-column-with-frame' && !empty($args['enable-move-up-shadow-effect']) && $args['enable-move-up-shadow-effect'] == 'enable' ){
				$additional_class .= ' gdlr-core-move-up-with-shadow gdlr-core-outer-frame-element';
			}

			if($args['blog-style'] == 'blog-column-with-frame' && $args['layout'] != 'masonry' ){
				$ret  = '<div class="gdlr-core-blog-grid gdlr-core-style-4 gdlr-core-js ' . esc_attr($additional_class) . '" ' . gdlr_core_esc_style($blog_atts);
				$ret .= ' data-sync-height="blog-item-' . esc_attr($blog_style->blog_item_id) . '" ';
				if( $post_format == 'audio' ){
					$ret .= ' data-sync-height-center';
				}
				$ret .= ' >';
			}else{
				$ret  = '<div class="gdlr-core-blog-grid gdlr-core-style-4 ' . esc_attr($additional_class) . '" ' . gdlr_core_esc_style($blog_atts) . ' >';
			}

			if( !empty($blog_thumbnail) ){
				$ret .= $blog_thumbnail;
			}
			
			if( $args['blog-style'] == 'blog-column-with-frame' ){
				$ret .= '<div class="gdlr-core-blog-grid-frame gdlr-core-sync-height-space-position clearfix" ' . gdlr_core_esc_style(array(
					'padding' => empty($args['blog-frame-padding'])? '': $args['blog-frame-padding'],
				)) . ' >';
			}else{
				$ret .= '<div class="gdlr-core-blog-grid-content-wrap clearfix">';
			}
			
			$meta = '';
			if( in_array('category', $args['meta-option']) ){
				$meta .= $blog_style->blog_info(array('display' => array('category')));
			}
			if( in_array('date', $args['meta-option']) ){
				$meta .= $blog_style->blog_info(array('display' => array('date')));
			}
			if( !empty($meta) ){
				$ret .= '<div class="gdlr-core-blog-grid-top-info clearfix" >' . $meta . '</div>';
			}

			$ret .= $blog_style->blog_title($args);
			$ret .= $blog_style->get_blog_excerpt($args);

			if( in_array('author', $args['meta-option']) ){
				$ret .= $blog_style->blog_info(array('display' => array('author')));
			}
			$ret .= '</div>'; // gdlr-core-blog-grid-content-wrap
			$ret .= '</div>'; // gdlr-core-blog-grid
			
			return $ret;
		}
	}