<?php
/**
 * The template part for displaying single posts
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="corzo-single-article corzo-style" >
		<?php
			ob_start();
			the_post_thumbnail('full');
			$post_thumbnail = ob_get_contents();
			ob_end_clean();

			if( !empty($post_thumbnail) ){
				echo '<div class="corzo-single-article-thumbnail corzo-media-image" >';
				echo gdlr_core_escape_content($post_thumbnail);
				if( is_sticky() ){
					echo '<div class="corzo-sticky-banner corzo-title-font" ><i class="fa fa-bolt" ></i>' . esc_html__('Sticky Post', 'corzo') . '</div>';
				}
				echo '</div>';
			}else{
				if( is_sticky() ){
					echo '<div class="corzo-sticky-banner corzo-title-font" ><i class="fa fa-bolt" ></i>' . esc_html__('Sticky Post', 'corzo') . '</div>';
				}
			}

			echo '<header class="corzo-single-article-head clearfix" >';
			echo '<h3 class="corzo-single-article-title"><a href="' . get_permalink() . '" >' . get_the_title() . '</a></h3>';

			$blog_info_atts = array( 'wrapper' => true );
			$blog_info_atts['display'] = corzo_get_option('general', 'meta-option', '');
			echo corzo_get_blog_info($blog_info_atts);

			echo '</header>';

			echo '<div class="corzo-single-article-content">';
			the_excerpt();
			echo '</div>';

			echo '<a class="corzo-button corzo-excerpt-read-more" href="' . get_permalink() . '">Read More</a>';
		?>
	</div><!-- corzo-single-article -->
</article><!-- post-id -->
