<?php
/**
 * The template for displaying the footer
 */
	
	$post_option = corzo_get_post_option(get_the_ID());
	if( empty($post_option['enable-footer']) || $post_option['enable-footer'] == 'default' ){
		$enable_footer = corzo_get_option('general', 'enable-footer', 'enable');
	}else{
		$enable_footer = $post_option['enable-footer'];
	}	
	if( empty($post_option['enable-copyright']) || $post_option['enable-copyright'] == 'default' ){
		$enable_copyright = corzo_get_option('general', 'enable-copyright', 'enable');
	}else{
		$enable_copyright = $post_option['enable-copyright'];
	}

	$fixed_footer = corzo_get_option('general', 'fixed-footer', 'disable');
	echo '</div>'; // corzo-page-wrapper

	if( $enable_footer == 'enable' || $enable_copyright == 'enable' ){

		if( $fixed_footer == 'enable' ){
			echo '</div>'; // corzo-body-wrapper

			echo '<footer class="corzo-fixed-footer" id="corzo-fixed-footer" >';
		}else{
			echo '<footer>';
		}

		if( $enable_footer == 'enable' ){

			$corzo_footer_layout = array(
				'footer-1'=>array('corzo-column-60'),
				'footer-2'=>array('corzo-column-15', 'corzo-column-15', 'corzo-column-15', 'corzo-column-15'),
				'footer-3'=>array('corzo-column-15', 'corzo-column-15', 'corzo-column-30',),
				'footer-4'=>array('corzo-column-20', 'corzo-column-20', 'corzo-column-20'),
				'footer-5'=>array('corzo-column-20', 'corzo-column-40'),
				'footer-6'=>array('corzo-column-40', 'corzo-column-20'),
			);
			$footer_style = corzo_get_option('general', 'footer-style');
			$footer_style = empty($footer_style)? 'footer-2': $footer_style;

			$count = 0;
			$has_widget = false;
			foreach( $corzo_footer_layout[$footer_style] as $layout ){ $count++;
				if( is_active_sidebar('footer-' . $count) ){ $has_widget = true; }
			}

			if( $has_widget ){ 	

				$footer_column_divider = corzo_get_option('general', 'enable-footer-column-divider', 'enable');
				$extra_class  = ($footer_column_divider == 'enable')? ' corzo-with-column-divider': '';

				echo '<div class="corzo-footer-wrapper ' . esc_attr($extra_class) . '" >';
				echo '<div class="corzo-footer-container corzo-container clearfix" >';
				
				$count = 0;
				foreach( $corzo_footer_layout[$footer_style] as $layout ){ $count++;
					echo '<div class="corzo-footer-column corzo-item-pdlr ' . esc_attr($layout) . '" >';
					if( is_active_sidebar('footer-' . $count) ){
						dynamic_sidebar('footer-' . $count); 
					}
					echo '</div>';
				}
				
				echo '</div>'; // corzo-footer-container
				echo '</div>'; // corzo-footer-wrapper 
			}
		} // enable footer

		if( $enable_copyright == 'enable' ){
			$copyright_style = corzo_get_option('general', 'copyright-style', 'center');
			
			if( $copyright_style == 'center' ){
				$copyright_text = corzo_get_option('general', 'copyright-text');

				if( !empty($copyright_text) ){
					echo '<div class="corzo-copyright-wrapper" >';
					echo '<div class="corzo-copyright-container corzo-container">';
					echo '<div class="corzo-copyright-text corzo-item-pdlr">';
					echo gdlr_core_escape_content(gdlr_core_text_filter($copyright_text));
					echo '</div>';
					echo '</div>';
					echo '</div>'; // corzo-copyright-wrapper
				}
			}else if( $copyright_style == 'left-right' ){
				$copyright_left = corzo_get_option('general', 'copyright-left');
				$copyright_right = corzo_get_option('general', 'copyright-right');

				if( !empty($copyright_left) || !empty($copyright_right) ){
					echo '<div class="corzo-copyright-wrapper" >';
					echo '<div class="corzo-copyright-container corzo-container clearfix">';
					if( !empty($copyright_left) ){
						echo '<div class="corzo-copyright-left corzo-item-pdlr">';
						echo gdlr_core_escape_content(gdlr_core_text_filter($copyright_left));
						echo '</div>';
					}

					if( !empty($copyright_right) ){
						echo '<div class="corzo-copyright-right corzo-item-pdlr">';
						echo gdlr_core_escape_content(gdlr_core_text_filter($copyright_right));
						echo '</div>';
					}
					echo '</div>';
					echo '</div>'; // corzo-copyright-wrapper
				}
			}
		}

		echo '</footer>';

		if( $fixed_footer == 'disable' ){
			echo '</div>'; // corzo-body-wrapper
		}
		echo '</div>'; // corzo-body-outer-wrapper

	// disable footer	
	}else{
		echo '</div>'; // corzo-body-wrapper
		echo '</div>'; // corzo-body-outer-wrapper
	}

	$header_style = corzo_get_option('general', 'header-style', 'plain');
	
	if( $header_style == 'side' || $header_style == 'side-toggle' ){
		echo '</div>'; // corzo-header-side-nav-content
	}

	$back_to_top = corzo_get_option('general', 'enable-back-to-top', 'disable');
	if( $back_to_top == 'enable' ){
		echo '<a href="#corzo-top-anchor" class="corzo-footer-back-to-top-button" id="corzo-footer-back-to-top-button"><i class="fa fa-angle-up" ></i></a>';
	}
?>

<?php wp_footer(); ?>

</body>
</html>