<?php
	/* a template for displaying the header area */

	// header container
	$header_width = corzo_get_option('general', 'header-width', 'boxed');
	
	if( $header_width == 'boxed' ){
		$header_container_class = ' corzo-container';
	}else if( $header_width == 'custom' ){
		$header_container_class = ' corzo-header-custom-container';
	}else{
		$header_container_class = ' corzo-header-full';
	}

	$header_style = corzo_get_option('general', 'header-boxed-style', 'menu-right');
	$navigation_offset = corzo_get_option('general', 'fixed-navigation-anchor-offset', '');

	$header_wrap_class  = ' corzo-style-' . $header_style;
	$header_wrap_class .= ' corzo-sticky-navigation corzo-style-slide';
?>	
<header class="corzo-header-wrap corzo-header-style-boxed <?php echo esc_attr($header_wrap_class); ?>" <?php
		if( !empty($navigation_offset) ){
			echo 'data-navigation-offset="' . esc_attr($navigation_offset) . '" ';
		}
	?> >
	<div class="corzo-header-container clearfix <?php echo esc_attr($header_container_class); ?>">
		<div class="corzo-header-container-inner clearfix">	

			<div class="corzo-header-background  corzo-item-mglr" ></div>
			<div class="corzo-header-container-item clearfix">
				<?php

					if( $header_style == 'splitted-menu' ){
						global $corzo_center_nav_item;
						$corzo_center_nav_item = corzo_get_logo();
					}else{
						echo corzo_get_logo();
					}

					$navigation_class = '';
					if( corzo_get_option('general', 'enable-main-navigation-submenu-indicator', 'disable') == 'enable' ){
						$navigation_class = 'corzo-navigation-submenu-indicator ';
					}
				?>
				<div class="corzo-navigation corzo-item-pdlr clearfix <?php echo esc_attr($navigation_class); ?>" >
				<?php
					// print main menu
					if( has_nav_menu('main_menu') ){
						echo '<div class="corzo-main-menu" id="corzo-main-menu" >';
						wp_nav_menu(array(
							'theme_location'=>'main_menu', 
							'container'=> '', 
							'menu_class'=> 'sf-menu',
							'walker' => new corzo_menu_walker()
						));
						
						corzo_get_navigation_slide_bar();
						
						echo '</div>';
					}

					if( $header_style == 'splitted-menu' ){
						$corzo_center_nav_item = '';
					}

					// menu right side
					$menu_right_class = '';
					if( $header_style == 'center-menu' || $header_style == 'splitted-menu' ){
						$menu_right_class = ' corzo-item-mglr corzo-navigation-top corzo-navigation-right';
					}

					$enable_search = (corzo_get_option('general', 'enable-main-navigation-search', 'enable') == 'enable')? true: false;
					$enable_cart = (corzo_get_option('general', 'enable-main-navigation-cart', 'enable') == 'enable' && class_exists('WooCommerce'))? true: false;
					$enable_right_button = (corzo_get_option('general', 'enable-main-navigation-right-button', 'disable') == 'enable')? true: false;
					$custom_main_menu_right = apply_filters('corzo_custom_main_menu_right', '');
					if( has_nav_menu('right_menu') || $enable_search || $enable_cart || $enable_right_button || !empty($custom_main_menu_right) ){
						echo '<div class="corzo-main-menu-right-wrap clearfix ' . esc_attr($menu_right_class) . '" >';

						// search icon
						if( $enable_search ){
							$search_icon = corzo_get_option('general', 'main-navigation-search-icon', 'fa fa-search');
							echo '<div class="corzo-main-menu-search" id="corzo-top-search" >';
							echo '<i class="' . esc_attr($search_icon) . '" ></i>';
							echo '</div>';
							corzo_get_top_search();
						}

						// cart icon
						if( $enable_cart ){
							$cart_icon = corzo_get_option('general', 'main-navigation-cart-icon', 'fa fa-shopping-cart');
							echo '<div class="corzo-main-menu-cart" id="corzo-main-menu-cart" >';
							echo '<i class="' . esc_attr($cart_icon) . '" data-corzo-lb="top-bar" ></i>';
							corzo_get_woocommerce_bar();
							echo '</div>';
						}

						// menu right button
						if( $enable_right_button ){
							$button_class = 'corzo-style-' . corzo_get_option('general', 'main-navigation-right-button-style', 'default');
							$button_link = corzo_get_option('general', 'main-navigation-right-button-link', '');
							$button_link_target = corzo_get_option('general', 'main-navigation-right-button-link-target', '_self');
							if( !empty($button_link) ){
								echo '<a class="corzo-main-menu-right-button corzo-button-1 ' . esc_attr($button_class) . '" href="' . esc_url($button_link) . '" target="' . esc_attr($button_link_target) . '" >';
								echo corzo_get_option('general', 'main-navigation-right-button-text', '');
								echo '</a>';
							}
							
							$button_class = 'corzo-style-' . corzo_get_option('general', 'main-navigation-right-button-style-2', 'default');
							$button_link = corzo_get_option('general', 'main-navigation-right-button-link-2', '');
							$button_link_target = corzo_get_option('general', 'main-navigation-right-button-link-target-2', '_self');
							if( !empty($button_link) ){
								echo '<a class="corzo-main-menu-right-button corzo-button-2 ' . esc_attr($button_class) . '" href="' . esc_url($button_link) . '" target="' . esc_attr($button_link_target) . '" >';
								echo corzo_get_option('general', 'main-navigation-right-button-text-2', '');
								echo '</a>';
							}
						}

						// custom menu right
						if( !empty($custom_main_menu_right) ){
							echo gdlr_core_text_filter($custom_main_menu_right);
						}

						// print right menu
						if( has_nav_menu('right_menu') && $header_style != 'splitted-menu' ){
							corzo_get_custom_menu(array(
								'container-class' => 'corzo-main-menu-right',
								'button-class' => 'corzo-right-menu-button corzo-top-menu-button',
								'icon-class' => 'fa fa-bars',
								'id' => 'corzo-right-menu',
								'theme-location' => 'right_menu',
								'type' => corzo_get_option('general', 'right-menu-type', 'right')
							));
						}

						echo '</div>'; // corzo-main-menu-right-wrap

						if( has_nav_menu('right_menu') && $header_style == 'splitted-menu' ){
							echo '<div class="corzo-main-menu-left-wrap clearfix corzo-item-pdlr corzo-navigation-top corzo-navigation-left" >';
							corzo_get_custom_menu(array(
								'container-class' => 'corzo-main-menu-right',
								'button-class' => 'corzo-right-menu-button corzo-top-menu-button',
								'icon-class' => 'fa fa-bars',
								'id' => 'corzo-right-menu',
								'theme-location' => 'right_menu',
								'type' => corzo_get_option('general', 'right-menu-type', 'right')
							));
							echo '</div>';
						}
					}
				?>
				</div><!-- corzo-navigation -->

			</div><!-- corzo-header-container-inner -->
		</div><!-- corzo-header-container-item -->
	</div><!-- corzo-header-container -->
</header><!-- header -->