<?php 
	/*	
	*	Goodlayers Core Plugin Filter
	*	---------------------------------------------------------------------
	*	This file contains the script to includes necessary function
	* 	for compatibility with goodlayers core plugin
	*	---------------------------------------------------------------------
	*/

	add_filter('gdlr_core_use_font_icons', 'corzo_gdlr_core_use_font_icons');
	if( !function_exists('corzo_gdlr_core_use_font_icons') ){
		function corzo_gdlr_core_use_font_icons( $icons ){
			return corzo_get_option('plugin', 'font-icon', $icons);
		}
	} 

	// add body class for page builder
	add_filter('gdlr_core_page_builder_body_class', 'corzo_page_builder_body_class');
	if( !function_exists('corzo_page_builder_body_class') ){
		function corzo_page_builder_body_class( $classes ) {
			return $classes . ' corzo-body';
		}
	}
	add_filter('gdlr_core_sidebar_class', 'corzo_gdlr_core_sidebar_class');
	if( !function_exists('corzo_gdlr_core_sidebar_class') ){
		function corzo_gdlr_core_sidebar_class( $classes ) {
			return $classes . ' corzo-sidebar-area';
		}
	}

	// Set the neccessary function to be used in the theme
	add_action('after_setup_theme', 'corzo_goodlayers_core_setup');
	if( !function_exists( 'corzo_goodlayers_core_setup' ) ){
		function corzo_goodlayers_core_setup(){

			// to set the goodlayers core plugin pagination
			add_filter('gdlr_core_pagination_style', 'corzo_gdlr_core_pagination_style');
			add_filter('gdlr_core_pagination_align', 'corzo_gdlr_core_pagination_align');

			// set the default social share option
			add_filter('gdlr_core_social_share_list', 'corzo_gdlr_core_social_share_list');

			// widget title navigation
			add_filter('gdlr_core_widget_title_nav', 'corzo_gdlr_core_widget_title_nav');

			// single portfolio
			add_filter('gdlr_core_custom_post_slug', 'corzo_gdlr_core_custom_post_slug', 10, 2);

			add_filter('gdlr_core_portfolio_single_nav', 'corzo_gdlr_core_portfolio_single_nav');
			add_filter('gdlr_core_portfolio_single_nav_same_term', 'corzo_gdlr_core_portfolio_single_nav_same_term');
			add_filter('gdlr_core_portfolio_single_nav_middle_link', 'corzo_gdlr_core_portfolio_single_nav_middle_link');
			add_filter('gdlr_core_portfolio_single_related', 'corzo_gdlr_core_portfolio_single_related');

			// srcset
			add_filter('gdlr_core_enable_srcset', 'corzo_gdlr_core_enable_srcset');

			// filter for portfolio icon hover
			add_filter('gdlr_core_portfolio_hover_icon_class', 'corzo_gdlr_core_portfolio_hover_icon_class');

			// youtube cookies
			add_filter('gdlr_core_privacy_settings', 'corzo_gdlr_core_privacy_settings');
		}
	}

	// youtube no cookies
	if( !function_exists('corzo_gdlr_core_privacy_settings') ){
		function corzo_gdlr_core_privacy_settings(){
			if( function_exists('gdlr_core_get_privacy_options') ){
				$privacy_options = gdlr_core_get_privacy_options(1) + gdlr_core_get_privacy_options(2);
				$privacy_settings = array();
				foreach( $privacy_options as $privacy_option_slug => $privacy_option ){
					$privacy_settings[$privacy_option_slug] = corzo_get_option('plugin', $privacy_option_slug, 
						(empty($privacy_option['default'])? '': $privacy_option['default']));
				}

				return $privacy_settings;
			}
			
			return array();
		}
	}

	add_filter('gdlr_core_google_font_display', 'corzo_gdlr_core_google_font_display');
	if( !function_exists('corzo_gdlr_core_google_font_display') ){
		function corzo_gdlr_core_google_font_display( $display ){
			return corzo_get_option('typography', 'google-font-display', '');
		}
	}
	

	// portfolio hover icon class
	if( !function_exists('corzo_gdlr_core_portfolio_hover_icon_class') ){
		function corzo_gdlr_core_portfolio_hover_icon_class( $type = '' ){
			if( $type == 'image' ){
			 	return corzo_get_option('general', 'portfolio-icon-hover-image', '');
			}else if( $type == 'video' ){
				return corzo_get_option('general', 'portfolio-icon-hover-video', '');
			}else if( $type == 'link' ){
				return corzo_get_option('general', 'portfolio-icon-hover-link', '');
			}
		}
	}

	// to enable srcset
	if( !function_exists('corzo_gdlr_core_enable_srcset') ){
		function corzo_gdlr_core_enable_srcset( $enable ){
			$enable_srcset = corzo_get_option('plugin', 'enable-srcset', 'disable');
			return ($enable_srcset == 'enable');
		}
	}

	// woocommerce shop amount
	add_filter('loop_shop_per_page', 'corzo_loop_shop_per_page', 9999);
	function corzo_loop_shop_per_page($per_page){
		$per_page = corzo_get_option('general', 'woocommerce-archive-product-amount', $per_page);
		return $per_page;
	}
			
	// for goodlayers core pagination
	if( !function_exists('corzo_gdlr_core_pagination_style') ){
		function corzo_gdlr_core_pagination_style( $style ) {
			return corzo_get_option('general', 'pagination-style', $style);
		}
	}
	if( !function_exists('corzo_gdlr_core_pagination_align') ){
		function corzo_gdlr_core_pagination_align( $align ) {
			return corzo_get_option('general', 'pagination-align', $align);
		}
	}			

	// custom post type slug
	if( !function_exists('corzo_gdlr_core_custom_post_slug') ){
		function corzo_gdlr_core_custom_post_slug( $slug, $type = '' ) {
			if( empty($type) ){ $type = $slug; }

			if( $type == 'portfolio' ){
				$slug = corzo_get_option('general', 'portfolio-slug', $slug);
			}else if( $type == 'portfolio_category' ){
				$slug = corzo_get_option('general', 'portfolio-category-slug', $slug);
			}else if( $type == 'portfolio_tag' ){
				$slug = corzo_get_option('general', 'portfolio-tag-slug', $slug);
			}else if( $type == 'personnel' ){
				$slug = corzo_get_option('general', 'personnel-slug', $slug);
			}else if( $type == 'personnel_category' ){
				$slug = corzo_get_option('general', 'personnel-category-slug', $slug);
			}
			
			return $slug;
		}
	}

	// single portfolio
	if( !function_exists('corzo_gdlr_core_portfolio_single_nav') ){
		function corzo_gdlr_core_portfolio_single_nav( $check ) {
			return corzo_get_option('general', 'enable-single-portfolio-navigation', $check);
		}
	}
	if( !function_exists('corzo_gdlr_core_portfolio_single_nav_same_term') ){
		function corzo_gdlr_core_portfolio_single_nav_same_term( $check ) {
			return corzo_get_option('general', 'enable-single-portfolio-navigation-in-same-tag', $check);
		}
	}
	if( !function_exists('corzo_gdlr_core_portfolio_single_nav_middle_link') ){
		function corzo_gdlr_core_portfolio_single_nav_middle_link( $check ) {
			return corzo_get_option('general', 'single-portfolio-navigation-middle-link', $check);
		}
	}
	if( !function_exists('corzo_gdlr_core_portfolio_single_related') ){
		function corzo_gdlr_core_portfolio_single_related( $args ) {

			$enble_related_portfolio = corzo_get_option('general', 'enable-related-portfolio', 'enable');
			if( $enble_related_portfolio == 'enable' ){
				$args['portfolio-style'] = corzo_get_option('general', 'related-portfolio-style', 'grid');
				$args['num-fetch'] = corzo_get_option('general', 'related-portfolio-num-fetch', 4);
				$args['column-size'] = corzo_get_option('general', 'related-portfolio-column-size', 15);
				$args['thumbnail-size'] = corzo_get_option('general', 'related-portfolio-thumbnail-size', 'medium');
				$args['excerpt-number'] = corzo_get_option('general', 'related-portfolio-num-excerpt', 20);
				$args['column-size'] = corzo_get_option('general', 'related-portfolio-column-size', 15);

				return $args;
			}else{
				return array();
			}
		}
	}

	// set default social share option
	if( !function_exists('corzo_gdlr_core_social_share_list') ){
		function corzo_gdlr_core_social_share_list( $social ) {

			$social['facebook'] = corzo_get_option('general', 'blog-social-facebook', $social['facebook']);
			$social['linkedin'] = corzo_get_option('general', 'blog-social-linkedin', $social['linkedin']);
			$social['pinterest'] = corzo_get_option('general', 'blog-social-pinterest', $social['pinterest']);
			$social['stumbleupon'] = corzo_get_option('general', 'blog-social-stumbleupon', $social['stumbleupon']);
			$social['twitter'] = corzo_get_option('general', 'blog-social-twitter', $social['twitter']);
			$social['email'] = corzo_get_option('general', 'blog-social-email', $social['email']);

			return $social;
		}
	}	

	// add filter to register custom fonts for font lists 
	add_filter('gdlr_core_custom_uploaded_font', 'corzo_register_custom_uploaded_font');
	if( !function_exists('corzo_register_custom_uploaded_font') ){
		function corzo_register_custom_uploaded_font( $custom_fonts ){

			$custom_font = corzo_get_option('typography', 'font-upload');
			if( !empty($custom_font) ){
				foreach($custom_font as $font_option){
					$font_option['name'] = str_replace('+', '', $font_option['name']);
					while( !empty($custom_fonts[$font_option['name']]) ){
						$font_option['name'] = $font_option['name'] . '+';
					}

					$custom_fonts[$font_option['name']] = array(
						'eot' => empty($font_option['eot'])? '': $font_option['eot'],
						'ttf' => empty($font_option['ttf'])? '': $font_option['ttf'],
						'woff' => empty($font_option['woff'])? '': $font_option['woff'],
						'font-weight' => empty($font_option['font-weight'])? 'normal': $font_option['font-weight'],
						'font-style' => empty($font_option['font-style'])? 'normal': $font_option['font-style']
					);
				}
			}		
			
			return $custom_fonts;
			
		} // corzo_register_custom_uploaded_font
	} // function_exists

	// format widget title
	if( !function_exists('corzo_gdlr_core_widget_title_nav') ){
		function corzo_gdlr_core_widget_title_nav( $title_nav ){
			return '</span><span class="gdlr-core-flexslider-nav gdlr-core-plain-style gdlr-core-size-widget">';
		}
	}
	
	// add page builder to post
	add_filter('gdlr_core_page_builder_post_type', 'corzo_gdlr_core_page_builder_post_type');
	if( !function_exists('corzo_gdlr_core_page_builder_post_type') ){
		function corzo_gdlr_core_page_builder_post_type( $post_types ){
			$post_types[] = 'post';
			return $post_types;
		}
	}

	// set lightbox type
	add_filter('gdlr_core_lightbox_type', 'corzo_gdlr_core_lightbox_type');
	if( !function_exists('corzo_gdlr_core_lightbox_type') ){
		function corzo_gdlr_core_lightbox_type(){
			$lightbox_type = corzo_get_option('plugin', 'lightbox', 'ilightbox');

			if( $lightbox_type == 'ilightbox' ){
				$ilightbox_skin = corzo_get_option('plugin', 'ilightbox-skin', 'dark');
				return $lightbox_type . '-' . $ilightbox_skin;
			}else{
				return $lightbox_type;
			}
		}
	}
	add_filter('body_class', 'corzo_lightbox_body_class');
	if( !function_exists('corzo_lightbox_body_class') ){
		function corzo_lightbox_body_class($class){
			$link_to_lightbox = corzo_get_option('plugin', 'link-to-lightbox', 'enable');
			if( $link_to_lightbox == 'enable' ){
				$class[] = 'gdlr-core-link-to-lightbox';
			}
			return $class;
		}
	}

	add_filter('gdlr_core_lightbox_video_autoplay', 'corzo_lightbox_video_autoplay');
	if( !function_exists('corzo_lightbox_video_autoplay') ){
		function corzo_lightbox_video_autoplay($autoplay){
			$video_autoplay = corzo_get_option('plugin', 'lightbox-video-autoplay', 'enable');
			return ($video_autoplay == 'enable')? true: false;
		}
	}
	
	
	// add page builder pre defined template
	if( is_admin() && class_exists('gdlr_core_page_builder_template') ){
		add_filter('gdlr_core_page_builder_page_template_list', 'corzo_gdlr_core_page_builder_page_template_list');
		add_filter('gdlr_core_page_builder_get_page_template', 'corzo_gdlr_core_page_builder_get_page_template', 10, 2);
	}

	if( !function_exists('corzo_gdlr_core_page_builder_page_template_list') ){
		function corzo_gdlr_core_page_builder_page_template_list( $templates ){
			$templates['homepage'] = array(
				'title' => esc_html__('Homepage', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['homepage2'] = array(
				'title' => esc_html__('Homepage2', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['homepage3'] = array(
				'title' => esc_html__('Homepage3', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['about-us'] = array(
				'title' => esc_html__('About Us', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['about-us2'] = array(
				'title' => esc_html__('About Us2', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['about-team'] = array(
				'title' => esc_html__('About Team', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['about-team2'] = array(
				'title' => esc_html__('About Team 2', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['asset-management'] = array(
				'title' => esc_html__('Asset Management', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['smart-manufacturing'] = array(
				'title' => esc_html__('Smart ManuFacturing', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['insurance'] = array(
				'title' => esc_html__('Insurance', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['contact'] = array(
				'title' => esc_html__('Contact', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['contact2'] = array(
				'title' => esc_html__('Contact2', 'corzo'),
				'type' => 'wrapper',
			);
			$templates['contact3'] = array(
				'title' => esc_html__('Contact3', 'corzo'),
				'type' => 'wrapper',
			);
			return $templates;
		} // corzo_gdlr_core_page_builder_page_template_list
	} // function_exists

	if( !function_exists('corzo_gdlr_core_page_builder_get_page_template') ){
		function corzo_gdlr_core_page_builder_get_page_template( $value, $type ){

			if( !empty($value) ) return $value; 

			switch( $type ){
				case 'homepage': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#0c0c0c","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"85px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"1","z-index":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"430px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12623","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"35px","bottom":"65px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"65px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Consult","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the b.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#adadad","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/asset-management/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"430px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12624","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"35px","bottom":"65px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"65px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Analyze The Opportunities","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the b.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#adadad","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/asset-management/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"430px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12625","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"80px","right":"35px","bottom":"65px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"65px","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Find Your New S Curve","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"26px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the b.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#adadad","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/asset-management/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13042","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.03","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"20px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Services We Provide","caption":"What we do","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-20px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"feature-content","value":{"id":"","class":"","tabs":[{"caption":"01","title":"Asset Management","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/asset-management/","background":"13045","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/img01.jpg"},{"caption":"02","title":"Smart Manufacturing","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/smart-manufacturing/","background":"12627","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/01/column-top2.jpg"},{"caption":"03","title":"Insurance","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/insurance/","background":"12628","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/01/column-top3.jpg"},{"caption":"04","title":"Private Equity","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/private-equity/","background":"12629","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/01/column-top4.jpg"},{"caption":"05","title":"Risk Management","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/risk-management/","background":"12630","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/01/column-top5.jpg"},{"caption":"06","title":"Merge & Acquisition","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/consult/merge-acquisition/","background":"12631","background-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/01/column-top6.jpg"}],"text-align":"left","column":"3","thumbnail-size":"Hp 1 Service Thumbnail","show-content-on-hover":"enable","carousel":"disable","with-space":"disable","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder gdlr-core-style-3","caption-size":"13px","caption-font-weight":"500","caption-letter-spacing":"0px","caption-text-transform":"none","title-size":"29px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","content-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","learn-more-size":"","learn-more-font-weight":"","learn-more-letter-spacing":"","learn-more-text-transform":"none","content-padding":{"top":"","right":"50px","bottom":"40px","left":"55px","settings":"unlink"},"frame-border-size":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"frame-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0","caption-color":"#a5a5a5","title-color":"","content-color":"","learn-more-color":"","background-color":"","background-opacity":"0.01","background-hover-opacity":"0.4","carousel-bullet-top-margin":"","padding-bottom":""}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-learning","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13154","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"margin":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInRight","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-learning","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"40px","right":"0px","bottom":"0px","left":"60px","settings":"unlink"},"margin":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Vision and Values","caption":"COMPLETE HONESTY AND TRANSPARENCY","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6d6a6a","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#d32525","icon-background-color":"","content-color":"#1b1b1b","caption-color":"","border-color":"","icon-size":"19px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"4px","icon-right-margin":"10px","list-bottom-margin":"8px","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/about-2/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"enable","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#1d1d1d","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#d8d8d8","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border2-radius":"","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"0px","item-top-margin":"0px","padding-bottom":"40px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13043","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"18px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInLeft","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12633","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"400px","bottom":"105px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Serving 50% Of  <br><span style=\"color: #D32525;\">Global 2000</span> Companies","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#b8b8b8","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/about-2/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"-310px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"100px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12634","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"fadeInDown","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12635","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"counter HP"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"01","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"14000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"All Time Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"02","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Clients in this year","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"03","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"New Projects","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"04","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"40","animation-time":"","suffix":"%","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Avg Profit Increased","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13044","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"135px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"What we do","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Cases","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/portfolio-3-columns-with-frame/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#202020","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#d8d8d8","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border2-radius":"","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"0px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"5px","right":"0px","bottom":"230px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"120px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"HP1 Blog"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","relation":"or","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"grid3","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-title","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"45px","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"22px","filter-font-weight":"500","filter-letter-spacing":"3px","filter-text-transform":"none","portfolio-title-font-size":"","portfolio-title-font-weight":"700","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"none","portfolio-tag-font-size":"","portfolio-tag-font-style":"normal","portfolio-tag-text-transform":"none","portfolio-hover-title-font-size":"20px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"0px","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"27px","right":"","bottom":"27px","left":"30px","settings":"unlink"},"portfolio-border-radius":"","portfolio-frame-border-size":"","portfolio-frame-border-color":"#ffffff","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"0px","overlay-color":"","overlay-opacity":"","frame-shadow-size":{"x":"0px","y":"20px","size":"30px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"19px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"25px","divider-width":"1px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"5px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12615","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Astrate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12616","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nitrox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12617","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Wirox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12618","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"DataTel","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12619","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Boxy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12620","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Corniz","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f3f3f3","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"fadeInUp","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12639","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/portrait05.jpg","rating":""},{"title":"Chloe Lopez","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12641","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/portrait03.jpg","rating":""},{"title":"Aubrey Thomas","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12640","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/portrait04.jpg","rating":""},{"title":"Mason Miller","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12638","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/portrait02.jpg","rating":""},{"title":"Violet Lee","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12637","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/portrait01.jpg","rating":""}],"style":"center","chat-frame-background":"","with-frame":"disable","column":"1","thumbnail-size":"thumbnail","enable-quote":"enable","quote-image":"","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-nav-style":"default","carousel-bullet-style":"round gdlr-core-color-bullet","quote-size":"180px","quote-font-weight":"400","quote-height":"","quote-top-margin":"40px","quote-bottom-margin":"0px","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"31px","mobile-content-size":"22px","content-line-height":"","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"0px","name-size":"14px","name-font-weight":"600","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"16px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-color":"","caption-color":"","quote-color":"#cfcfcf","content-color":"#424242","name-color":"#d32525","position-color":"#848484","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"55px","carousel-bullet-top-margin":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13049","background-image-top-offset":"40px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"115px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"75px","right":"","bottom":"90px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent News","caption":"Industry insights","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"-60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"HP1 Blog"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"tag":[],"relation":"or","num-fetch":"8","prepend-sticky":"enable","orderby":"title","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-4-left-button","blog-image-style":"style-1","blog-widget-style":"style-1","blog-widget-with-feature":"disable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"disable","blog-image-initial-opacity":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-top","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"right","carousel-navigation-left-icon":"ion-ios-arrow-thin-left","carousel-navigation-right-icon":"ion-ios-arrow-thin-right","carousel-navigation-icon-color":"#c6c6c6","carousel-navigation-icon-hover-color":"#d32525","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"50px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"disable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"22px","blog-title-font-weight":"500","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"#d32525","thumbnail-date-background-color":"","thumbnail-date-color":"#aeaeae","frame-shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","blog-border-radius":"","blog-frame-border-size":"","blog-frame-border-color":"","blog-frame-hover-border-color":"","blog-frame-padding":{"top":"","right":"30px","bottom":"40px","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"arrow_right","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"none","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#000000","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"140px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"180px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"70px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d5d5d5"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business better","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"28px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/consult/contact/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"33px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]}]';
				case 'homepage2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#161616","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"2","z-index":"","padding-bottom":"0"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"enable","container-background-color":"#ffffff","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"","right":"","bottom":"10px","left":"","settings":"unlink"},"container-margin":{"top":"-90px","right":"20px","bottom":"-300px","left":"20px","settings":"unlink"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"","container-z-index":"9","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"-332px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"10","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13127","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"20px","bottom":"60px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12760","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"46px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Tax Expert","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"14px","side-border-radius":"6px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"44px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Transforming distribution and marketing with key capabilities in customer insight and analytics.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"60px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13127","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"73px","right":"20px","bottom":"60px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"13037","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"46px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Financial Planner","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"14px","side-border-radius":"6px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"44px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Transforming distribution and marketing with key capabilities in customer insight and analytics.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"60px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13127","background-image-style":"no-repeat","background-image-position":"top-left","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"73px","right":"20px","bottom":"60px","left":"45px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"13038","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"46px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"25px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Real Sector Insight","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"14px","side-border-radius":"6px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"44px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Transforming distribution and marketing with key capabilities in customer insight and analytics.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#696969","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"60px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"#f5f5f5","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13128","background-image-top-offset":"350px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-00","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12777","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"105px","right":"40px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"-30px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12750","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-00","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"no-repeat","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"0px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Serving 50% Of  </br/>Global 2000 Companies","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"3px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#090909","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#090909","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"More About Us","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/finance/about/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#000000","icon-color":"#000000","text-hover-color":"#d32525","icon-hover-color":"#d32525","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"40px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"3px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"-20px","bottom":"0px","left":"-20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"feature-content","value":{"id":"","class":"","tabs":[{"caption":"01","title":"Asset Management","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/asset-management/","background":"13045","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/img01.jpg"},{"caption":"02","title":"Smart Manufacturing","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/smart-manufacturing/","background":"12627","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/01/column-top2.jpg"},{"caption":"03","title":"Insurance","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/insurance/","background":"12628","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/01/column-top3.jpg"},{"caption":"04","title":"Private Equity","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/private-equity/","background":"12629","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/01/column-top4.jpg"},{"caption":"05","title":"Risk Management","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/risk-management/","background":"12630","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/01/column-top5.jpg"},{"caption":"06","title":"Merge & Acquisition","content":"Become faster, more flexible, and intensely customer-focused.","learn-more-text":"Learn More","learn-more-link":"https://demo.goodlayers.com/corzo/finance/merge-acquisition/","background":"12631","background-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/01/column-top6.jpg"}],"text-align":"left","column":"4","thumbnail-size":"Shop Featured","show-content-on-hover":"enable","carousel":"enable","with-space":"disable","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder gdlr-core-style-3","caption-size":"13px","caption-font-weight":"500","caption-letter-spacing":"0px","caption-text-transform":"none","title-size":"29px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","content-size":"18px","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","learn-more-size":"","learn-more-font-weight":"","learn-more-letter-spacing":"","learn-more-text-transform":"none","content-padding":{"top":"","right":"50px","bottom":"40px","left":"45px","settings":"unlink"},"frame-border-size":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"frame-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0","caption-color":"#a5a5a5","title-color":"","content-color":"","learn-more-color":"","background-color":"","background-opacity":"0.01","background-hover-opacity":"0.4","carousel-bullet-top-margin":"","padding-bottom":""}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13130","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"120px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Let Us Help Analyse Your Business","caption":"We are Professional ","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"3px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"41px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"21px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"10px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Meet The Team","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/finance/about-team/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"0px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"personnel","value":{"id":"","class":"","category":[],"personnels":[],"num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","personnel-style":"grid-with-background","text-align":"center","always-show-overlay-content":"enable","enable-position":"enable","widget-enable-position":"disable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"disable","initial-thumbnail-opacity":"","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","hover-content":"center","enable-hover-title":"enable","enable-hover-social":"round-border","social-hover-color":"","enable-hover-excerpt":"enable","carousel":"enable","carousel-start-at":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder","carousel-bullet-top-margin":"60px","personnel-title-font-size":"26px","personnel-title-font-weight":"500","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"17px","personnel-position-font-weight":"500","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"shadow-color":"#000000","shadow-opacity":"0.06","personnel-border-radius":"","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12770","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.1","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"150px","right":"0px","bottom":"140px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"NO white Column"},"items":[{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"01","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"14000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"500","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"5px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"All Time Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"3px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"02","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"500","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Clients in this year","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"03","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"500","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"New Projects","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"04","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"40","animation-time":"","suffix":"%","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"500","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Avg Profit Increased","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"5px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business better","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/finance/contact/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"75px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"-30px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"70px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13190","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"195px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"40","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Case Studies","caption":"What we do","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"35px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All Cases","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/finance/portfolio-3-columns/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"right","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"0px","right":"0px","bottom":"3px","left":"0px","settings":"unlink"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#202020","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"#d8d8d8","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border2-radius":"","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"0px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"215px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","relation":"or","num-fetch":"6","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"grid3","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"disable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"margin-title","column-size":"20","thumbnail-size":"Personnel Square","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"45px","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"22px","filter-font-weight":"500","filter-letter-spacing":"3px","filter-text-transform":"none","portfolio-title-font-size":"","portfolio-title-font-weight":"700","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"none","portfolio-tag-font-size":"","portfolio-tag-font-style":"normal","portfolio-tag-text-transform":"none","portfolio-hover-title-font-size":"20px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"0px","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"27px","right":"","bottom":"27px","left":"30px","settings":"unlink"},"portfolio-border-radius":"","portfolio-frame-border-size":"","portfolio-frame-border-color":"#ffffff","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"0px","overlay-color":"","overlay-opacity":"","frame-shadow-size":{"x":"0px","y":"20px","size":"30px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12615","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Astrate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12616","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nitrox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12617","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Wirox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12618","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"DataTel","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12619","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Boxy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12620","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Corniz","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12771","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"135px","right":"70px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Choose Us?","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"24px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#a2a2a2","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#d32525","icon-background-color":"","content-color":"#ffffff","caption-color":"","border-color":"","icon-size":"19px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"7px","icon-right-margin":"10px","list-bottom-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12772","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"220px","right":"0px","bottom":"360px","left":"","settings":"unlink"},"margin":{"top":"-70px","right":"0px","bottom":"0px","left":"-30px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12775","background-image-top-offset":"95px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"0.8","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12639","image-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/portrait05.jpg","rating":""},{"title":"Chloe Lopez","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12641","image-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/portrait03.jpg","rating":""},{"title":"Aubrey Thomas","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12640","image-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/portrait04.jpg","rating":""},{"title":"Mason Miller","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12638","image-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/portrait02.jpg","rating":""},{"title":"Violet Lee","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12637","image-img":"https://demo.goodlayers.com/corzo/finance/wp-content/uploads/sites/3/2021/02/portrait01.jpg","rating":""}],"style":"center","chat-frame-background":"","with-frame":"disable","column":"1","thumbnail-size":"thumbnail","enable-quote":"enable","quote-image":"","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-nav-style":"default","carousel-bullet-style":"round gdlr-core-color-bullet","quote-size":"180px","quote-font-weight":"400","quote-height":"","quote-top-margin":"40px","quote-bottom-margin":"","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"31px","mobile-content-size":"","content-line-height":"","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"0px","name-size":"14px","name-font-weight":"600","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"16px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-border-color":"","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":"","frame-shadow-color":"","frame-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-color":"","caption-color":"","quote-color":"#cfcfcf","content-color":"#424242","name-color":"#d32525","position-color":"#848484","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"25px","carousel-bullet-top-margin":"35px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13191","background-image-top-offset":"70px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent News","caption":"Industry insights","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"-90px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"-60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"HP1 Blog"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"relation":"or","num-fetch":"8","prepend-sticky":"enable","orderby":"title","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-4-left-button","blog-image-style":"style-1","blog-widget-style":"style-1","blog-widget-with-feature":"disable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"disable","blog-image-initial-opacity":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-top","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"right","carousel-navigation-left-icon":"ion-ios-arrow-thin-left","carousel-navigation-right-icon":"ion-ios-arrow-thin-right","carousel-navigation-icon-color":"#c6c6c6","carousel-navigation-icon-hover-color":"#d32525","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"50px","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"disable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"22px","blog-title-font-weight":"500","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"#d32525","thumbnail-date-background-color":"","thumbnail-date-color":"#aeaeae","frame-shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","blog-border-radius":"","blog-frame-border-size":"","blog-frame-border-color":"","blog-frame-hover-border-color":"","blog-frame-padding":{"top":"","right":"30px","bottom":"40px","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"arrow_right","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"none","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#000000","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All News","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/finance/blog-full-right-sidebar-with-frame/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]}]';
				case 'homepage3': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#161616","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"revolution-slider","value":{"id":"","class":"","revolution-slider-id":"3","z-index":"","padding-bottom":"0px"}},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"60px","hide-this-item-in":"none","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13199","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"45px","right":"","bottom":"75px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"01","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Easy To Generate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a leader in endpoint protection solutions by industry analysts, independent testing organi- zations and security professionals.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"160px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"02","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Easy To Deploy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a leader in endpoint protection solutions by industry analysts, independent testing organi- zations and security professionals.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"160px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"03","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"div","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Easy To Operate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"2px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>We are a leader in endpoint protection solutions by industry analysts, independent testing organi- zations and security professionals.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"160px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"9","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12803","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"top","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"60px","hide-this-item-in":"none","z-index":""}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"50px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Solution For Business Challenges","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#ffffff","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"61px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"15px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#ffffff","caption-prefix-color":"#ffffff","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/endpoint-security/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"20px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12796","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Endpoint Security","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/endpoint-security/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/security-it-operations/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"20px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12797","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Security & It Operations","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/security-it-operations/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/cloud-security/","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"0px","right":"20px","bottom":"20px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12798","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Cloud Security","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/cloud-security/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/threat-intelligence/","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"20px","right":"20px","bottom":"-80px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"20px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12799","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Threat Intelligence","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/threat-intelligence/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/risk-reduction/","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-hover-shadow-color":"","frame-hover-shadow-opacity":"","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"20px","right":"20px","bottom":"-80px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"20px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12800","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Risk Reduction","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/risk-reduction/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"/corzo/cybersecurity/waf-networking/","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"Height-icon-circle","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12792","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":{"x":"","y":"30px","size":"35px","settings":"unlink"},"background-shadow-color":"#000000","background-shadow-opacity":"0.07","enable-move-up-shadow-effect":"enable","move-up-effect-length":"15px","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"15px","bottom":"50px","left":"15px","settings":"unlink"},"margin":{"top":"20px","right":"20px","bottom":"-80px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"0px","right":"","bottom":"0px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12801","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"62px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Waf & Networking","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"28px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"1px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Detect and deny attacker lateral movement across all attack vectors.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/waf-networking/","button-link-target":"_self","icon-position":"right","icon":"fa fa-long-arrow-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"0px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"20px","text-font-weight":"500","text-letter-spacing":"","text-transform":"none","icon-size":"22px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#f2f2f2","width":"","height":"60px","hide-this-item-in":"none","z-index":"-6"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12804","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"155px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Get Easy and Fast Protection Against All ","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"47px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"1000px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Reduce attacker time with early detection and derailment of in-network threats. Built to cover all attack surfaces and methods of threats, Corzo hides critical data, misdirects attackers away from assets.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"/corzo/cybersecurity/contact/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"1px","right":"31px","bottom":"1px","left":"31px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"Request Demo","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"/corzo/cybersecurity/contact/","button2-link-target":"_self","button2-icon-position":"right","button2-icon":"ion-ios-arrow-thin-right","button2-padding":{"top":"0px","right":"25px","bottom":"0px","left":"25px","settings":"unlink"},"border2-radius":"31px","button2-background":"transparent","button2-border":"enable","border2-width":{"top":"2px","right":"2px","bottom":"2px","left":"2px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"#d32525","icon2-color":"#d32525","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"#d32525","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"60px","hide-this-item-in":"none","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13200","background-image-top-offset":"30px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"20px","bottom":"45px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"10px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"13201","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12780","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Customers Choose Us","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"59px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#090909","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"accordion","value":{"id":"","class":"","tabs":[{"head-text":"","title":"Premium services and beyond your expectation","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss.</p>"},{"head-text":"","title":"World class cyber security tech","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss.</p>"},{"head-text":"","title":"Low maintenance required","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss.</p>"},{"head-text":"","title":"Quick alert with auto action","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss.</p>"}],"active":"1","allow-closing-all-tabs":"disable","style":"icon","with-divider":"enable","align":"left","icon-position":"left","padding-bottom":"30px","title-font-size":"26px","title-font-weight":"600","title-letter-spacing":"0px","title-text-transform":"none","title-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"}}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13203","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"40px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"From Case Studies","caption":"How we helped customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"61px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#090909","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"full","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Hp3 Portfolio"},"items":[{"template":"element","type":"portfolio","value":{"id":"","class":"","category":[],"tag":[],"relation":"or","num-fetch":"7","orderby":"date","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","view-all-works-button":"disable","view-all-works-text":"View All Works","view-all-works-link":"","portfolio-style":"modern2","portfolio-modern2-with-space":"enable","portfolio-grid-text-align":"left","portfolio-grid-style":"normal","portfolio-frame-opacity":"1","enable-portfolio-title":"enable","enable-portfolio-tag":"enable","enable-portfolio-date":"disable","portfolio-medium-size":"small","portfolio-medium-style":"left","hover":"title-icon","column-size":"15","thumbnail-size":"Portfolio Thumbnail Portrait","enable-thumbnail-zoom-on-hover":"enable","enable-thumbnail-grayscale-effect":"disable","enable-badge":"enable","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-start-at":"","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder gdlr-core-style-3","carousel-bullet-top-margin":"","excerpt":"specify-number","excerpt-number":"55","read-more-button":"disable","filter-font-size":"","filter-font-weight":"","filter-letter-spacing":"","filter-text-transform":"uppercase","portfolio-title-font-size":"","portfolio-title-font-weight":"","portfolio-title-letter-spacing":"","portfolio-title-text-transform":"uppercase","portfolio-tag-font-size":"12px","portfolio-tag-font-style":"normal","portfolio-tag-text-transform":"uppercase","portfolio-hover-title-font-size":"30px","portfolio-hover-title-font-weight":"600","portfolio-hover-title-letter-spacing":"0px","portfolio-hover-title-text-transform":"none","filterer-top-margin":"","filterer-bottom-margin":"","portfolio-frame-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"portfolio-border-radius":"","portfolio-frame-border-size":"","portfolio-frame-border-color":"","portfolio-frame-hover-border-color":"","portfolio-item-bottom-margin":"","portfolio-title-bottom-margin":"","pagination-top-margin":"","padding-bottom":"30px","overlay-color":"#0a0a0a","overlay-opacity":"0.1","frame-shadow-size":{"x":"","y":"","size":"","settings":"unlink"},"frame-shadow-color":"","frame-shadow-opacity":"","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"125px","right":"0px","bottom":"105px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12615","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Astrate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12616","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nitrox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12617","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Wirox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12618","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"DataTel","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12619","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Boxy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12620","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Corniz","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12813","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"180px","right":"0px","bottom":"200px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"130px","right":"","bottom":"110px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"NUMBER HP3"},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"top","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"65px","hide-this-item-in":"none","z-index":""}},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"01","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"14000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"57px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"12px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"All Time Clients","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"02","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"57px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"12px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"Clients in this year","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"03","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"10","animation-time":"","suffix":"BN+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"57px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"12px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"Attacks Blocked","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"04","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"30","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"57px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"12px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"","caption":"Security Modules","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"bottom","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#f5f5f5","width":"","height":"65px","hide-this-item-in":"none","z-index":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13211","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"enable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"-130px","left":"0px","settings":"unlink"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"50px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"","right":"","bottom":"65px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"What They Say About US","caption":"Testimonial","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"10px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"61px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"400","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#090909","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"3","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"testimonial","value":{"id":"","class":"","title":"","title-left-icon":"","caption":"","tabs":[{"title":"John Smith","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12639","image-img":"https://demo.goodlayers.com/corzo/cybersecurity/wp-content/uploads/sites/4/2021/02/portrait05.jpg","rating":""},{"title":"Chloe Lopez","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12641","image-img":"https://demo.goodlayers.com/corzo/cybersecurity/wp-content/uploads/sites/4/2021/02/portrait03.jpg","rating":""},{"title":"Aubrey Thomas","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12640","image-img":"https://demo.goodlayers.com/corzo/cybersecurity/wp-content/uploads/sites/4/2021/02/portrait04.jpg","rating":""},{"title":"Mason Miller","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12638","image-img":"https://demo.goodlayers.com/corzo/cybersecurity/wp-content/uploads/sites/4/2021/02/portrait02.jpg","rating":""},{"title":"Violet Lee","position":"CEO, Apple","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics.</p>","image":"12637","image-img":"https://demo.goodlayers.com/corzo/cybersecurity/wp-content/uploads/sites/4/2021/02/portrait01.jpg","rating":""}],"style":"left","chat-frame-background":"","with-frame":"enable","column":"2","thumbnail-size":"thumbnail","enable-quote":"disable","quote-image":"","left-quote-position":"left","quote-position":"top","rating-position":"left","rating-top-margin":"","carousel":"enable","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-hover-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-nav-style":"default","carousel-bullet-style":"cylinder","quote-size":"","quote-font-weight":"","quote-height":"","quote-top-margin":"","quote-bottom-margin":"","title-size":"28px","title-text-transform":"uppercase","title-font-weight":"","title-letter-spacing":"","content-size":"20px","mobile-content-size":"","content-line-height":"","content-font-style":"normal","content-font-weight":"400","content-letter-spacing":"0px","name-size":"18px","name-font-weight":"600","name-letter-spacing":"1px","name-text-transform":"uppercase","caption-size":"15px","position-font-style":"normal","position-font-weight":"500","rating-font-size":"","frame-border-size":{"top":"","right":"3px","bottom":"","left":"","settings":"unlink"},"frame-border-color":"#d32525","frame-hover-border-color":"","frame-border-radius":"","frame-shadow-size":{"x":"0px","y":"20px","size":"40px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.07","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"frame-hover-shadow-size":{"x":"","y":"20px","size":"40px","settings":"unlink"},"frame-hover-shadow-color":"#000000","frame-hover-shadow-opacity":"0.07","title-color":"","caption-color":"","quote-color":"#cfcfcf","content-color":"#424242","name-color":"#d32525","position-color":"#848484","star-rating-color":"","thumbnail-width":"","caption-spaces":"","title-wrap-bottom-margin":"","content-bottom-padding":"10px","carousel-bullet-top-margin":"60px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"0","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13207","background-image-top-offset":"240px","background-image-bottom-offset":"","mobile-background-image":"13282","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"255px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"220px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Empower Your Network","caption":"Even more secured","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"11px","icon-font-size":"30px","title-font-size":"61px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"700","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#090909","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"15px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#090909","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#dfdfdf","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"","y":"10px","size":"30px","settings":"unlink"},"frame-hover-shadow-color":"#0a0a0a","frame-hover-shadow-opacity":"0.09","padding":{"top":"22px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"12px","right":"0px","bottom":"12px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"13132","character":"","title":"World class cyber security tech","caption":"","caption-position":"bottom","content":"<p>Reduce attacker time with early detection and derailment of in-network threats. Built to cover all attack surfaces.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"26px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":"10px"},"media-image-max-width":"45px","character-width":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30"},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"#ffffff","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"t-left":"0px","t-right":"0px","b-right":"0px","b-left":"0px","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"outer-border","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#dfdfdf","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"enable","move-up-effect-length":"10px","frame-hover-shadow-size":{"x":"","y":"10px","size":"30px","settings":"unlink"},"frame-hover-shadow-color":"#0a0a0a","frame-hover-shadow-opacity":"0.09","padding":{"top":"22px","right":"0px","bottom":"15px","left":"0px","settings":"unlink"},"margin":{"top":"12px","right":"0px","bottom":"12px","left":"20px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"column-service","value":{"id":"","class":"","media-type":"image","icon":"fa fa-gear","icon-style":"normal","image":"13131","character":"","title":"Quick alert with auto action","caption":"","caption-position":"bottom","content":"<p>Reduce attacker time with early detection and derailment of in-network threats. Built to cover all attack surfaces.</p>","read-more-text":"","read-more-link":"#","read-more-link-target":"_self","enable-read-more-icon":"disable","read-more-icon":"","style":"left_icon-left","heading-tag":"h3","icon-size":"30px","title-size":"26px","tablet-title-size":"","mobile-title-size":"","title-font-weight":"600","title-letter-spacing":"","title-text-transform":"none","caption-size":"18px","tablet-caption-size":"","mobile-caption-size":"","caption-font-weight":"400","caption-font-style":"default","caption-text-transform":"","content-size":"18px","tablet-content-size":"","mobile-content-size":"","content-font-weight":"400","content-text-transform":"none","read-more-size":"14px","read-more-font-weight":"","read-more-font-style":"default","read-more-icon-font-size":"","icon-color":"","icon-background":"","background-color":"","media-margin":{"top":"10px","right":"","bottom":"","left":"10px"},"media-image-max-width":"43px","character-width":"","title-top-padding":"","title-bottom-margin":"5px","caption-top-margin":"","read-more-top-margin":"","padding":{"top":"","right":"","bottom":"0px","left":""},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"}}}]},{"template":"wrapper","type":"column","column":"30"}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13208","background-image-top-offset":"50px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Recent News","caption":"Industry insights","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"12px","side-border-spaces":"15px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"60px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"-110px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"-60px","right":"","bottom":"","left":"","settings":"unlink"},"skin":"HP1 Blog"},"items":[{"template":"element","type":"blog","value":{"id":"","class":"","category":["blog"],"relation":"or","num-fetch":"8","prepend-sticky":"enable","orderby":"title","order":"desc","filterer":"none","filterer-align":"center","pagination":"none","pagination-style":"default","pagination-align":"default","offset":"0","blog-style":"blog-column-with-frame","blog-full-style":"style-1","blog-side-thumbnail-style":"style-1","blog-column-style":"style-4-left-button","blog-image-style":"style-1","blog-widget-style":"style-1","blog-widget-with-feature":"disable","blog-full-alignment":"left","blog-image-alignment":"center","blog-list-with-frame":"disable","always-show-overlay-content":"disable","blog-image-thumbnail-overlay":"none","blog-image-thumbnail-overlay-opacity":"0.4","blog-image-thumbnail-overlay-color":"#000000","show-thumbnail":"enable","thumbnail-size":"Personnel Square","enable-thumbnail-opacity-on-hover":"disable","blog-image-initial-opacity":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","column-size":"20","layout":"carousel","carousel-item-margin":"","carousel-overflow":"","carousel-scrolling-item-amount":"1","carousel-autoslide":"enable","carousel-navigation":"navigation-top","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"right","carousel-navigation-left-icon":"ion-ios-arrow-thin-left","carousel-navigation-right-icon":"ion-ios-arrow-thin-right","carousel-navigation-icon-color":"#c6c6c6","carousel-navigation-icon-hover-color":"#d32525","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"0px","right":"10px","bottom":"0px","left":"10px","settings":"unlink"},"carousel-navigation-icon-radius":"","carousel-navigation-size":"50px","carousel-navigation-margin":"50px","carousel-navigation-icon-margin":"","carousel-bullet-style":"round gdlr-core-color-bullet","carousel-bullet-top-margin":"","blog-widget-column":"60","blog-widget-bottom-divider":"disable","item-size":"small","excerpt":"specify-number","excerpt-number":"0","blog-image-excerpt-number":"0","blog-date-feature":"enable","meta-option":["date","author","category"],"show-read-more":"disable","read-more-button-text":"","filterer-bottom-margin":"","blog-title-font-size":"27px","blog-title-font-weight":"700","blog-title-letter-spacing":"0px","blog-title-text-transform":"none","category-background-color":"#d32525","thumbnail-date-background-color":"","thumbnail-date-color":"#aeaeae","frame-shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"frame-shadow-color":"#000000","frame-shadow-opacity":"0.06","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","blog-border-radius":"","blog-frame-border-size":"","blog-frame-border-color":"","blog-frame-hover-border-color":"","blog-frame-padding":{"top":"","right":"30px","bottom":"40px","left":"","settings":"unlink"},"blog-image-overlay-content-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"arrow_right","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"22px","title-font-weight":"500","title-letter-spacing":"","title-line-height":"","title-font-style":"normal","title-text-transform":"none","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"none","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"#000000","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"button","value":{"id":"","class":"","button-text":"View All News","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/cybersecurity/blog-full-right-sidebar-with-frame/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"33px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13137","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"110px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"NUMBER HP3"},"items":[{"template":"element","type":"shape-divider","value":{"id":"","class":"","position":"top","shape":"tilt","custom-shape":"","custom-image":"","inverted":"disable","flip":"enable","vflip":"disable","opacity":"","color":"#ffffff","width":"","height":"65px","hide-this-item-in":"none","z-index":""}},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business more secured","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"28px","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"https://demo.goodlayers.com/corzo/cybersecurity/contact/","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"33px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]}]';
				case 'about-us': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13092","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"115px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-big","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"25px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Serving 50% Of  <br/>Global 2000 Companies","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#090909","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#090909","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"20px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12644","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"35px","left":"0px","settings":"unlink"},"margin":{"top":"","right":"0px","bottom":"-90px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"100px","divider-width":"1px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12646","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Asset Planning","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"13px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12647","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Investment Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"13px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12648","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Diversification","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"13px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13094","background-image-top-offset":"10px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-img","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"left","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12652","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"150px","right":"0px","bottom":"150px","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-img","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"60px","left":"75px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Vision and Values","caption":"COMPLETE HONESTY AND TRANSPARENCY","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"divider","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"12649","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo01.png","icon":"","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"12650","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo02.png","icon":"","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"12651","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo03.png","icon":"","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"","icon-background-color":"","content-color":"#1b1b1b","caption-color":"","border-color":"","icon-size":"14px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"35px","icon-top-margin":"-2px","icon-right-margin":"","list-bottom-margin":"17px","padding-bottom":"20px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"30px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13093","background-image-top-offset":"25px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Expertise","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Financial","icon":"","percent":"100","bar-text":""},{"heading-text":"Investment","icon":"","percent":"90","bar-text":""},{"heading-text":"M&A","icon":"","percent":"80","bar-text":""},{"heading-text":"Developement","icon":"","percent":"80","bar-text":""}],"heading-text-color":"#181818","icon-color":"","percent-color":"#8e8e8e","bar-filled-color":"#d32525","bar-background-color":"#dcdcdc","space-between-item":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"550px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12653","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"85px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"4px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"22px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"23px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"0px","right":"","bottom":"90px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"01","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"14000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"All Time Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"02","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Clients in this year","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"03","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"New Projects","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"04","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"40","animation-time":"","suffix":"%","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"600","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Avg Profit Increased","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]}]';
				case 'about-us2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13104","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"87px","right":"0px","bottom":"180px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"60px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-img","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"70px","left":"","settings":"unlink"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"13100","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12659","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"294px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"40px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"We Provide Great Solutions","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"12px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"12px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"35px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"12649","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo01.png","icon":"","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"12650","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo02.png","icon":"","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"12651","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo03.png","icon":"","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"","icon-background-color":"","content-color":"#1b1b1b","caption-color":"","border-color":"","icon-size":"14px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"35px","icon-top-margin":"-2px","icon-right-margin":"","list-bottom-margin":"17px","padding-bottom":"10px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"0px","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#090909","icon-color":"#d32525","text-hover-color":"#d32525","icon-hover-color":"","background-color":"","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"18px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"30px","right":"0px","bottom":"0px","left":"60px","settings":"unlink"},"margin":{"top":"","right":"","bottom":"0px","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12667","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12659","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"60px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"right","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"60px","divider-width":"1px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12646","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Asset Planning","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12647","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Investment Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12648","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Diversification","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"4px","side-border-spaces":"12px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"20px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12668","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"95px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"85px","right":"","bottom":"80px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"70px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Choose Us?","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"12px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"12px","icon-font-size":"30px","title-font-size":"45px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"28px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"24px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#a2a2a2","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#d32525","icon-background-color":"","content-color":"#ffffff","caption-color":"","border-color":"","icon-size":"19px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"4px","icon-right-margin":"10px","list-bottom-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12669","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"220px","right":"0px","bottom":"300px","left":"","settings":"unlink"},"margin":{"top":"-185px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"180px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"65px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d5d5d5"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business better","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"2px","right":"33px","bottom":"2px","left":"33px","settings":"unlink"},"border-radius":"31px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12615","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Astrate","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12616","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Nitrox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12617","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Wirox","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12618","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"DataTel","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12619","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Boxy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"10","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12620","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12613","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"150px","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"15px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Corniz","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"4px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#aaaaaa","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"5px","divider-width":"5px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]}]';
				case 'about-team': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13159","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"90px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"70px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"24","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"A Team Of Professional","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"middle-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"3px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"13px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}}]},{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"650px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"70px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#252525","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"personnel","value":{"id":"","class":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","personnel-style":"grid-with-background","text-align":"center","always-show-overlay-content":"enable","enable-position":"enable","widget-enable-position":"disable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"disable","initial-thumbnail-opacity":"","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","hover-content":"center","enable-hover-title":"enable","enable-hover-social":"round-border","social-hover-color":"","enable-hover-excerpt":"enable","carousel":"disable","carousel-start-at":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"disable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder","carousel-bullet-top-margin":"","personnel-title-font-size":"26px","personnel-title-font-weight":"500","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"17px","personnel-position-font-weight":"500","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"shadow-color":"#000000","shadow-opacity":"0.06","personnel-border-radius":"","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13093","background-image-top-offset":"25px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"100px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"20px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Expertise","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"42px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"skill-bar","value":{"id":"","class":"","bar-size":"small","bar-type":"round","tabs":[{"heading-text":"Financial","icon":"","percent":"100","bar-text":""},{"heading-text":"Investment","icon":"","percent":"90","bar-text":""},{"heading-text":"M&A","icon":"","percent":"80","bar-text":""},{"heading-text":"Developement","icon":"","percent":"80","bar-text":""}],"heading-text-color":"#181818","icon-color":"","percent-color":"#8e8e8e","bar-filled-color":"#d32525","bar-background-color":"#dcdcdc","space-between-item":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"550px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12653","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"85px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"0px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"4px","divider-width":"4px","divider-border-radius":"3px","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"22px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"23px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"130px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"30px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"180px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"70px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d5d5d5"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business better","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#000000","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"1px","right":"33px","bottom":"1px","left":"33px","settings":"unlink"},"border-radius":"25px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]}]';
				case 'about-team2': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13161","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"900px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"69px","divider-width":"1px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"30px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"A Team Of Professional","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"4px","side-border-size":"13px","side-border-spaces":"13px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"13px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#1b1b1b","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry.</p>","text-align":"center","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#252525","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"60","items":[{"template":"element","type":"personnel","value":{"id":"","class":"","num-fetch":"6","filterer":"disable","filterer-color":"","orderby":"date","order":"desc","personnel-style":"grid-with-background","text-align":"center","always-show-overlay-content":"enable","enable-position":"enable","widget-enable-position":"disable","disable-link":"disable","enable-divider":"disable","enable-excerpt":"enable","enable-social-shortcode":"enable","column-size":"3","thumbnail-size":"full","enable-thumbnail-opacity-on-hover":"disable","initial-thumbnail-opacity":"","thumbnail-opacity":"","thumbnail-opacity-background":"","enable-thumbnail-zoom-on-hover":"disable","enable-thumbnail-grayscale-effect":"disable","hover-content":"center","enable-hover-title":"disable","enable-hover-social":"round-border","social-hover-color":"","enable-hover-excerpt":"disable","carousel":"disable","carousel-start-at":"","carousel-item-margin":"","carousel-overflow":"","carousel-autoslide":"enable","carousel-scrolling-item-amount":"1","carousel-navigation":"bullet","carousel-navigation-show-on-hover":"disable","carousel-navigation-align":"center","carousel-navigation-left-icon":"","carousel-navigation-right-icon":"","carousel-navigation-size":"","carousel-navigation-icon-color":"","carousel-navigation-icon-bg":"","carousel-navigation-icon-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"carousel-navigation-icon-radius":"","carousel-navigation-margin":"","carousel-navigation-icon-margin":"","carousel-bullet-style":"cylinder","carousel-bullet-top-margin":"","personnel-title-font-size":"26px","personnel-title-font-weight":"500","personnel-title-letter-spacing":"0px","personnel-title-text-transform":"none","personnel-position-font-size":"17px","personnel-position-font-weight":"500","personnel-position-font-style":"normal","personnel-position-letter-spacing":"0px","personnel-position-text-transform":"none","border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"shadow-size":{"x":"","y":"20px","size":"30px","settings":"unlink"},"shadow-color":"#000000","shadow-opacity":"0.06","personnel-border-radius":"","personnel-thumbnail-bottom-margin":"","personnel-modern-content-bottom":"","personnel-title-bottom-margin":"","list-margin-bottom":"","padding-bottom":"0px","title-align":"left","title-left-media":"icon","title-left-icon":"","title-left-image":"","title":"","caption":"","caption-position":"top","read-more-style":"default","read-more-text":"Read More","read-more-link":"","read-more-target":"_self","title-size":"41px","title-font-weight":"","title-letter-spacing":"","title-line-height":"","title-font-style":"","title-text-transform":"uppercase","caption-size":"16px","caption-font-weight":"","caption-letter-spacing":"","caption-font-style":"","caption-text-transform":"","caption-spaces":"","read-more-size":"14px","read-more-font-weight":"","title-left-icon-color":"","title-color":"","caption-color":"","read-more-color":"","read-more-divider":"style-1","read-more-divider-color":"","title-wrap-bottom-margin":"","title-carousel-nav-style":"default"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12635","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"120px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"counter HP"},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"01","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"14000","animation-time":"","suffix":"+","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"All Time Clients","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"02","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"1000","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Clients in this year","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"03","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"200","animation-time":"","suffix":"","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"New Projects","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"15","items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"04","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"13px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"13px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"0px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#a5a5a5","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#a5a5a5","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"padding-bottom":"45px"}},{"template":"element","type":"counter","value":{"id":"","class":"","top-text-type":"none","top-icon":"fa fa-cloud","top-text":"01","style":"bottom-caption","align":"left","prefix":"","start-number":"0","end-number":"40","animation-time":"","suffix":"%","divider":"disable","bottom-text":"","side-text":"Counter caption","top-icon-size":"30px","top-text-size":"16px","number-size":"48px","number-font-weight":"700","bottom-text-size":"14px","bottom-text-font-weight":"500","bottom-text-transform":"uppercase","title-bottom-margin":"0px","divider-bottom-margin":"","divider-width":"","divider-height":"","divider-radius":"","padding-bottom":"0px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Avg Profit Increased","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"14px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"2px","title-line-height":"","title-font-uppercase":"enable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"0px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"110px","divider-border-radius":"0px","margin-top":"","margin-left":"0px","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13168","background-image-top-offset":"10px","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"95px","right":"0px","bottom":"80px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"80px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12646","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Asset Planning","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"50px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12647","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Investment Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12648","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"23px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Diversification","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]}]';
				case 'asset-management': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13155","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"30px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Service Skin"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"48px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"custom-menu","value":{"id":"","class":"","menu":"39","style":"style-2","font-size":"19px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"45px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Download PDF","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"fa fa-file-pdf-o","z-index":"","text-align":"left","full-width-button":"enable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"1px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"#f5f5f5","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"18px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"10px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"50px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"How To Manage Insurance","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"23px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"120px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#e8e8e8"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#525252","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"image","value":{"id":"","class":"","image":"12740","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"372px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13157","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"15px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"50px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12741","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"","right":"10px","bottom":"","left":"","settings":"unlink"},"padding-bottom":"50px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"right","divider-type":"vertical","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"90px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"height-img","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"70px","right":"0px","bottom":"0px","left":"50px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"110px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"We Provide Great Solutions","caption":"Our Expertise","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"12649","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo01.png","icon":"","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"12650","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo02.png","icon":"","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"12651","image-img":"https://demo.goodlayers.com/corzo/consult/wp-content/uploads/sites/2/2021/02/logo03.png","icon":"","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"","icon-background-color":"","content-color":"#1b1b1b","caption-color":"","border-color":"","icon-size":"14px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"35px","icon-top-margin":"-2px","icon-right-margin":"","list-bottom-margin":"17px","padding-bottom":"5px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Learn More","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"left","full-width-button":"disable","button-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"border-radius":"","button-background":"transparent","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#090909","icon-color":"#d32535","text-hover-color":"#d32535","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"17px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"20px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"85px","right":"40px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"10px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Serving 50% Of  </br/>Global 2000 Companies","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. More than 25 years of experience working in the industry has enabled us to build our services and solutions in strategy, consulting, digital.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#090909","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"38px"}}]},{"template":"wrapper","type":"column","column":"30","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"right","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12751","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"75px","right":"0px","bottom":"70px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12750","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"","alignment":"center","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13108","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"750px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"165px","right":"0px","bottom":"155px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"125px","right":"","bottom":"115px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"1px","divider-width":"180px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"70px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d5d5d5"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Let’s discuss about how we can help make your business better","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"center","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","icon-font-size":"30px","title-font-size":"37px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"600","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"40px"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Get Consult","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"right","icon":"ion-ios-arrow-thin-right","z-index":"","text-align":"center","full-width-button":"disable","button-padding":{"top":"3px","right":"33px","bottom":"3px","left":"33px","settings":"unlink"},"border-radius":"28px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#ffffff","icon-color":"#ffffff","text-hover-color":"","icon-hover-color":"","background-color":"#d32525","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"16px","text-font-weight":"700","text-letter-spacing":"0px","text-transform":"none","icon-size":"31px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"0px"}}]}]}]';
				case 'smart-manufacturing': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"13155","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"no-repeat","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"135px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"70px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Service Skin"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"48px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"custom-menu","value":{"id":"","class":"","menu":"39","style":"style-2","font-size":"19px","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"50px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Download PDF","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"fa fa-file-pdf-o","z-index":"","text-align":"left","full-width-button":"enable","button-padding":{"top":"15px","right":"35px","bottom":"15px","left":"35px","settings":"unlink"},"border-radius":"1px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"#f5f5f5","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"18px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"10px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"40px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12730","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"372px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"65px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"We Help Managing Your Portfolio","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"14px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"23px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"120px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#e8e8e8"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#525252","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#525252","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12736","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"110px","right":"0px","bottom":"130px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"90px","right":"","bottom":"100px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"36","value":{"id":"","class":"","privacy":"","max-width":"700px","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"70px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Why Choose Us?","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#ffffff","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"24px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#a2a2a2","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"icon-list","value":{"id":"","class":"","tabs":[{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Premium services and beyond your expectation","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Get the best support among all venders","caption":"","link-url":"","link-target":"_self"},{"image":"","image-img":"","icon":"icon-check","icon-hover":"","title":"Great Price Competitive","caption":"","link-url":"","link-target":"_self"}],"columns":"60","style":"style-1","align":"left","enable-divider":"disable","icon-background":"none","icon-position":"left","icon-color":"#d32525","icon-background-color":"","content-color":"#ffffff","caption-color":"","border-color":"","icon-size":"19px","content-size":"19px","content-font-weight":"500","content-text-transform":"none","content-letter-spacing":"0px","caption-size":"14px","caption-font-weight":"","caption-text-transform":"","caption-letter-spacing":"","image-max-width":"","icon-top-margin":"4px","icon-right-margin":"10px","list-bottom-margin":"10px","padding-bottom":"0px"}}]},{"template":"wrapper","type":"column","column":"24","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"mobile","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"image","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12735","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"220px","right":"0px","bottom":"300px","left":"","settings":"unlink"},"margin":{"top":"-190px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""}}]},{"template":"wrapper","type":"column","column":"60","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"9","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"margin":{"top":"-45px","right":"0px","bottom":"-65px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"100px","divider-width":"1px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f7f7f7","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0.8","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"100px","right":"0px","bottom":"90px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12646","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"28px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Asset Planning","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"40px","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12647","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"28px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Investment Strategy","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]},{"template":"wrapper","type":"column","column":"20","items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12648","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12642","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"73px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"28px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Diversification","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"dot","left-icon":"fa fa-gear","left-image":"","left-divider-size":"5px","left-divider-margin":"11px","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"","side-border-size":"","side-border-spaces":"12px","side-border-radius":"","side-border-style":"dashed","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"25px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"#d32525","title-color":"#222222","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"25px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmar.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#6c6c6c","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"15px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"center","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"0px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}}]}]}]';
				case 'insurance': 
					return '[{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"image","background-color-style":"plain","background-color":"","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"12835","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"repeat-y","background-image-position":"top-center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-opacity":"","background-filter":"none","background-blur-size":"","pattern-opacity":"1","parallax-speed":"0","overflow":"","enable-container-background":"disable","container-background-color":"","container-background-gradient":"none","container-background-gradient-min-opacity":"","container-background-gradient-color":"","container-background-image":"","container-background-image-opacity":"","container-padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"container-tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"container-border-radius":"","container-shadow-size":"","container-shadow-color":"","container-shadow-opacity":"0.2","container-z-index":"","wrapper-background-gradient":"none","wrapper-background-gradient-color":"#000","wrapper-background-top-gradient-size":"413px","wrapper-background-bottom-gradient-size":"413px","enable-background-image-overlay":"disable","background-image-overlay":"","background-image-overlay-section":"left","background-image-overlay-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"enable-background-particle":"disable","enable-marquee":"disable","marquee-text":"","marquee-position":"top","marquee-position-offset":"","marquee-speed":"10000","marquee-direction":"left","marquee-font-size":"","marquee-font-weight":"","marquee-font-letter-spacing":"","marquee-text-color":"","marquee-opacity":"1","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","padding":{"top":"80px","right":"0px","bottom":"60px","left":"0px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"60px","right":"","bottom":"","left":"","settings":"unlink"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"wrapper","type":"column","column":"15","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":"Service Skin"},"items":[{"template":"element","type":"title","value":{"id":"","class":"","title":"Our Services","caption":"","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"image","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"upper-left","side-border-width":"30px","side-border-size":"1px","side-border-spaces":"30px","side-border-radius":"","side-border-style":"solid","side-border-divider-color":"","heading-tag":"h3","caption-prefix":"","caption-dot-size":"","caption-dot-margin":"","icon-font-size":"30px","title-font-size":"48px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"300","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"16px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"400","caption-font-style":"italic","caption-font-letter-spacing":"0px","caption-font-uppercase":"disable","title-link-text-size":"","left-icon-color":"","title-color":"#d32525","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"","caption-prefix-color":"","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"10px","right":"30px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"30px"}},{"template":"element","type":"custom-menu","value":{"id":"","class":"","menu":"39","style":"style-2","font-size":"19px","padding-bottom":"10px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"2px","divider-width":"80px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"50px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#d32525"}},{"template":"element","type":"button","value":{"id":"","class":"","button-text":"Download PDF","link-to":"custom-url","custom-image":"","video-url":"","button-link":"#","button-link-target":"_self","icon-position":"left","icon":"fa fa-file-pdf-o","z-index":"","text-align":"left","full-width-button":"enable","button-padding":{"top":"16px","right":"35px","bottom":"16px","left":"35px","settings":"unlink"},"border-radius":"1px","button-background":"gradient","button-border":"disable","border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border-on-text-size":"","border-on-text-top-margin":"","text-color":"#d32525","icon-color":"#d32525","text-hover-color":"","icon-hover-color":"","background-color":"#f5f5f5","background-hover-color":"","background-gradient-color":"","border-color":"","border-hover-color":"","border-on-text-color":"","button-shadow-size":"","button-shadow-color":"","button-shadow-opacity":"0.2","button2-text":"","button2-link-to":"custom-url","button2-custom-image":"","button2-video-url":"","button2-button-link":"","button2-link-target":"_self","button2-icon-position":"none","button2-icon":"fa fa-gear","button2-padding":{"top":"15px","right":"33px","bottom":"15px","left":"33px","settings":"unlink"},"border2-radius":"25px","button2-background":"gradient","button2-border":"disable","border2-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"border2-on-text-size":"","border2-on-text-top-margin":"","text2-color":"","icon2-color":"","text2-hover-color":"","icon2-hover-color":"","background2-color":"","background2-hover-color":"","background2-gradient-color":"","border2-color":"","border2-hover-color":"","border2-on-text-color":"","button2-shadow-size":"","button2-shadow-color":"","button2-shadow-opacity":"0.2","text-size":"18px","text-font-weight":"500","text-letter-spacing":"0px","text-transform":"none","icon-size":"16px","3d-content-z-pos":"","button2-left-margin":"10px","item-top-margin":"0px","padding-bottom":"30px"}}]},{"template":"wrapper","type":"column","column":"45","value":{"id":"","class":"","privacy":"","max-width":"","min-height":"","enable-left-right-spaces":"disable","hide-this-wrapper-in":"none","tablet-size":"","animation":"none","animation-location":"0.8","effect":"","3d-rotate-degree":"","3d-content-z-pos":"","column-link":"","column-link-target":"_self","z-index":"","full-height":"disable","decrease-height":"0px","sync-height":"","centering-sync-height-content":"disable","background-type":"color","background-color-style":"plain","background-extending":"none","background-color":"","background-normal-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-style":"cover","background-image-position":"center","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"pattern-1","background-color-opacity":"1","background-opacity":"1","background-filter":"none","background-blur-size":"","border-radius":{"top":"","right":"","bottom":"","left":"","settings":"link"},"parallax-speed":"0.8","overflow":"","border-type":"none","border-pre-spaces":{"top":"20px","right":"20px","bottom":"20px","left":"20px","settings":"link"},"border-width":{"top":"1px","right":"1px","bottom":"1px","left":"1px","settings":"link"},"divider-height":"","hover-border-width":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-color":"#ffffff","hover-border-color":"#ffffff","border-style":"solid","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","enable-move-up-shadow-effect":"disable","move-up-effect-length":"","frame-hover-shadow-size":"","frame-hover-shadow-color":"","frame-hover-shadow-opacity":"0.2","padding":{"top":"0px","right":"0px","bottom":"0px","left":"20px","settings":"unlink"},"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"tablet-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"tablet-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-padding":{"top":"","right":"","bottom":"","left":"","settings":"link"},"mobile-margin":{"top":"","right":"","bottom":"","left":"","settings":"link"},"skin":""},"items":[{"template":"element","type":"image","value":{"id":"","class":"","image":"12703","thumbnail-size":"full","z-index":"","link-to":"none","custom-image":"","video-url":"","page-id":"12699","custom-url":"","custom-link-target":"_self","overlay-icon-type":"no-overlay","overlay-icon-style":"on-hover","overlay-icon":"fa fa-android","overlay-image":"","enable-caption":"disable","max-width":"372px","alignment":"left","zoom-on-hover":"disable","enable-shadow":"disable","background-shadow-size":"","background-shadow-color":"","background-shadow-opacity":"0.2","frame-style":"rectangle","border-radius":"3px","border-radius-2":{"top":"","right":"","bottom":"","left":"","settings":"link"},"border-width":"0px","overlay-icon-size":"22","overlay-icon-size-custom":"22px","border-color":"","overlay-color":"","overlay-icon-color":"","overlay-icon-background":"","overlay-background-opacity":"0.6","3d-content-z-pos":"","left-right-padding":"enable","margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"link"},"padding-bottom":"63px"}},{"template":"element","type":"title","value":{"id":"","class":"","title":"Apply Technologies To Your Factory","caption":"Big Name Customers","caption-position":"top","title-width":"300px","title-link-text":"","title-link":"","title-link-target":"_self","text-align":"left","left-media-type":"none","left-icon":"fa fa-gear","left-image":"","left-divider-size":"","left-divider-margin":"","title-left-icon":"none","enable-side-border":"disable","side-border-alignment":"lower-left","side-border-width":"5px","side-border-size":"5px","side-border-spaces":"15px","side-border-radius":"4px","side-border-style":"solid","side-border-divider-color":"#d32525","heading-tag":"h3","caption-prefix":"dot","caption-dot-size":"5px","caption-dot-margin":"15px","icon-font-size":"30px","title-font-size":"44px","tablet-title-font-size":"","mobile-title-font-size":"","title-font-weight":"500","title-font-style":"normal","title-font-letter-spacing":"0px","title-line-height":"","title-font-uppercase":"disable","caption-font-size":"14px","tablet-caption-font-size":"","mobile-caption-font-size":"","caption-font-weight":"500","caption-font-style":"normal","caption-font-letter-spacing":"3px","caption-font-uppercase":"enable","title-link-text-size":"","left-icon-color":"","title-color":"#353535","title-link-hover-color":"","title-text-shadow-size":"","title-text-shadow-color":"","caption-color":"#d32525","caption-prefix-color":"#d32525","3d-content-z-pos":"","item-left-margin":"","caption-spaces":"10px","caption-right-top-padding":"","media-margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px","settings":"unlink"},"padding-bottom":"20px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"23px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#353535","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"40px"}},{"template":"element","type":"divider","value":{"id":"","class":"","type":"normal","icon-type":"icon","image":"","icon":"fa fa-film","style":"solid","align":"left","divider-type":"horizontal","vertical-divider-icon":"","vertical-divider-text":"","icon-size":"15px","divider-size":"3px","divider-width":"120px","divider-border-radius":"","margin-top":"","margin-left":"","margin-right":"","padding-bottom":"40px","vdi-font-size":"","vd-font-size":"","vd-font-weight":"","vd-font-letter-spacing":"","vd-text-transform":"uppercase","icon-color":"","divider-color":"#e8e8e8"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"disable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#525252","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"35px"}},{"template":"element","type":"text-box","value":{"id":"","class":"","content":"<p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p>","text-align":"left","apply-the-content-filter":"disable","enable-p-space":"enable","font-size":"18px","content-line-height":"","content-font-weight":"400","content-letter-spacing":"0px","content-text-transform":"none","tablet-font-size":"","mobile-font-size":"","text-color":"#525252","3d-content-z-pos":"","margin-left":"","margin-right":"","padding-bottom":"0px"}}]}]},{"template":"wrapper","type":"background","value":{"id":"","class":"","privacy":"","content-layout":"boxed","max-width-wrapper":"","max-width":"","enable-space":"disable","hide-this-wrapper-in":"none","animation":"none","animation-location":"0.8","z-index":"","float-social-id":"","full-height":"disable","decrease-height":"0px","centering-content":"disable","background-type":"color","background-color-style":"plain","background-color":"#f3f3f3","background-color-opacity":"1","background-gradient-color":"","background-gradient-color-opacity":"1","background-image":"","background-image-top-offset":"","background-image-bottom-offset":"","mobile-background-image":"","background-image-style":"cover","background-image-position":"center","background-image-position-custom":"","background-video-url":"","background-video-url-mp4":"","background-video-url-webm":"","background-video-url-ogg":"","background-video-image":"","background-pattern":"patt