<?php

	add_filter('gdlr_core_enable_header_post_type', 'corzo_gdlr_core_enable_header_post_type');
	if( !function_exists('corzo_gdlr_core_enable_header_post_type') ){
		function corzo_gdlr_core_enable_header_post_type( $args ){
			return true;
		}
	}
	
	add_filter('gdlr_core_header_options', 'corzo_gdlr_core_header_options', 10, 2);
	if( !function_exists('corzo_gdlr_core_header_options') ){
		function corzo_gdlr_core_header_options( $options, $with_default = true ){

			// get option
			$options = array(
				'top-bar' => corzo_top_bar_options(),
				'top-bar-social' => corzo_top_bar_social_options(),			
				'header' => corzo_header_options(),
				'logo' => corzo_logo_options(),
				'navigation' => corzo_navigation_options(), 
				'fixed-navigation' => corzo_fixed_navigation_options(),
			);

			// set default
			if( $with_default ){
				foreach( $options as $slug => $option ){
					foreach( $option['options'] as $key => $value ){
						$options[$slug]['options'][$key]['default'] = corzo_get_option('general', $key);
					}
				}
			} 
			
			return $options;
		}
	}
	
	add_filter('gdlr_core_header_color_options', 'corzo_gdlr_core_header_color_options', 10, 2);
	if( !function_exists('corzo_gdlr_core_header_color_options') ){
		function corzo_gdlr_core_header_color_options( $options, $with_default = true ){

			$options = array(
				'header-color' => corzo_header_color_options(), 
				'navigation-menu-color' => corzo_navigation_color_options(), 		
				'navigation-right-color' => corzo_navigation_right_color_options(),
			);

			// set default
			if( $with_default ){
				foreach( $options as $slug => $option ){
					foreach( $option['options'] as $key => $value ){
						$options[$slug]['options'][$key]['default'] = corzo_get_option('color', $key);
					}
				}
			}

			return $options;
		}
	}

	add_action('wp_head', 'corzo_set_custom_header');
	if( !function_exists('corzo_set_custom_header') ){
		function corzo_set_custom_header(){
			corzo_get_option('general', 'layout', '');
			
			$header_id = get_post_meta(get_the_ID(), 'gdlr_core_custom_header_id', true);
			if( empty($header_id) ){
				$header_id = corzo_get_option('general', 'custom-header', '');
			}

			if( !empty($header_id) ){
				$option = 'corzo_general';
				$header_options = get_post_meta($header_id, 'gdlr-core-header-settings', true);

				if( !empty($header_options) ){
					foreach( $header_options as $key => $value ){
						$GLOBALS[$option][$key] = $value;
					}
				}

				$header_css = get_post_meta($header_id, 'gdlr-core-custom-header-css', true);
				if( !empty($header_css) ){
					if( get_post_type() == 'page' ){
						$header_css = str_replace('.gdlr-core-page-id', '.page-id-' . get_the_ID(), $header_css);
					}else{
						$header_css = str_replace('.gdlr-core-page-id', '.postid-' . get_the_ID(), $header_css);
					}
					echo '<style type="text/css" >' . $header_css . '</style>';
				}
				

			}
		} // corzo_set_custom_header
	}

	// override menu on page option
	add_filter('wp_nav_menu_args', 'corzo_wp_nav_menu_args');
	if( !function_exists('corzo_wp_nav_menu_args') ){
		function corzo_wp_nav_menu_args($args){

			$corzo_locations = array('main_menu', 'right_menu', 'top_bar_menu', 'mobile_menu');
			if( !empty($args['theme_location']) && in_array($args['theme_location'], $corzo_locations) ){
				$menu_id = get_post_meta(get_the_ID(), 'gdlr-core-location-' . $args['theme_location'], true);
				
				if( !empty($menu_id) ){
					$args['menu'] = $menu_id;
					$args['theme_location'] = '';
				}
			}

			return $args;
		}
	}

	if( !function_exists('corzo_top_bar_options') ){
		function corzo_top_bar_options(){
			return array(
				'title' => esc_html__('Top Bar', 'corzo'),
				'options' => array(

					'enable-top-bar' => array(
						'title' => esc_html__('Enable Top Bar', 'corzo'),
						'type' => 'checkbox',
					),
					'enable-top-bar-on-mobile' => array(
						'title' => esc_html__('Enable Top Bar On Mobile', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable'
					),
					'top-bar-width' => array(
						'title' => esc_html__('Top Bar Width', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'boxed' => esc_html__('Boxed ( Within Container )', 'corzo'),
							'full' => esc_html__('Full', 'corzo'),
							'custom' => esc_html__('Custom', 'corzo'),
						),
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-width-pixel' => array(
						'title' => esc_html__('Top Bar Width Pixel', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'default' => '1140px',
						'condition' => array( 'enable-top-bar' => 'enable', 'top-bar-width' => 'custom' ),
						'selector' => '.corzo-top-bar-container.corzo-top-bar-custom-container{ max-width: #gdlr#; }'
					),
					'top-bar-full-side-padding' => array(
						'title' => esc_html__('Top Bar Full ( Left/Right ) Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '100',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-top-bar-container.corzo-top-bar-full{ padding-right: #gdlr#; padding-left: #gdlr#; }',
						'condition' => array( 'enable-top-bar' => 'enable', 'top-bar-width' => 'full' )
					),
					'top-bar-menu-position' => array(
						'title' => esc_html__('Top Bar Menu Position', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'none' => esc_html__('None', 'corzo'),
							'left' => esc_html__('Left', 'corzo'),
							'right' => esc_html__('Right', 'corzo'),
						),
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-left-text' => array(
						'title' => esc_html__('Top Bar Left Text', 'corzo'),
						'type' => 'textarea',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-right-text' => array(
						'title' => esc_html__('Top Bar Right Text', 'corzo'),
						'type' => 'textarea',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-top-padding' => array(
						'title' => esc_html__('Top Bar Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
 						'default' => '10px',
						'selector' => '.corzo-top-bar{ padding-top: #gdlr#; }',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-bottom-padding' => array(
						'title' => esc_html__('Top Bar Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '10px',
						'selector' => '.corzo-top-bar{ padding-bottom: #gdlr#; }' .
							'.corzo-top-bar .corzo-top-bar-menu > li > a{ padding-bottom: #gdlr#; }' .  
							'.sf-menu.corzo-top-bar-menu > .corzo-mega-menu .sf-mega, .sf-menu.corzo-top-bar-menu > .corzo-normal-menu ul{ margin-top: #gdlr#; }',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-text-size' => array(
						'title' => esc_html__('Top Bar Text Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-top-bar{ font-size: #gdlr#; }',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-bottom-border' => array(
						'title' => esc_html__('Top Bar Bottom Border', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '10',
						'default' => '0',
						'selector' => '.corzo-top-bar{ border-bottom-width: #gdlr#; }',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-shadow-size' => array(
						'title' => esc_html__('Top Bar Shadow Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
						'condition' => array( 'enable-top-bar' => 'enable' )
					),
					'top-bar-shadow-color' => array(
						'title' => esc_html__('Top Bar Shadow Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000',
						'selector-extra' => true,
						'selector' => '.corzo-top-bar{ ' . 
							'box-shadow: 0px 0px <top-bar-shadow-size>t rgba(#gdlra#, 0.1); ' . 
							'-webkit-box-shadow: 0px 0px <top-bar-shadow-size>t rgba(#gdlra#, 0.1); ' . 
							'-moz-box-shadow: 0px 0px <top-bar-shadow-size>t rgba(#gdlra#, 0.1); }',
						'condition' => array( 'enable-top-bar' => 'enable' )
					)

				)
			);
		}
	}

	if( !function_exists('corzo_top_bar_social_options') ){
		function corzo_top_bar_social_options(){
			return array(
				'title' => esc_html__('Top Bar Social', 'corzo'),
				'options' => array(
					'enable-top-bar-social' => array(
						'title' => esc_html__('Enable Top Bar Social', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'top-bar-social-position' => array(
						'title' => esc_html__('Top Bar Social Position', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'left' => esc_html__('Left', 'corzo'),
							'right' => esc_html__('Right', 'corzo'),
							'menu-right' => esc_html__('Right Menu (Bar Style)', 'corzo'),
						),
						'default' => 'right',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-delicious' => array(
						'title' => esc_html__('Top Bar Social Delicious Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-email' => array(
						'title' => esc_html__('Top Bar Social Email Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-deviantart' => array(
						'title' => esc_html__('Top Bar Social Deviantart Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-digg' => array(
						'title' => esc_html__('Top Bar Social Digg Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-facebook' => array(
						'title' => esc_html__('Top Bar Social Facebook Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-flickr' => array(
						'title' => esc_html__('Top Bar Social Flickr Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-google-plus' => array(
						'title' => esc_html__('Top Bar Social Google Plus Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-lastfm' => array(
						'title' => esc_html__('Top Bar Social Lastfm Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-linkedin' => array(
						'title' => esc_html__('Top Bar Social Linkedin Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-pinterest' => array(
						'title' => esc_html__('Top Bar Social Pinterest Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-rss' => array(
						'title' => esc_html__('Top Bar Social RSS Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-skype' => array(
						'title' => esc_html__('Top Bar Social Skype Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-stumbleupon' => array(
						'title' => esc_html__('Top Bar Social Stumbleupon Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-tumblr' => array(
						'title' => esc_html__('Top Bar Social Tumblr Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-twitter' => array(
						'title' => esc_html__('Top Bar Social Twitter Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-vimeo' => array(
						'title' => esc_html__('Top Bar Social Vimeo Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-youtube' => array(
						'title' => esc_html__('Top Bar Social Youtube Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-instagram' => array(
						'title' => esc_html__('Top Bar Social Instagram Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),
					'top-bar-social-snapchat' => array(
						'title' => esc_html__('Top Bar Social Snapchat Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-top-bar-social' => 'enable' )
					),

				)
			);
		}
	}

	if( !function_exists('corzo_header_options') ){
		function corzo_header_options(){
			return array(
				'title' => esc_html__('Header', 'corzo'),
				'options' => array(

					'header-style' => array(
						'title' => esc_html__('Header Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'plain' => esc_html__('Plain', 'corzo'),
							'bar' => esc_html__('Bar', 'corzo'),
							'bar2' => esc_html__('Navigation Boxed', 'corzo'),
							'boxed' => esc_html__('Boxed', 'corzo'),
							'side' => esc_html__('Side Menu', 'corzo'),
							'side-toggle' => esc_html__('Side Menu Toggle', 'corzo'),
						),
						'default' => 'plain',
					),
					'header-plain-style' => array(
						'title' => esc_html__('Header Plain Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'menu-left' => get_template_directory_uri() . '/images/header/plain-menu-left.jpg',
							'menu-right' => get_template_directory_uri() . '/images/header/plain-menu-right.jpg',
							'center-logo' => get_template_directory_uri() . '/images/header/plain-center-logo.jpg',
							'center-menu' => get_template_directory_uri() . '/images/header/plain-center-menu.jpg',
							'splitted-menu' => get_template_directory_uri() . '/images/header/plain-splitted-menu.jpg',
						),
						'default' => 'menu-right',
						'condition' => array( 'header-style' => 'plain' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'header-plain-bottom-border' => array(
						'title' => esc_html__('Plain Header Bottom Border', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '10',
						'default' => '0',
						'selector' => '.corzo-header-style-plain{ border-bottom-width: #gdlr#; }',
						'condition' => array( 'header-style' => array('plain') )
					),
					'header-bar-navigation-align' => array(
						'title' => esc_html__('Header Bar Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'left' => get_template_directory_uri() . '/images/header/bar-left.jpg',
							'center' => get_template_directory_uri() . '/images/header/bar-center.jpg',
							'center-logo' => get_template_directory_uri() . '/images/header/bar-center-logo.jpg',
						),
						'default' => 'center',
						'condition' => array( 'header-style' => 'bar' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'header-bar2-navigation-align' => array(
						'title' => esc_html__('Header Bar 2 Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'left' => get_template_directory_uri() . '/images/header/bar2-left.jpg',
							'center' => get_template_directory_uri() . '/images/header/bar2-center.jpg',
							'center-logo' => get_template_directory_uri() . '/images/header/bar2-center-logo.jpg',
						),
						'default' => 'center',
						'condition' => array( 'header-style' => 'bar2' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'header-background-style' => array(
						'title' => esc_html__('Header/Navigation Background Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'solid' => esc_html__('Solid', 'corzo'),
							'transparent' => esc_html__('Transparent', 'corzo'),
						),
						'default' => 'solid',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2') )
					),
					'top-bar-background-opacity' => array(
						'title' => esc_html__('Top Bar Background Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '50',
						'condition' => array( 'header-style' => 'plain', 'header-background-style' => 'transparent' ),
						'selector' => '.corzo-header-background-transparent .corzo-top-bar-background{ opacity: #gdlr#; }'
					),
					'header-background-opacity' => array(
						'title' => esc_html__('Header Background Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '50',
						'condition' => array( 'header-style' => array('plain', 'bar2'), 'header-background-style' => 'transparent' ),
						'selector' => '.corzo-header-background-transparent .corzo-header-background{ opacity: #gdlr#; }'
					),
					'navigation-background-opacity' => array(
						'title' => esc_html__('Navigation Background Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '50',
						'condition' => array( 'header-style' => array('bar', 'bar2'), 'header-background-style' => 'transparent' ),
						'selector' => '.corzo-navigation-bar-wrap.corzo-style-transparent .corzo-navigation-background{ opacity: #gdlr#; }'
					),
					'header-boxed-style' => array(
						'title' => esc_html__('Header Boxed Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'menu-right' => get_template_directory_uri() . '/images/header/boxed-menu-right.jpg',
							'center-menu' => get_template_directory_uri() . '/images/header/boxed-center-menu.jpg',
							'splitted-menu' => get_template_directory_uri() . '/images/header/boxed-splitted-menu.jpg',
						),
						'default' => 'menu-right',
						'condition' => array( 'header-style' => 'boxed' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'boxed-top-bar-background-opacity' => array(
						'title' => esc_html__('Top Bar Background Opacity', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'opacity',
						'default' => '0',
						'condition' => array( 'header-style' => 'boxed' ),
						'selector' => '.corzo-header-boxed-wrap .corzo-top-bar-background{ opacity: #gdlr#; }'
					),
					'boxed-top-bar-background-extend' => array(
						'title' => esc_html__('Top Bar Background Extend ( Bottom )', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0px',
						'data-max' => '200px',
						'default' => '0px',
						'condition' => array( 'header-style' => 'boxed' ),
						'selector' => '.corzo-header-boxed-wrap .corzo-top-bar-background{ margin-bottom: -#gdlr#; }'
					),
					'boxed-header-top-margin' => array(
						'title' => esc_html__('Header Top Margin', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0px',
						'data-max' => '200px',
						'default' => '0px',
						'condition' => array( 'header-style' => 'boxed' ),
						'selector' => '.corzo-header-style-boxed{ margin-top: #gdlr#; }'
					),
					'header-side-style' => array(
						'title' => esc_html__('Header Side Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'top-left' => get_template_directory_uri() . '/images/header/side-top-left.jpg',
							'middle-left' => get_template_directory_uri() . '/images/header/side-middle-left.jpg',
							'middle-left-2' => get_template_directory_uri() . '/images/header/side-middle-left-2.jpg',
							'top-right' => get_template_directory_uri() . '/images/header/side-top-right.jpg',
							'middle-right' => get_template_directory_uri() . '/images/header/side-middle-right.jpg',
							'middle-right-2' => get_template_directory_uri() . '/images/header/side-middle-right-2.jpg',
						),
						'default' => 'top-left',
						'condition' => array( 'header-style' => 'side' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'header-side-align' => array(
						'title' => esc_html__('Header Side Text Align', 'corzo'),
						'type' => 'radioimage',
						'options' => 'text-align',
						'default' => 'left',
						'condition' => array( 'header-style' => 'side' )
					),
					'header-side-toggle-style' => array(
						'title' => esc_html__('Header Side Toggle Style', 'corzo'),
						'type' => 'radioimage',
						'options' => array(
							'left' => get_template_directory_uri() . '/images/header/side-toggle-left.jpg',
							'right' => get_template_directory_uri() . '/images/header/side-toggle-right.jpg',
						),
						'default' => 'left',
						'condition' => array( 'header-style' => 'side-toggle' ),
						'wrapper-class' => 'gdlr-core-fullsize'
					),
					'header-side-toggle-menu-type' => array(
						'title' => esc_html__('Header Side Toggle Menu Type', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'left' => esc_html__('Left Slide Menu', 'corzo'),
							'right' => esc_html__('Right Slide Menu', 'corzo'),
							'overlay' => esc_html__('Overlay Menu', 'corzo'),
						),
						'default' => 'overlay',
						'condition' => array( 'header-style' => 'side-toggle' )
					),
					'header-side-toggle-display-logo' => array(
						'title' => esc_html__('Display Logo', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'condition' => array( 'header-style' => 'side-toggle' )
					),
					'header-width' => array(
						'title' => esc_html__('Header Width', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'boxed' => esc_html__('Boxed ( Within Container )', 'corzo'),
							'full' => esc_html__('Full', 'corzo'),
							'custom' => esc_html__('Custom', 'corzo'),
						),
						'condition' => array('header-style'=> array('plain', 'bar', 'bar2', 'boxed'))
					),
					'header-width-pixel' => array(
						'title' => esc_html__('Header Width Pixel', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'default' => '1140px',
						'condition' => array('header-style'=> array('plain', 'bar', 'bar2', 'boxed'), 'header-width' => 'custom'),
						'selector' => '.corzo-header-container.corzo-header-custom-container{ max-width: #gdlr#; }'
					),
					'header-full-side-padding' => array(
						'title' => esc_html__('Header Full ( Left/Right ) Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '100',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-header-container.corzo-header-full{ padding-right: #gdlr#; padding-left: #gdlr#; }',
						'condition' => array('header-style'=> array('plain', 'bar', 'bar2', 'boxed'), 'header-width'=>'full')
					),
					'boxed-header-frame-radius' => array(
						'title' => esc_html__('Header Frame Radius', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '3px',
						'condition' => array( 'header-style' => 'boxed' ),
						'selector' => '.corzo-header-boxed-wrap .corzo-header-background{ border-radius: #gdlr#; -moz-border-radius: #gdlr#; -webkit-border-radius: #gdlr#; }'
					),
					'boxed-header-content-padding' => array(
						'title' => esc_html__('Header Content ( Left/Right ) Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '100',
						'data-type' => 'pixel',
						'default' => '30px',
						'selector' => '.corzo-header-style-boxed .corzo-header-container-item{ padding-left: #gdlr#; padding-right: #gdlr#; }' . 
							'.corzo-navigation-right{ right: #gdlr#; } .corzo-navigation-left{ left: #gdlr#; }',
						'condition' => array( 'header-style' => 'boxed' )
					),
					'navigation-text-top-margin' => array(
						'title' => esc_html__('Navigation Text Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '0px',
						'condition' => array( 'header-style' => 'plain', 'header-plain-style' => 'splitted-menu' ),
						'selector' => '.corzo-header-style-plain.corzo-style-splitted-menu .corzo-navigation .sf-menu > li > a{ padding-top: #gdlr#; } ' .
							'.corzo-header-style-plain.corzo-style-splitted-menu .corzo-main-menu-left-wrap,' .
							'.corzo-header-style-plain.corzo-style-splitted-menu .corzo-main-menu-right-wrap{ padding-top: #gdlr#; }'
					),
					'navigation-text-top-margin-boxed' => array(
						'title' => esc_html__('Navigation Text Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '0px',
						'condition' => array( 'header-style' => 'boxed', 'header-boxed-style' => 'splitted-menu' ),
						'selector' => '.corzo-header-style-boxed.corzo-style-splitted-menu .corzo-navigation .sf-menu > li > a{ padding-top: #gdlr#; } ' .
							'.corzo-header-style-boxed.corzo-style-splitted-menu .corzo-main-menu-left-wrap,' .
							'.corzo-header-style-boxed.corzo-style-splitted-menu .corzo-main-menu-right-wrap{ padding-top: #gdlr#; }'
					),
					'navigation-text-side-spacing' => array(
						'title' => esc_html__('Navigation Text Side ( Left / Right ) Spaces', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '30',
						'data-type' => 'pixel',
						'default' => '13px',
						'selector' => '.corzo-navigation .sf-menu > li{ padding-left: #gdlr#; padding-right: #gdlr#; }',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2', 'boxed') )
					),
					'navigation-left-offset' => array(
						'title' => esc_html__('Navigation Left Offset Spaces', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '0',
						'selector' => '.corzo-navigation .corzo-main-menu{ margin-left: #gdlr#; }'
					),
					'navigation-slide-bar' => array(
						'title' => esc_html__('Navigation Slide Bar', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'disable' => esc_html__('Disable', 'corzo'),
							'enable' => esc_html__('Bar With Triangle Style', 'corzo'),
							'style-2' => esc_html__('Bar Style', 'corzo'),
							'style-2-left' => esc_html__('Bar Style Left', 'corzo'),
							'style-dot' => esc_html__('Dot Style', 'corzo'),
							'style-dot-center' => esc_html__('Dot Center Style', 'corzo')
						),
						'default' => 'enable',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2', 'boxed') )
					),
					'navigation-slide-bar-width' => array(
						'title' => esc_html__('Navigation Slide Bar Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2', 'boxed'), 'navigation-slide-bar' => array('style-2', 'style-2-left') )
					),
					'navigation-slide-bar-height' => array(
						'title' => esc_html__('Navigation Slide Bar Height', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-navigation .corzo-navigation-slide-bar-style-2{ border-bottom-width: #gdlr#; }',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2', 'boxed'), 'navigation-slide-bar' => array('style-2', 'style-2-left') )
					),
					'navigation-slide-bar-top-margin' => array(
						'title' => esc_html__('Navigation Slide Bar Top Margin', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '',
						'selector' => '.corzo-navigation .corzo-navigation-slide-bar{ margin-top: #gdlr#; }',
						'condition' => array( 'header-style' => array('plain', 'bar', 'bar2', 'boxed'), 'navigation-slide-bar' => array('enable', 'style-2', 'style-2-left', 'style-dot', 'style-dot-center') )
					),
					'side-header-width-pixel' => array(
						'title' => esc_html__('Header Width Pixel', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '600',
						'default' => '340px',
						'condition' => array('header-style' => array('side', 'side-toggle')),
						'selector' => '.corzo-header-side-nav{ width: #gdlr#; }' . 
							'.corzo-header-side-content.corzo-style-left{ margin-left: #gdlr#; }' .
							'.corzo-header-side-content.corzo-style-right{ margin-right: #gdlr#; }'
					),
					'side-header-side-padding' => array(
						'title' => esc_html__('Header Side Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '70px',
						'condition' => array('header-style' => 'side'),
						'selector' => '.corzo-header-side-nav.corzo-style-side{ padding-left: #gdlr#; padding-right: #gdlr#; }' . 
							'.corzo-header-side-nav.corzo-style-left .sf-vertical > li > ul.sub-menu{ padding-left: #gdlr#; }' .
							'.corzo-header-side-nav.corzo-style-right .sf-vertical > li > ul.sub-menu{ padding-right: #gdlr#; }'
					),
					'navigation-text-top-spacing' => array(
						'title' => esc_html__('Navigation Text Top / Bottom Spaces', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '40',
						'data-type' => 'pixel',
						'default' => '16px',
						'selector' => ' .corzo-navigation .sf-vertical > li{ padding-top: #gdlr#; padding-bottom: #gdlr#; }',
						'condition' => array( 'header-style' => array('side') )
					),
					'logo-right-image' => array(
						'title' => esc_html__('Header Right Image', 'corzo'),
						'type' => 'upload',
						'condition' => array('header-style' => array('bar', 'bar2')),
					),
					'logo-right-caption' => array(
						'title' => esc_html__('Header Right Caption', 'corzo'),
						'type' => 'text',
						'condition' => array('header-style' => array('bar', 'bar2')),
					),
					'logo-right-text' => array(
						'title' => esc_html__('Header Right Text', 'corzo'),
						'type' => 'text',
						'condition' => array('header-style' => array('bar', 'bar2')),
					),
					'logo-right-text' => array(
						'title' => esc_html__('Header Right Text', 'corzo'),
						'type' => 'textarea',
						'condition' => array('header-style' => array('bar', 'bar2')),
					),
					'logo-right-text-top-padding' => array(
						'title' => esc_html__('Header Right Text Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'data-min' => '0',
						'data-max' => '200',
						'default' => '30px',
						'condition' => array('header-style' => array('bar', 'bar2')),
						'selector' => '.corzo-header-style-bar .corzo-logo-right-text{ padding-top: #gdlr#; }'
					),
					'header-shadow-size' => array(
						'title' => esc_html__('Header Shadow Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
						'condition' => array( 'header-style' => 'plain' )
					),
					'header-shadow-color' => array(
						'title' => esc_html__('Header Shadow Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000',
						'selector-extra' => true,
						'selector' => '.corzo-header-style-plain{ ' . 
							'box-shadow: 0px 0px <header-shadow-size>t rgba(#gdlra#, 0.1); ' . 
							'-webkit-box-shadow: 0px 0px <header-shadow-size>t rgba(#gdlra#, 0.1); ' . 
							'-moz-box-shadow: 0px 0px <header-shadow-size>t rgba(#gdlra#, 0.1); }',
						'condition' => array( 'header-style' => 'plain' )
					)
				)
			);
		}
	}

	if( !function_exists('corzo_logo_options') ){
		function corzo_logo_options(){
			return array(
				'title' => esc_html__('Logo', 'corzo'),
				'options' => array(
					'enable-logo' => array(
						'title' => esc_html__('Enable Logo', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'logo' => array(
						'title' => esc_html__('Logo', 'corzo'),
						'type' => 'upload',
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'logo2x' => array(
						'title' => esc_html__('Logo 2x (Retina)', 'corzo'),
						'type' => 'upload',
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'logo-top-padding' => array(
						'title' => esc_html__('Logo Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '200',
						'data-type' => 'pixel',
						'default' => '20px',
						'selector' => '.corzo-logo{ padding-top: #gdlr#; }',
						'description' => esc_html__('This option will be omitted on splitted menu option.', 'corzo'),
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'logo-bottom-padding' => array(
						'title' => esc_html__('Logo Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '200',
						'data-type' => 'pixel',
						'default' => '20px',
						'selector' => '.corzo-logo{ padding-bottom: #gdlr#; }',
						'description' => esc_html__('This option will be omitted on splitted menu option.', 'corzo'),
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'logo-left-padding' => array(
						'title' => esc_html__('Logo Left Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-logo.corzo-item-pdlr{ padding-left: #gdlr#; }',
						'description' => esc_html__('Leave this field blank for default value.', 'corzo'),
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'max-logo-width' => array(
						'title' => esc_html__('Max Logo Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '200px',
						'selector' => '.corzo-logo-inner{ max-width: #gdlr#; }',
						'condition' => array( 'enable-logo' => 'enable' )
					),

					'mobile-logo' => array(
						'title' => esc_html__('Mobile/Tablet Logo', 'corzo'),
						'type' => 'upload',
						'description' => esc_html__('Leave this option blank to use the same logo.', 'corzo'),
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'max-tablet-logo-width' => array(
						'title' => esc_html__('Max Tablet Logo Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 999px){ .corzo-mobile-header .corzo-logo-inner{ max-width: #gdlr#; } }',
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'max-mobile-logo-width' => array(
						'title' => esc_html__('Max Mobile Logo Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-mobile-header .corzo-logo-inner{ max-width: #gdlr#; } }',
						'condition' => array( 'enable-logo' => 'enable' )
					),
					'mobile-logo-position' => array(
						'title' => esc_html__('Mobile Logo Position', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'logo-left' => esc_html__('Logo Left', 'corzo'),
							'logo-center' => esc_html__('Logo Center', 'corzo'),
							'logo-right' => esc_html__('Logo Right', 'corzo'),
						),
						'condition' => array( 'enable-logo' => 'enable' )
					),
				
				)
			);
		}
	}

	if( !function_exists('corzo_navigation_options') ){
		function corzo_navigation_options(){
			return array(
				'title' => esc_html__('Navigation', 'corzo'),
				'options' => array(
					'main-navigation-top-padding' => array(
						'title' => esc_html__('Main Navigation Top Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '200',
						'data-type' => 'pixel',
						'default' => '25px',
						'selector' => '.corzo-navigation{ padding-top: #gdlr#; }' . 
							'.corzo-navigation-top{ top: #gdlr#; }'
					),
					'main-navigation-bottom-padding' => array(
						'title' => esc_html__('Main Navigation Bottom Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '200',
						'data-type' => 'pixel',
						'default' => '20px',
						'selector' => '.corzo-navigation .sf-menu > li > a{ padding-bottom: #gdlr#; }'
					),
					'main-navigation-item-right-padding' => array(
						'title' => esc_html__('Main Navigation Item Right Padding', 'corzo'),
						'type' => 'fontslider',
						'data-min' => '0',
						'data-max' => '200',
						'data-type' => 'pixel',
						'default' => '0px',
						'selector' => '.corzo-navigation .corzo-main-menu{ padding-right: #gdlr#; }'
					),
					'main-navigation-right-padding' => array(
						'title' => esc_html__('Main Navigation Wrap Right Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-navigation.corzo-item-pdlr{ padding-right: #gdlr#; }',
						'description' => esc_html__('Leave this field blank for default value.', 'corzo'),
					),
					'enable-main-navigation-submenu-indicator' => array(
						'title' => esc_html__('Enable Main Navigation Submenu Indicator', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable',
					),
					'navigation-right-top-margin' => array(
						'title' => esc_html__('Navigation Right ( search/cart/button ) Top Margin ', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-right-wrap{ margin-top: #gdlr#; }'
					),
					'enable-main-navigation-search' => array(
						'title' => esc_html__('Enable Main Navigation Search', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
					),
					'main-navigation-search-icon' => array(
						'title' => esc_html__('Main Navigation Search Icon', 'corzo'),
						'type' => 'text',
						'default' => 'fa fa-search',
						'condition' => array('enable-main-navigation-search' => 'enable')
					),
					'main-navigation-search-icon-top-margin' => array(
						'title' => esc_html__('Main Navigation Search Icon Top Margin', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-search{ margin-top: #gdlr#; }',
						'condition' => array('enable-main-navigation-search' => 'enable')
					),
					'enable-main-navigation-cart' => array(
						'title' => esc_html__('Enable Main Navigation Cart ( Woocommerce )', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'description' => esc_html__('The icon only shows if the woocommerce plugin is activated', 'corzo')
					),
					'main-navigation-cart-icon' => array(
						'title' => esc_html__('Main Navigation Cart Icon', 'corzo'),
						'type' => 'text',
						'default' => 'fa fa-shopping-cart',
						'condition' => array('enable-main-navigation-search' => 'enable')
					),
					'main-navigation-cart-icon-top-margin' => array(
						'title' => esc_html__('Main Navigation Cart Icon Top Margin', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel', 
						'selector' => '.corzo-main-menu-cart{ margin-top: #gdlr#; }',
						'condition' => array('enable-main-navigation-search' => 'enable')
					),
					'enable-main-navigation-right-button' => array(
						'title' => esc_html__('Enable Main Navigation Right Button', 'corzo'),
						'type' => 'checkbox',
						'default' => 'disable',
						'description' => esc_html__('This option will be ignored on header side style', 'corzo')
					),
					'main-navigation-right-button-style' => array(
						'title' => esc_html__('Main Navigation Right Button Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'default' => esc_html__('Default', 'corzo'),
							'round' => esc_html__('Round', 'corzo'),
							'round-with-shadow' => esc_html__('Round With Shadow', 'corzo'),
						),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-text' => array(
						'title' => esc_html__('Main Navigation Right Button Text', 'corzo'),
						'type' => 'text',
						'default' => esc_html__('Buy Now', 'corzo'),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-link' => array(
						'title' => esc_html__('Main Navigation Right Button Link', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-link-target' => array(
						'title' => esc_html__('Main Navigation Right Button Link Target', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'_self' => esc_html__('Current Screen', 'corzo'),
							'_blank' => esc_html__('New Window', 'corzo'),
						),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-style-2' => array(
						'title' => esc_html__('Main Navigation Right Button Style 2', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'default' => esc_html__('Default', 'corzo'),
							'round' => esc_html__('Round', 'corzo'),
							'round-with-shadow' => esc_html__('Round With Shadow', 'corzo'),
						),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-text-2' => array(
						'title' => esc_html__('Main Navigation Right Button Text 2', 'corzo'),
						'type' => 'text',
						'default' => esc_html__('Buy Now', 'corzo'),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-link-2' => array(
						'title' => esc_html__('Main Navigation Right Button Link 2', 'corzo'),
						'type' => 'text',
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-link-target-2' => array(
						'title' => esc_html__('Main Navigation Right Button Link Target 2', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'_self' => esc_html__('Current Screen', 'corzo'),
							'_blank' => esc_html__('New Window', 'corzo'),
						),
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-top-margin' => array(
						'title' => esc_html__('Main Navigation Right Button Top Margin', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-right-button{ margin-top: #gdlr#; }',
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-tb-padding' => array(
						'title' => esc_html__('Main Navigation Right Button Top Bottom Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-right-button{ padding-top: #gdlr#; padding-bottom: #gdlr#; }',
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'main-navigation-right-button-lr-padding' => array(
						'title' => esc_html__('Main Navigation Right Button Left Right Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-right-button{ padding-left: #gdlr#; padding-right: #gdlr#; }',
						'condition' => array( 'enable-main-navigation-right-button' => 'enable' ) 
					),
					'right-menu-type' => array(
						'title' => esc_html__('Secondary/Mobile Menu Type', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'left' => esc_html__('Left Slide Menu', 'corzo'),
							'right' => esc_html__('Right Slide Menu', 'corzo'),
							'overlay' => esc_html__('Overlay Menu', 'corzo'),
						),
						'default' => 'right'
					),
					'right-menu-style' => array(
						'title' => esc_html__('Secondary/Mobile Menu Style', 'corzo'),
						'type' => 'combobox',
						'options' => array(
							'hamburger-with-border' => esc_html__('Hamburger With Border ( Font Awesome )', 'corzo'),
							'hamburger' => esc_html__('Hamburger', 'corzo'),
							'hamburger-small' => esc_html__('Hamburger Small', 'corzo'),
						),
						'default' => 'hamburger-with-border'
					),
					
				) // logo-options
			);
		}
	}

	if( !function_exists('corzo_fixed_navigation_options') ){
		function corzo_fixed_navigation_options(){
			return array(
				'title' => esc_html__('Fixed Navigation', 'corzo'),
				'options' => array(

					'enable-main-navigation-sticky' => array(
						'title' => esc_html__('Enable Fixed Navigation Bar', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
					),
					'enable-logo-on-main-navigation-sticky' => array(
						'title' => esc_html__('Enable Logo on Fixed Navigation Bar', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
						'description' => esc_html__('This option will be omitted when the logo is disabeld', 'corzo'),
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' )
					),
					'fixed-navigation-bar-logo' => array(
						'title' => esc_html__('Fixed Navigation Bar Logo', 'corzo'),
						'type' => 'upload',
						'description' => esc_html__('Leave blank to show default logo', 'corzo'),
						'condition' => array( 'enable-main-navigation-sticky' => 'enable', 'enable-logo-on-main-navigation-sticky' => 'enable' )
					),
					'fixed-navigation-bar-logo2x' => array(
						'title' => esc_html__('Fixed Navigation Bar Logo 2x (Retina)', 'corzo'),
						'type' => 'upload',
						'description' => esc_html__('Leave blank to show default logo', 'corzo'),
						'condition' => array( 'enable-main-navigation-sticky' => 'enable', 'enable-logo-on-main-navigation-sticky' => 'enable' )
					),
					'fixed-navigation-max-logo-width' => array(
						'title' => esc_html__('Fixed Navigation Max Logo Width', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
						'selector' => '.corzo-fixed-navigation.corzo-style-slide .corzo-logo-inner img{ max-height: none !important; }' .
							'.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-logo-inner, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-logo-inner{ max-width: #gdlr#; }' . 
							'.corzo-mobile-header.corzo-fixed-navigation .corzo-logo-inner{ max-width: #gdlr#; }'
					),
					'fixed-navigation-logo-top-padding' => array(
						'title' => esc_html__('Fixed Navigation Logo Top Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '20px',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
						'selector' => '.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-logo, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-logo{ padding-top: #gdlr#; }'
					),
					'fixed-navigation-logo-bottom-padding' => array(
						'title' => esc_html__('Fixed Navigation Logo Bottom Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '20px',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
						'selector' => '.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-logo, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-logo{ padding-bottom: #gdlr#; }'
					),
					'fixed-navigation-top-padding' => array(
						'title' => esc_html__('Fixed Navigation Top Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '30px',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
						'selector' => '.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-navigation, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-navigation{ padding-top: #gdlr#; }' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-navigation-top, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-navigation-top{ top: #gdlr#; }' .
							'.corzo-animate-fixed-navigation.corzo-navigation-bar-wrap .corzo-navigation{ padding-top: #gdlr#; }'
					),
					'fixed-navigation-bottom-padding' => array(
						'title' => esc_html__('Fixed Navigation Bottom Padding', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '25px',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
						'selector' => '.corzo-animate-fixed-navigation.corzo-header-style-plain .corzo-navigation .sf-menu > li > a, ' . 
							'.corzo-animate-fixed-navigation.corzo-header-style-boxed .corzo-navigation .sf-menu > li > a{ padding-bottom: #gdlr#; }' .
							'.corzo-animate-fixed-navigation.corzo-navigation-bar-wrap .corzo-navigation .sf-menu > li > a{ padding-bottom: #gdlr#; }' .
							'.corzo-animate-fixed-navigation .corzo-main-menu-right{ margin-bottom: #gdlr#; }'
					),
					'enable-fixed-navigation-slide-bar' => array(
						'title' => esc_html__('Enable Fixed Navigation Slide Bar', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable'
					),
					'fixed-navigation-slide-bar-top-margin' => array(
						'title' => esc_html__('Fixed Navigation Slide Bar Top Margin', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '',
						'selector' => '.corzo-fixed-navigation .corzo-navigation .corzo-navigation-slide-bar{ margin-top: #gdlr#; }',
						'condition' => array('enable-fixed-navigation-slide-bar' => 'enable')
					),
					'fixed-navigation-anchor-offset' => array(
						'title' => esc_html__('Fixed Navigation Anchor Offset ( Fixed Navigation Height )', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'default' => '75px',
						'condition' => array( 'enable-main-navigation-sticky' => 'enable' ),
					),
					'enable-mobile-navigation-sticky' => array(
						'title' => esc_html__('Enable Mobile Fixed Navigation Bar', 'corzo'),
						'type' => 'checkbox',
						'default' => 'enable',
					),

				)
			);
		}
	}

	if( !function_exists('corzo_header_color_options') ){
		function corzo_header_color_options(){

			return array(
				'title' => esc_html__('Header', 'corzo'),
				'options' => array(
					'top-bar-background-color' => array(
						'title' => esc_html__('Top Bar Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#222222',
						'selector' => '.corzo-top-bar-background{ background-color: #gdlr#; }'
					),
					'top-bar-bottom-border-color' => array(
						'title' => esc_html__('Top Bar Bottom Border Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-body .corzo-top-bar{ border-bottom-color: #gdlr#; }'
					),
					'top-bar-text-color' => array(
						'title' => esc_html__('Top Bar Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-top-bar{ color: #gdlr#; }'
					),
					'top-bar-link-color' => array(
						'title' => esc_html__('Top Bar Link Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-body .corzo-top-bar a{ color: #gdlr#; }'
					),
					'top-bar-link-hover-color' => array(
						'title' => esc_html__('Top Bar Link Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-body .corzo-top-bar a:hover{ color: #gdlr#; }'
					),
					'top-bar-social-color' => array(
						'title' => esc_html__('Top Bar Social Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-top-bar .corzo-top-bar-right-social a{ color: #gdlr#; }' .
							'.corzo-main-menu-right-wrap .corzo-top-bar-right-social a{ color: #gdlr#; }'
					),
					'top-bar-social-hover-color' => array(
						'title' => esc_html__('Top Bar Social Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#e44444',
						'selector' => '.corzo-top-bar .corzo-top-bar-right-social a:hover{ color: #gdlr#; }' .
							'.corzo-main-menu-right-wrap .corzo-top-bar-right-social a:hover{ color: #gdlr#; }'
					),
					'header-background-color' => array(
						'title' => esc_html__('Header Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-header-background, .corzo-sticky-menu-placeholder, .corzo-header-style-boxed.corzo-fixed-navigation, body.single-product .corzo-header-background-transparent{ background-color: #gdlr#; }'
					),
					'header-plain-bottom-border-color' => array(
						'title' => esc_html__('Header Bottom Border Color ( Header Plain Style )', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#e8e8e8',
						'selector' => '.corzo-header-wrap.corzo-header-style-plain{ border-color: #gdlr#; }'
					),
					'logo-background-color' => array(
						'title' => esc_html__('Logo Background Color ( Header Side Menu Toggle Style )', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector' => '.corzo-header-side-nav.corzo-style-side-toggle .corzo-logo{ background-color: #gdlr#; }'
					),
					'logo-right-text-caption' => array(
						'title' => esc_html__('Logo Right Text Caption', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#868686',
						'selector' => '.corzo-header-style-bar .corzo-logo-right-text-caption{ color: #gdlr#; }'
					),
					'logo-right-text-content' => array(
						'title' => esc_html__('Logo Right Text Caption', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#151515',
						'selector' => '.corzo-header-style-bar .corzo-logo-right-text-content{ color: #gdlr#; }'
					),
					'secondary-menu-icon-color' => array(
						'title' => esc_html__('Secondary Menu Icon Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#383838',
						'selector'=> '.corzo-top-menu-button i, .corzo-mobile-menu-button i{ color: #gdlr#; }' . 
							'.corzo-mobile-button-hamburger:before, ' . 
							'.corzo-mobile-button-hamburger:after, ' . 
							'.corzo-mobile-button-hamburger span, ' . 
							'.corzo-mobile-button-hamburger-small:before, ' . 
							'.corzo-mobile-button-hamburger-small:after, ' . 
							'.corzo-mobile-button-hamburger-small span{ background: #gdlr#; }'
					),
					'secondary-menu-border-color' => array(
						'title' => esc_html__('Secondary Menu Border Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#dddddd',
						'selector'=> '.corzo-main-menu-right .corzo-top-menu-button, .corzo-mobile-menu .corzo-mobile-menu-button{ border-color: #gdlr#; }'
					),
					'search-overlay-background-color' => array(
						'title' => esc_html__('Search Overlay Background Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000000',
						'selector'=> '.corzo-top-search-wrap{ background-color: #gdlr#; background-color: rgba(#gdlra#, 0.88); }'
					),
					'top-cart-background-color' => array(
						'title' => esc_html__('Top Cart Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-top-cart-content-wrap .corzo-top-cart-content{ background-color: #gdlr#; }'
					),
					'top-cart-title-color' => array(
						'title' => esc_html__('Top Cart Title Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#000000',
						'selector'=> '.corzo-top-cart-content-wrap .corzo-top-cart-title, .corzo-top-cart-item .corzo-top-cart-item-title, ' . 
							'.corzo-top-cart-item .corzo-top-cart-item-remove{ color: #gdlr#; }'
					),
					'top-cart-info-color' => array(
						'title' => esc_html__('Top Cart Info Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#6c6c6c',
						'selector'=> '.corzo-top-cart-content-wrap .woocommerce-Price-amount.amount{ color: #gdlr#; }'
					),
					'top-cart-view-cart-color' => array(
						'title' => esc_html__('Top Cart : View Cart Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#323232',
						'selector'=> '.corzo-body .corzo-top-cart-button-wrap .corzo-top-cart-button{ color: #gdlr#; }'
					),
					'top-cart-view-cart-background-color' => array(
						'title' => esc_html__('Top Cart : View Cart Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#f4f4f4',
						'selector'=> '.corzo-body .corzo-top-cart-button-wrap .corzo-top-cart-button{ background-color: #gdlr#; }'
					),
					'top-cart-checkout-color' => array(
						'title' => esc_html__('Top Cart : Checkout Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-body .corzo-top-cart-button-wrap .corzo-top-cart-button-2{ color: #gdlr#; }'
					),
					'top-cart-checkout-background-color' => array(
						'title' => esc_html__('Top Cart : Checkout Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#000000',
						'selector'=> '.corzo-body .corzo-top-cart-button-wrap .corzo-top-cart-button-2{ background-color: #gdlr#; }'
					),
					'breadcrumbs-text-color' => array(
						'title' => esc_html__('Breadcrumbs ( Plugin ) Text Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#c0c0c0',
						'selector'=> '.corzo-body .corzo-breadcrumbs, .corzo-body .corzo-breadcrumbs a span, ' . 
							'.gdlr-core-breadcrumbs-item, .gdlr-core-breadcrumbs-item a span{ color: #gdlr#; }'
					),
					'breadcrumbs-text-active-color' => array(
						'title' => esc_html__('Breadcrumbs ( Plugin ) Text Active Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#777777',
						'selector'=> '.corzo-body .corzo-breadcrumbs span, .corzo-body .corzo-breadcrumbs a:hover span, ' . 
							'.gdlr-core-breadcrumbs-item span, .gdlr-core-breadcrumbs-item a:hover span{ color: #gdlr#; }'
					),
				) // header-options
			);

		}
	}

	if( !function_exists('corzo_navigation_color_options') ){
		function corzo_navigation_color_options(){

			return array(
				'title' => esc_html__('Menu', 'corzo'),
				'options' => array(

					'navigation-bar-background-color' => array(
						'title' => esc_html__('Navigation Bar Background Color ( Header Bar Style )', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#f4f4f4',
						'selector' => '.corzo-navigation-background{ background-color: #gdlr#; }'
					),
					'navigation-slide-bar-color' => array(
						'title' => esc_html__('Navigation Slide Bar Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#2d9bea',
						'selector' => '.corzo-navigation .corzo-navigation-slide-bar, ' . 
							'.corzo-navigation .corzo-navigation-slide-bar-style-dot:before{ border-color: #gdlr#; }' . 
							'.corzo-navigation .corzo-navigation-slide-bar-style-dot-center:before{ border-color: #gdlr#; }' . 
							'.corzo-navigation .corzo-navigation-slide-bar:before{ border-bottom-color: #gdlr#; }'
					),
					'main-menu-description-color' => array(
						'title' => esc_html__('Main Menu Description Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#999999',
						'selector' => '.sf-menu > li > a .corzo-menu-item-description{ color: #gdlr#; transition: color 300ms; -moz-transition: color 300ms; -webkit-transition: color 300ms; }'
					),
					'main-menu-text-color' => array(
						'title' => esc_html__('Main Menu Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#999999',
						'selector' => '.sf-menu > li > a, .sf-vertical > li > a{ color: #gdlr#; }'
					),
					'main-menu-text-hover-color' => array(
						'title' => esc_html__('Main Menu Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#333333',
						'selector' => '.sf-menu > li > a:hover, ' . 
							'.sf-menu > li.current-menu-item > a, ' .
							'.sf-menu > li.current-menu-ancestor > a, ' .
							'.sf-vertical > li > a:hover, ' . 
							'.sf-vertical > li.current-menu-item > a, ' .
							'.sf-vertical > li.current-menu-ancestor > a{ color: #gdlr#; }'
					),
					'sub-menu-background-color' => array(
						'title' => esc_html__('Sub Menu Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#2e2e2e',
						'selector'=> '.sf-menu > .corzo-normal-menu li, .sf-menu > .corzo-mega-menu > .sf-mega, ' . 
							'.sf-vertical ul.sub-menu li, ul.sf-menu > .menu-item-language li{ background-color: #gdlr#; }'
					),
					'sub-menu-text-color' => array(
						'title' => esc_html__('Sub Menu Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#bebebe',
						'selector'=> '.sf-menu > li > .sub-menu a, .sf-menu > .corzo-mega-menu > .sf-mega a, ' . 
							'.sf-vertical ul.sub-menu li a{ color: #gdlr#; }'
					),
					'sub-menu-text-hover-color' => array(
						'title' => esc_html__('Sub Menu Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.sf-menu > li > .sub-menu a:hover, ' . 
							'.sf-menu > li > .sub-menu .current-menu-item > a, ' . 
							'.sf-menu > li > .sub-menu .current-menu-ancestor > a, '.
							'.sf-menu > .corzo-mega-menu > .sf-mega a:hover, '.
							'.sf-menu > .corzo-mega-menu > .sf-mega .current-menu-item > a, '.
							'.sf-vertical > li > .sub-menu a:hover, ' . 
							'.sf-vertical > li > .sub-menu .current-menu-item > a, ' . 
							'.sf-vertical > li > .sub-menu .current-menu-ancestor > a{ color: #gdlr#; }'
					),
					'sub-menu-text-hover-background-color' => array(
						'title' => esc_html__('Sub Menu Text Hover Background', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#393939',
						'selector'=> '.sf-menu > li > .sub-menu a:hover, ' . 
							'.sf-menu > li > .sub-menu .current-menu-item > a, ' . 
							'.sf-menu > li > .sub-menu .current-menu-ancestor > a, '.
							'.sf-menu > .corzo-mega-menu > .sf-mega a:hover, '.
							'.sf-menu > .corzo-mega-menu > .sf-mega .current-menu-item > a, '.
							'.sf-vertical > li > .sub-menu a:hover, ' . 
							'.sf-vertical > li > .sub-menu .current-menu-item > a, ' . 
							'.sf-vertical > li > .sub-menu .current-menu-ancestor > a{ background-color: #gdlr#; }'
					),
					'sub-mega-menu-title-color' => array(
						'title' => esc_html__('Sub Mega Menu Title Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-navigation .sf-menu > .corzo-mega-menu .sf-mega-section-inner > a{ color: #gdlr#; }'
					),
					'sub-mega-menu-divider-color' => array(
						'title' => esc_html__('Sub Mega Menu Divider Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#424242',
						'selector'=> '.corzo-navigation .sf-menu > .corzo-mega-menu .sf-mega-section{ border-color: #gdlr#; }'
					),
					'sub-menu-shadow-size' => array(
						'title' => esc_html__('Sub Menu Shadow Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
					),
					'sub-menu-shadow-opacity' => array(
						'title' => esc_html__('Sub Menu Shadow Opacity', 'corzo'),
						'type' => 'text',
						'default' => '0.15',
					),
					'sub-menu-shadow-color' => array(
						'title' => esc_html__('Sub Menu Shadow Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000',
						'selector-extra' => true,
						'selector' => '.corzo-navigation .sf-menu > .corzo-normal-menu .sub-menu, .corzo-navigation .sf-menu > .corzo-mega-menu .sf-mega{ ' . 
							'box-shadow: 0px 0px <sub-menu-shadow-size>t rgba(#gdlra#, <sub-menu-shadow-opacity>t); ' .
							'-webkit-box-shadow: 0px 0px <sub-menu-shadow-size>t rgba(#gdlra#, <sub-menu-shadow-opacity>t); ' .
							'-moz-box-shadow: 0px 0px <sub-menu-shadow-size>t rgba(#gdlra#, <sub-menu-shadow-opacity>t); }',
					),
					'fixed-menu-shadow-size' => array(
						'title' => esc_html__('Fixed Menu Shadow Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
					),
					'fixed-menu-shadow-opacity' => array(
						'title' => esc_html__('Fixed Menu Shadow Opacity', 'corzo'),
						'type' => 'text',
						'default' => '0.15',
					),
					'fixed-menu-shadow-color' => array(
						'title' => esc_html__('Fixed Menu Shadow Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000',
						'selector-extra' => true,
						'selector' => '.corzo-fixed-navigation.corzo-style-fixed, .corzo-fixed-navigation.corzo-style-slide{ ' . 
							'box-shadow: 0px 0px <fixed-menu-shadow-size>t rgba(#gdlra#, <fixed-menu-shadow-opacity>t); ' .
							'-webkit-box-shadow: 0px 0px <fixed-menu-shadow-size>t rgba(#gdlra#, <fixed-menu-shadow-opacity>t); ' .
							'-moz-box-shadow: 0px 0px <fixed-menu-shadow-size>t rgba(#gdlra#, <fixed-menu-shadow-opacity>t); }',
					),
					'side-menu-text-color' => array(
						'title' => esc_html__('Side Menu Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#979797',
						'selector'=> '.mm-navbar .mm-title, .mm-navbar .mm-btn, ul.mm-listview li > a, ul.mm-listview li > span{ color: #gdlr#; }' . 
							'ul.mm-listview li a{ border-color: #gdlr#; }' .
							'.mm-arrow:after, .mm-next:after, .mm-prev:before{ border-color: #gdlr#; }'
					),
					'side-menu-text-hover-color' => array(
						'title' => esc_html__('Side Menu Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.mm-navbar .mm-title:hover, .mm-navbar .mm-btn:hover, ' .
							'ul.mm-listview li a:hover, ul.mm-listview li > span:hover, ' . 
							'ul.mm-listview li.current-menu-item > a, ul.mm-listview li.current-menu-ancestor > a, ul.mm-listview li.current-menu-ancestor > span{ color: #gdlr#; }'
					),
					'side-menu-background-color' => array(
						'title' => esc_html__('Side Menu Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#1f1f1f',
						'selector'=> '.mm-menu{ background-color: #gdlr#; }'
					),
					'side-menu-border-color' => array(
						'title' => esc_html__('Side Menu Border Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#626262',
						'selector'=> 'ul.mm-listview li{ border-color: #gdlr#; }'
					),
					'overlay-menu-background-color' => array(
						'title' => esc_html__('Overlay Menu Background Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000000',
						'selector'=> '.corzo-overlay-menu-content{ background-color: #gdlr#; background-color: rgba(#gdlra#, 0.88); }'
					),
					'overlay-menu-border-color' => array(
						'title' => esc_html__('Overlay Menu Border Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#424242',
						'selector'=> '.corzo-overlay-menu-content ul.menu > li, .corzo-overlay-menu-content ul.sub-menu ul.sub-menu{ border-color: #gdlr#; }'
					),
					'overlay-menu-text-color' => array(
						'title' => esc_html__('Overlay Menu Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-overlay-menu-content ul li a, .corzo-overlay-menu-content .corzo-overlay-menu-close{ color: #gdlr#; }'
					),
					'overlay-menu-text-hover-color' => array(
						'title' => esc_html__('Overlay Menu Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#a8a8a8',
						'selector'=> '.corzo-overlay-menu-content ul li a:hover{ color: #gdlr#; }'
					),
					'anchor-bullet-background-color' => array(
						'title' => esc_html__('Anchor Bullet Background', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#777777',
						'selector'=> '.corzo-bullet-anchor a:before{ background-color: #gdlr#; }'
					),
					'anchor-bullet-background-active-color' => array(
						'title' => esc_html__('Anchor Bullet Background Active', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-bullet-anchor a:hover, .corzo-bullet-anchor a.current-menu-item{ border-color: #gdlr#; }' .
							'.corzo-bullet-anchor a:hover:before, .corzo-bullet-anchor a.current-menu-item:before{ background: #gdlr#; }'
					),		
				) // navigation-menu-options
			);	

		}
	}

	if( !function_exists('corzo_navigation_right_color_options') ){
		function corzo_navigation_right_color_options(){

			return array(
				'title' => esc_html__('Navigation Right', 'corzo'),
				'options' => array(

					'navigation-bar-right-icon-color' => array(
						'title' => esc_html__('Navigation Bar Right Icon Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#383838',
						'selector'=> '.corzo-main-menu-search i, .corzo-main-menu-cart i{ color: #gdlr#; }'
					),
					'woocommerce-cart-icon-number-background' => array(
						'title' => esc_html__('Woocommmerce Cart\'s Icon Number Background', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#bd584e',
						'selector'=> '.corzo-main-menu-cart > .corzo-top-cart-count{ background-color: #gdlr#; }'
					),
					'woocommerce-cart-icon-number-color' => array(
						'title' => esc_html__('Woocommmerce Cart\'s Icon Number Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#ffffff',
						'selector'=> '.corzo-main-menu-cart > .corzo-top-cart-count{ color: #gdlr#; }'
					),
					'navigation-right-button-text-color' => array(
						'title' => esc_html__('Navigation Right Button Text Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#333333',
						'selector'=> '.corzo-body .corzo-main-menu-right-button{ color: #gdlr#; }'
					),
					'navigation-right-button-text-hover-color' => array(
						'title' => esc_html__('Navigation Right Button Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#555555',
						'selector'=> '.corzo-body .corzo-main-menu-right-button:hover{ color: #gdlr#; }'
					),
					'navigation-right-button-background-color' => array(
						'title' => esc_html__('Navigation Right Button Background Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '',
						'selector'=> '.corzo-body .corzo-main-menu-right-button{ background-color: #gdlr#; }'
					),
					'navigation-right-button-background-hover-color' => array(
						'title' => esc_html__('Navigation Right Button Background Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '',
						'selector'=> '.corzo-body .corzo-main-menu-right-button:hover{ background-color: #gdlr#; }'
					),
					'navigation-right-button-border-color' => array(
						'title' => esc_html__('Navigation Right Button Border Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#333333',
						'selector'=> '.corzo-body .corzo-main-menu-right-button{ border-color: #gdlr#; }'
					),
					'navigation-right-button-border-hover-color' => array(
						'title' => esc_html__('Navigation Right Button Border Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'default' => '#555555',
						'selector'=> '.corzo-body .corzo-main-menu-right-button:hover{ border-color: #gdlr#; }'
					),
					'navigation-right-button2-text-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Text Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2{ color: #gdlr#; }'
					),
					'navigation-right-button2-text-hover-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Text Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2:hover{ color: #gdlr#; }'
					),
					'navigation-right-button2-background-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Background Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2{ background-color: #gdlr#; }'
					),
					'navigation-right-button2-background-hover-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Background Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2:hover{ background-color: #gdlr#; }'
					),
					'navigation-right-button2-border-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Border Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2{ border-color: #gdlr#; }'
					),
					'navigation-right-button2-border-hover-color' => array(
						'title' => esc_html__('Navigation Right Button 2 Border Hover Color', 'corzo'),
						'type' => 'colorpicker',
						'selector'=> '.corzo-body .corzo-main-menu-right-button.corzo-button-2:hover{ border-color: #gdlr#; }'
					),
					'navigation-right-button-shadow-color' => array(
						'title' => esc_html__('Main Navigation Right Button Shadow Color', 'corzo'),
						'type' => 'colorpicker',
						'data-type' => 'rgba',
						'default' => '#000',
						'selector' => '.corzo-main-menu-right-button.corzo-style-round-with-shadow{ box-shadow: 0px 4px 18px rgba(#gdlra#, 0.11); -webkit-box-shadow: 0px 4px 18px rgba(#gdlra#, 0.11); } '
					),

				)
			);

		}
	}