<?php
	/*	
	*	Goodlayers Option
	*	---------------------------------------------------------------------
	*	This file store an array of theme options
	*	---------------------------------------------------------------------
	*/	

	$corzo_admin_option->add_element(array(
	
		// typography head section
		'title' => esc_html__('Typography', 'corzo'),
		'slug' => 'corzo_typography',
		'icon' => get_template_directory_uri() . '/include/options/images/typography.png',
		'options' => array(
		
			// starting the subnav
			'font-family' => array(
				'title' => esc_html__('Font Family', 'corzo'),
				'options' => array(
					'google-font-display' => array(
						'title' => esc_html__('Google Font Display', 'corzo'),
						'type' => 'combobox',
						'options' => array( 
							'' => esc_html__('Auto', 'corzo'),
							'block' => esc_html__('Block', 'corzo'),
							'swap' => esc_html__('Swap', 'corzo'),
							'fallback' => esc_html__('Fall Back', 'corzo'),
							'optional' => esc_html__('Optional', 'corzo'),
						),
						'default' => 'optional',
						'description' => wp_kses(__('This option could increase the page speed result of your site. You can learn more about the font display <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display" target="_blank" >here</a>', 'corzo'), array('a'=>array('href'=>array(), 'target'=>array())))
					),
					'heading-font' => array(
						'title' => esc_html__('Heading Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body h1, .corzo-body h2, .corzo-body h3, ' . 
							'.corzo-body h4, .corzo-body h5, .corzo-body h6, .corzo-body .corzo-title-font,' .
							'.corzo-body .gdlr-core-title-font{ font-family: #gdlr#; }' . 
							'.woocommerce-breadcrumb, .woocommerce span.onsale, ' .
							'.single-product.woocommerce div.product p.price .woocommerce-Price-amount, .single-product.woocommerce #review_form #respond label{ font-family: #gdlr#; }'
					),
					'navigation-font' => array(
						'title' => esc_html__('Navigation Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-navigation .sf-menu > li > a, .corzo-navigation .sf-vertical > li > a, .corzo-navigation-font{ font-family: #gdlr#; }'
					),	
					'content-font' => array(
						'title' => esc_html__('Content Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body, .corzo-body .gdlr-core-content-font, ' . 
							'.corzo-body input, .corzo-body textarea, .corzo-body button, .corzo-body select, ' . 
							'.corzo-body .corzo-content-font, .gdlr-core-audio .mejs-container *{ font-family: #gdlr#; }'
					),
					'info-font' => array(
						'title' => esc_html__('Info Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body .gdlr-core-info-font, .corzo-body .corzo-info-font{ font-family: #gdlr#; }'
					),
					'blog-info-font' => array(
						'title' => esc_html__('Blog Info Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body .gdlr-core-blog-info-font, .corzo-body .corzo-blog-info-font{ font-family: #gdlr#; }'
					),
					'quote-font' => array(
						'title' => esc_html__('Quote Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body .gdlr-core-quote-font{ font-family: #gdlr#; }'
					),
					'testimonial-font' => array(
						'title' => esc_html__('Testimonial, Blockquote Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'default' => 'Open Sans',
						'selector' => '.corzo-body .gdlr-core-testimonial-content, blockquote{ font-family: #gdlr#; }'
					),
					'additional-font' => array(
						'title' => esc_html__('Additional Font', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'customizer' => false,
						'default' => 'Georgia, serif',
						'description' => esc_html__('Additional font you want to include for custom css.', 'corzo')
					),
					'additional-font2' => array(
						'title' => esc_html__('Additional Font2', 'corzo'),
						'type' => 'font',
						'data-type' => 'font',
						'customizer' => false,
						'default' => 'Georgia, serif',
						'description' => esc_html__('Additional font you want to include for custom css.', 'corzo')
					),
					
				) // font-family-options
			), // font-family-nav
			
			'font-size' => array(
				'title' => esc_html__('Font Size', 'corzo'),
				'options' => array(
				
					'h1-font-size' => array(
						'title' => esc_html__('H1 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '52px',
						'selector' => '.corzo-body h1{ font-size: #gdlr#; }' 
					),					
					'h2-font-size' => array(
						'title' => esc_html__('H2 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '48px',
						'selector' => '.corzo-body h2, #poststuff .gdlr-core-page-builder-body h2{ font-size: #gdlr#; }' 
					),					
					'h3-font-size' => array(
						'title' => esc_html__('H3 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '36px',
						'selector' => '.corzo-body h3{ font-size: #gdlr#; }' 
					),					
					'h4-font-size' => array(
						'title' => esc_html__('H4 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '28px',
						'selector' => '.corzo-body h4{ font-size: #gdlr#; }' 
					),					
					'h5-font-size' => array(
						'title' => esc_html__('H5 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '22px',
						'selector' => '.corzo-body h5{ font-size: #gdlr#; }' 
					),					
					'h6-font-size' => array(
						'title' => esc_html__('H6 Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '18px',
						'selector' => '.corzo-body h6{ font-size: #gdlr#; }' 
					),				
					'header-font-weight' => array(
						'title' => esc_html__('Header Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-body h1, .corzo-body h2, .corzo-body h3, .corzo-body h4, .corzo-body h5, .corzo-body h6{ font-weight: #gdlr#; }' . 
							'#poststuff .gdlr-core-page-builder-body h1, #poststuff .gdlr-core-page-builder-body h2{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),
					'content-font-size' => array(
						'title' => esc_html__('Content Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-body{ font-size: #gdlr#; }' 
					),
					'content-font-weight' => array(
						'title' => esc_html__('Content Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-body{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),
					'content-line-height' => array(
						'title' => esc_html__('Content Line Height', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '1.7',
						'selector' => '.corzo-body, .corzo-line-height, .gdlr-core-line-height{ line-height: #gdlr#; }'
					),
					
				) // font-size-options
			), // font-size-nav			
			
			'mobile-font-size' => array(
				'title' => esc_html__('Mobile Font Size', 'corzo'),
				'options' => array(

					'mobile-h1-font-size' => array(
						'title' => esc_html__('Mobile H1 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h1{ font-size: #gdlr#; } }' 
					),
					'mobile-h2-font-size' => array(
						'title' => esc_html__('Mobile H2 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h2, #poststuff .gdlr-core-page-builder-body h2{ font-size: #gdlr#; } }' 
					),
					'mobile-h3-font-size' => array(
						'title' => esc_html__('Mobile H3 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h3{ font-size: #gdlr#; } }' 
					),
					'mobile-h4-font-size' => array(
						'title' => esc_html__('Mobile H4 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h4{ font-size: #gdlr#; } }' 
					),
					'mobile-h5-font-size' => array(
						'title' => esc_html__('Mobile H5 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h5{ font-size: #gdlr#; } }' 
					),
					'mobile-h6-font-size' => array(
						'title' => esc_html__('Mobile H6 Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body h6{ font-size: #gdlr#; } }' 
					),					
					'mobile-content-font-size' => array(
						'title' => esc_html__('Mobile Content Font Size', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '@media only screen and (max-width: 767px){ .corzo-body{ font-size: #gdlr#; } }' 
					),

				)
			),

			'navigation-font-size' => array(
				'title' => esc_html__('Navigation Font Size', 'corzo'),
				'options' => array(	
					'navigation-font-size' => array(
						'title' => esc_html__('Navigation Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '14px',
						'selector' => '.corzo-navigation .sf-menu > li > a, .corzo-navigation .sf-vertical > li > a{ font-size: #gdlr#; }' 
					),	
					'navigation-font-weight' => array(
						'title' => esc_html__('Navigation Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '800',
						'selector' => '.corzo-navigation .sf-menu > li > a, .corzo-navigation .sf-vertical > li > a{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'navigation-font-letter-spacing' => array(
						'title' => esc_html__('Navigation Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-navigation .sf-menu > li > a, .corzo-navigation .sf-vertical > li > a{ letter-spacing: #gdlr#; }'
					),
					'navigation-text-transform' => array(
						'title' => esc_html__('Navigation Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-navigation .sf-menu > li > a, .corzo-navigation .sf-vertical > li > a{ text-transform: #gdlr#; }',
					),
					'sub-navigation-font-size' => array(
						'title' => esc_html__('Sub Navigation Font Size', 'corzo'),
						'type' => 'text',
						'data-input-type' => 'pixel',
						'data-type' => 'pixel',
						'selector' => '.corzo-navigation .sf-menu > .corzo-normal-menu .sub-menu, .corzo-navigation .sf-menu>.corzo-mega-menu .sf-mega-section-inner .sub-menu a{ font-size: #gdlr#; }' 
					),
					'sub-navigation-font-weight' => array(
						'title' => esc_html__('Sub Navigation Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'default' => '800',
						'selector' => '.corzo-navigation .sf-menu > .corzo-normal-menu .sub-menu, .corzo-navigation .sf-menu>.corzo-mega-menu .sf-mega-section-inner .sub-menu a{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'sub-navigation-font-letter-spacing' => array(
						'title' => esc_html__('Sub Navigation Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-navigation .sf-menu > .corzo-normal-menu .sub-menu, .corzo-navigation .sf-menu>.corzo-mega-menu .sf-mega-section-inner .sub-menu a{ letter-spacing: #gdlr#; }'
					),
					'sub-navigation-text-transform' => array(
						'title' => esc_html__('Sub Navigation Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-navigation .sf-menu > .corzo-normal-menu .sub-menu, .corzo-navigation .sf-menu>.corzo-mega-menu .sf-mega-section-inner .sub-menu a{ text-transform: #gdlr#; }',
					),
					'navigation-right-button-font-size' => array(
						'title' => esc_html__('Navigation Right Button Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '11px',
						'selector' => '.corzo-main-menu-right-button{ font-size: #gdlr#; }' 
					),	
					'navigation-right-button-font-weight' => array(
						'title' => esc_html__('Navigation Right Button Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-main-menu-right-button{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'navigation-right-button-font-letter-spacing' => array(
						'title' => esc_html__('Navigation Right Button Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-main-menu-right-button{ letter-spacing: #gdlr#; }'
					),
					'navigation-right-button-text-transform' => array(
						'title' => esc_html__('Navigation Right Button Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-main-menu-right-button{ text-transform: #gdlr#; }',
					),
				) // font-size-options
			), // font-size-nav
			
			'footer-font-size' => array(
				'title' => esc_html__('Sidebar / Footer Font Size', 'corzo'),
				'options' => array(
					
					'sidebar-title-font-size' => array(
						'title' => esc_html__('Sidebar Title Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '13px',
						'selector' => '.corzo-sidebar-area .corzo-widget-title{ font-size: #gdlr#; }' 
					),
					'sidebar-title-font-weight' => array(
						'title' => esc_html__('Sidebar Title Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-sidebar-area .corzo-widget-title{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'sidebar-title-font-letter-spacing' => array(
						'title' => esc_html__('Sidebar Title Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-sidebar-area .corzo-widget-title{ letter-spacing: #gdlr#; }'
					),
					'sidebar-title-text-transform' => array(
						'title' => esc_html__('Sidebar Title Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-sidebar-area .corzo-widget-title{ text-transform: #gdlr#; }',
					),
					'footer-title-font-size' => array(
						'title' => esc_html__('Footer Title Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '13px',
						'selector' => '.corzo-footer-wrapper .corzo-widget-title{ font-size: #gdlr#; }' 
					),
					'footer-title-font-weight' => array(
						'title' => esc_html__('Footer Title Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-footer-wrapper .corzo-widget-title{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'footer-title-font-letter-spacing' => array(
						'title' => esc_html__('Footer Title Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-footer-wrapper .corzo-widget-title{ letter-spacing: #gdlr#; }'
					),
					'footer-title-text-transform' => array(
						'title' => esc_html__('Footer Title Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-footer-wrapper .corzo-widget-title{ text-transform: #gdlr#; }',
					),
					'footer-font-size' => array(
						'title' => esc_html__('Footer Content Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '15px',
						'selector' => '.corzo-footer-wrapper{ font-size: #gdlr#; }' 
					),
					'footer-content-font-weight' => array(
						'title' => esc_html__('Footer Content Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-footer-wrapper .widget_text{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'footer-content-text-transform' => array(
						'title' => esc_html__('Footer Content Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'none',
						'selector' => '.corzo-footer-wrapper .widget_text{ text-transform: #gdlr#; }',
					),
					'copyright-font-size' => array(
						'title' => esc_html__('Copyright Font Size', 'corzo'),
						'type' => 'fontslider',
						'data-type' => 'pixel',
						'default' => '14px',
						'selector' => '.corzo-copyright-text, .corzo-copyright-left, .corzo-copyright-right{ font-size: #gdlr#; }' 
					),
					'copyright-font-weight' => array(
						'title' => esc_html__('Copyright Font Weight', 'corzo'),
						'type' => 'text',
						'data-type' => 'text',
						'selector' => '.corzo-copyright-text, .corzo-copyright-left, .corzo-copyright-right{ font-weight: #gdlr#; }',
						'description' => esc_html__('Eg. lighter, bold, normal, 300, 400, 600, 700, 800', 'corzo')
					),	
					'copyright-font-letter-spacing' => array(
						'title' => esc_html__('Copyright Font Letter Spacing', 'corzo'),
						'type' => 'text',
						'data-type' => 'pixel',
						'data-input-type' => 'pixel',
						'selector' => '.corzo-copyright-text, .corzo-copyright-left, .corzo-copyright-right{ letter-spacing: #gdlr#; }'
					),
					'copyright-text-transform' => array(
						'title' => esc_html__('Copyright Text Transform', 'corzo'),
						'type' => 'combobox',
						'data-type' => 'text',
						'options' => array(
							'uppercase' => esc_html__('Uppercase', 'corzo'),
							'lowercase' => esc_html__('Lowercase', 'corzo'),
							'capitalize' => esc_html__('Capitalize', 'corzo'),
							'none' => esc_html__('None', 'corzo'),
						),
						'default' => 'uppercase',
						'selector' => '.corzo-copyright-text, .corzo-copyright-left, .corzo-copyright-right{ text-transform: #gdlr#; }',
					),
				)
			),

			'font-upload' => array(
				'title' => esc_html__('Font Uploader', 'corzo'),
				'reload-after' => true,
				'customizer' => false,
				'options' => array(
					
					'font-upload' => array(
						'title' => esc_html__('Upload Fonts', 'corzo'),
						'type' => 'custom',
						'item-type' => 'fontupload',
						'wrapper-class' => 'gdlr-core-fullsize',
					),
					
				) // fontupload-options
			), // fontupload-nav
		
		) // typography-options
		
	), 4);